/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.enumeration.SELLER_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.data.Seller;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetSellerID
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetSellerID.class.getName());
    private String sellerID;
    private int sellerType;

    public SetSellerID(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        byte status;
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            status = this.parseParams();
            if (status != 0) return status;
            ItemModel item = fm.getParagon().getLastValidItem();
            if (item == null) return 96;
            item.setSeller(new Seller(this.sellerType == 0 ? SELLER_TYPE.DIC : SELLER_TYPE.IC_DPH, this.sellerID));
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
        fm.getParagon().appendBinaryData(this.binary);
        fm.saveDbParagon();
        return status;
    }

    @Override
    protected byte parseParams() {
        block10: {
            block9: {
                FmFiscalMemory fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 2: 
                    case 32: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.sellerID = this.params[0];
                    if (this.sellerID.length() <= 12) break block9;
                    return 96;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            if (Function.matches(this.sellerID, "^[a-zA-Z0-9]*$")) break block10;
            return 96;
        }
        this.sellerType = Integer.parseInt(this.params[1]);
        if (this.sellerType < 0 || this.sellerType > 1) {
            return 96;
        }
        return 0;
    }
}

