/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetTransactionID
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetTransactionID.class.getName());
    public String transactionID;

    public SetTransactionID(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        byte status;
        block4: {
            if (ppekk == null) {
                return -3;
            }
            try {
                if (!fm.isDbOk()) return -2;
                status = this.parseParams();
                if (status != 0) return status;
                if (!fm.isTransactionInUse(this.transactionID)) break block4;
                return 96;
            }
            catch (FmStoreToDbException e) {
                logger.fatal("Database error", (Throwable)e);
                return -2;
            }
        }
        fm.getParagon().setTransactionID(this.transactionID);
        fm.getParagon().appendBinaryData(this.binary);
        fm.saveDbParagon();
        return status;
    }

    @Override
    protected byte parseParams() {
        block8: {
            FmFiscalMemory fm = this.eKasa.getFm();
            switch (fm.getFmState()) {
                case 2: 
                case 3: 
                case 4: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    return 52;
                }
            }
            if (this.params.length != 1) {
                return 32;
            }
            try {
                this.transactionID = this.params[0];
                if (this.transactionID.length() <= 50) break block8;
                return 96;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        if (Function.matches(this.transactionID, ".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

