/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.ItemBarcode;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.ReceiptItemContainerReturn;
import sk.singularisdev.ekasask.command.ReceiptItemCorrect;
import sk.singularisdev.ekasask.command.ReceiptItemDepositReturn;
import sk.singularisdev.ekasask.command.ReceiptItemDiscount;
import sk.singularisdev.ekasask.command.ReceiptItemReturn;
import sk.singularisdev.ekasask.command.ReceiptItemSale;
import sk.singularisdev.ekasask.command.ReceiptItemVoucher;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.SPECIAL_REGULATION;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.fm.data.Seller;

public class ItemModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description;
    private String totalPrice;
    private String totalPriceZ;
    private String unitPrice;
    private String units;
    private String quantity;
    private String discountValue;
    private String discountRealValue;
    private String referenceId;
    private String preline;
    private String postline;
    private char vat;
    private int rowNumber;
    private int discountType;
    private int vatFlag;
    private int paymentFlag;
    private SPECIAL_REGULATION popis0DPH;
    private ItemType itemType;
    private Seller seller;
    private Object[] nonSpecificParams;

    public ItemModel(Builder builder) {
        this.rowNumber = builder.rowNumber;
        this.description = builder.description;
        this.totalPrice = builder.totalPrice;
        this.totalPriceZ = builder.totalPriceZ;
        this.vat = builder.vat;
        this.vatFlag = builder.vatFlag;
        this.paymentFlag = builder.paymentFlag;
        this.unitPrice = builder.unitPrice;
        this.quantity = builder.quantity;
        this.units = builder.units;
        this.discountType = builder.discountType;
        this.discountValue = builder.discountValue;
        this.discountRealValue = builder.discountRealValue;
        this.referenceId = builder.referenceId;
        this.itemType = builder.itemType;
        this.preline = builder.preline;
        this.postline = builder.postline;
        this.nonSpecificParams = builder.nonSpecificParams;
        this.popis0DPH = builder.popis0DPH;
        this.seller = builder.seller;
    }

    public void setPopis0DPH(SPECIAL_REGULATION popis0dph) {
        this.popis0DPH = popis0dph;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTotalPrice() {
        return this.totalPrice;
    }

    public String getTotalPriceZ() {
        return this.totalPriceZ;
    }

    public String getUnitPrice() {
        return this.unitPrice;
    }

    public String getUnits() {
        return this.units;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getDiscountValue() {
        return this.discountValue;
    }

    public String getDiscountRealValue() {
        return this.discountRealValue;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getPreline() {
        return this.preline;
    }

    public String getPostline() {
        return this.postline;
    }

    public char getVat() {
        return this.vat;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getDiscountType() {
        return this.discountType;
    }

    public int getVatFlag() {
        return this.vatFlag;
    }

    public int getPaymentFlag() {
        return this.paymentFlag;
    }

    public SPECIAL_REGULATION getPopis0DPH() {
        return this.popis0DPH;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public Seller getSeller() {
        return this.seller;
    }

    public Object[] getNonSpecificParams() {
        return this.nonSpecificParams;
    }

    private String rewrite(CharSequence original, Pattern pattern) {
        Matcher matcher = pattern.matcher(original);
        StringBuffer result = new StringBuffer(original.length());
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public ArrayList<MessageItemInterfaceParagon> getPPEKKFormat(boolean emailed, int rowCount) throws EKasaException {
        ArrayList<MessageItemInterfaceParagon> items = new ArrayList<MessageItemInterfaceParagon>();
        switch (this.itemType) {
            case itemSale: {
                if (this.preline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.preline));
                }
                items.add((MessageItemInterfaceParagon)ReceiptItemSale.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.unitPrice), (BigDecimal)new BigDecimal(this.quantity), (String)this.units, (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                if (this.postline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.postline));
                }
                return items;
            }
            case itemReturn: {
                if (this.preline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.preline));
                }
                items.add((MessageItemInterfaceParagon)ReceiptItemReturn.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.unitPrice), (BigDecimal)new BigDecimal(this.quantity), (String)this.units, (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (String)this.referenceId, (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                if (this.postline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.postline));
                }
                return items;
            }
            case itemNegative: {
                if (this.preline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.preline));
                }
                items.add((MessageItemInterfaceParagon)ReceiptItemContainerReturn.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.unitPrice), (BigDecimal)new BigDecimal(this.quantity), (String)this.units, (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                if (this.postline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.postline));
                }
                return items;
            }
            case itemVoid: {
                if (this.preline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.preline));
                }
                items.add((MessageItemInterfaceParagon)ReceiptItemCorrect.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.unitPrice), (BigDecimal)new BigDecimal(this.quantity), (String)this.units, (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (String)this.referenceId, (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                if (this.postline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.postline));
                }
                return items;
            }
            case itemDiscount: 
            case itemDiscount2: {
                if (this.preline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.preline));
                }
                switch (this.discountType) {
                    case 0: 
                    case 2: {
                        items.add((MessageItemInterfaceParagon)ReceiptItemDiscount.getInstance((String)this.description, (BigDecimal)BigDecimal.ONE, (long)this.getValueInCents(this.discountRealValue), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                        break;
                    }
                    case 1: 
                    case 3: {
                        items.add((MessageItemInterfaceParagon)ReceiptItemDiscount.getInstance((String)this.description, (BigDecimal)BigDecimal.ONE, (long)this.getValueInCents("-" + this.discountRealValue), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                    }
                }
                if (this.postline != null) {
                    items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.postline));
                }
                return items;
            }
            case subTotalDiscount: 
            case subTotalDiscount2: {
                switch (this.discountType) {
                    case 0: 
                    case 2: {
                        items.add((MessageItemInterfaceParagon)ReceiptItemDiscount.getInstance((String)this.description, (BigDecimal)BigDecimal.ONE, (long)this.getValueInCents(this.discountRealValue), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                        break;
                    }
                    case 1: 
                    case 3: {
                        items.add((MessageItemInterfaceParagon)ReceiptItemDiscount.getInstance((String)this.description, (BigDecimal)BigDecimal.ONE, (long)this.getValueInCents("-" + this.discountRealValue), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                    }
                }
                return items;
            }
            case subTotal: {
                switch (this.vatFlag) {
                    case 0: {
                        items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%-20s%" + (rowCount - 24) + "s%-4s", this.description, this.totalPrice, "")));
                        break;
                    }
                    case 1: {
                        items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%-20s%" + (rowCount - 24) + "s%-4s", this.description, this.totalPrice, "@")));
                    }
                }
                return items;
            }
            case printAnnouncement: {
                items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.description));
                return items;
            }
            case printAnnouncementNF: {
                items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)this.description));
                return items;
            }
            case withdraw: {
                items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d %-20s%" + (rowCount - 23) + "s", this.paymentFlag, this.description, "-" + this.totalPrice)));
                return items;
            }
            case deposite: {
                items.add((MessageItemInterfaceParagon)ItemPrint.getInstance((String)String.format("%02d %-20s%" + (rowCount - 23) + "s", this.paymentFlag, this.description, this.totalPrice)));
                return items;
            }
            case printBC: {
                items.add((MessageItemInterfaceParagon)ItemBarcode.getInstance((String)this.description, (BARCODE_TYPE)((BARCODE_TYPE)this.nonSpecificParams[0]), (BARCODE_TEXT_POSITION)((BARCODE_TEXT_POSITION)this.nonSpecificParams[1]), (BARCODE_FONT_SIZE)((BARCODE_FONT_SIZE)this.nonSpecificParams[2]), (int)((Integer)this.nonSpecificParams[3]), (int)((Integer)this.nonSpecificParams[4])));
                return items;
            }
            case voucher: {
                items.add((MessageItemInterfaceParagon)ReceiptItemVoucher.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.quantity), (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (String)((String)this.nonSpecificParams[0])));
                return items;
            }
            case odpocitanaZaloha: {
                items.add((MessageItemInterfaceParagon)ReceiptItemDepositReturn.getInstance((String)this.description, (BigDecimal)new BigDecimal(this.unitPrice.replace("-", "")), (BigDecimal)new BigDecimal(this.quantity), (String)this.units, (long)this.getValueInCents(this.totalPrice), (VAT_LEVEL)this.getVATLevel(this.vat), (sk.singularisdev.ekasask.command.Seller)this.seller.getSeller(), (SPECIAL_REGULATION)this.popis0DPH));
                return items;
            }
        }
        return null;
    }

    private long getValueInCents(String value) {
        boolean negative = false;
        if (value.contains("-")) {
            negative = true;
            value = value.replace("-", "");
        }
        String[] parcials = value.split("\\.");
        switch (parcials.length) {
            case 1: {
                return Long.parseLong(negative ? "-" + parcials[0] : parcials[0]) * 100L;
            }
            case 2: {
                if (Long.parseLong(parcials[0]) == 0L) {
                    if (parcials[1].length() == 1) {
                        return Long.parseLong(negative ? "-" + parcials[1] : parcials[1]) * 10L;
                    }
                    return Long.parseLong(negative ? "-" + parcials[1] : parcials[1]);
                }
                if (parcials[1].length() == 1) {
                    return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", "")) * 10L;
                }
                return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", ""));
            }
        }
        return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", ""));
    }

    private VAT_LEVEL getVATLevel(char vat) {
        switch (vat) {
            case 'A': {
                return VAT_LEVEL.A;
            }
            case 'B': {
                return VAT_LEVEL.B;
            }
            case 'C': {
                return VAT_LEVEL.C;
            }
            case 'D': {
                return VAT_LEVEL.D;
            }
            case 'E': {
                return VAT_LEVEL.E;
            }
            case 'F': {
                return VAT_LEVEL.F;
            }
            case 'G': {
                return VAT_LEVEL.G;
            }
            case 'H': {
                return VAT_LEVEL.H;
            }
        }
        return VAT_LEVEL.A;
    }

    public static class Builder {
        String description = "";
        String totalPrice = "0.00";
        String totalPriceZ = "0.00";
        String unitPrice = "0.00";
        String units = "";
        String quantity = "1.000";
        String discountValue = "0.00";
        String discountRealValue = "0.00";
        String referenceId = null;
        String preline = null;
        String postline = null;
        char vat = (char)65;
        int rowNumber = 0;
        int discountType = 0;
        int vatFlag = 0;
        int paymentFlag = 16;
        ItemType itemType = ItemType.itemSale;
        Object[] nonSpecificParams;
        Seller seller = new Seller();
        SPECIAL_REGULATION popis0DPH = SPECIAL_REGULATION.NONE;

        public Builder setSeller(Seller seller) {
            this.seller = seller;
            return this;
        }

        public Builder setPopis0DPH(SPECIAL_REGULATION popis0DPH) {
            this.popis0DPH = popis0DPH;
            return this;
        }

        public Builder setNonSpecificParams(Object[] params) {
            this.nonSpecificParams = params;
            return this;
        }

        public Builder setPaymentFlag(int paymentFlag) {
            this.paymentFlag = paymentFlag;
            return this;
        }

        public Builder setPreline(String preline) {
            this.preline = preline;
            return this;
        }

        public Builder setPostline(String postline) {
            this.postline = postline;
            return this;
        }

        public Builder setVatFlag(int vatFlag) {
            this.vatFlag = vatFlag;
            return this;
        }

        public Builder setDiscountRealValue(String discountRealValue) {
            this.discountRealValue = discountRealValue;
            return this;
        }

        public Builder setReferenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder setTotalPriceZ(String totalPriceZ) {
            this.totalPriceZ = totalPriceZ;
            return this;
        }

        public Builder setDiscountType(int discountType) {
            this.discountType = discountType;
            return this;
        }

        public Builder setDiscountValue(String discountValue) {
            this.discountValue = discountValue;
            return this;
        }

        public Builder setItemType(ItemType itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder setRow(int rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setTotalPrice(String totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public Builder setVat(char vat) {
            this.vat = vat;
            return this;
        }

        public Builder setUnitPrice(String unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public Builder setQuantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder setUnits(String units) {
            this.units = units;
            return this;
        }

        public ItemModel build() {
            return new ItemModel(this);
        }
    }

    public static enum ItemType {
        itemSale,
        itemReturn,
        itemNegative,
        itemVoid,
        itemDiscount,
        itemDiscount2,
        subTotal,
        subTotalDiscount,
        subTotalDiscount2,
        printAnnouncement,
        printAnnouncementNF,
        deposite,
        withdraw,
        printBC,
        voucher,
        odpocitanaZaloha;

    }
}

