/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.math.BigDecimal;
import java.sql.SQLException;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;

public class NegativeTurnover {
    private FmFiscalMemory fm;
    private boolean global;
    private BigDecimal voidValue;
    private BigDecimal returnValue;
    private BigDecimal negativeValue;
    private BigDecimal destroyedValue;
    private BigDecimal roundValue;
    private int voidCount;
    private int returnCount;
    private int negativeCount;
    private int destroyedCount;
    private int roundCount;

    public NegativeTurnover(Builder builder) {
        this.fm = builder.fm;
        this.global = builder.global;
        this.voidValue = builder.voidValue;
        this.returnValue = builder.returnValue;
        this.negativeValue = builder.negativeValue;
        this.destroyedValue = builder.destroyedValue;
        this.roundValue = builder.roundValue;
        this.voidCount = builder.voidCount;
        this.returnCount = builder.returnCount;
        this.negativeCount = builder.negativeCount;
        this.destroyedCount = builder.destroyedCount;
        this.roundCount = builder.roundCount;
    }

    public BigDecimal getVoidValue() {
        return this.voidValue;
    }

    public BigDecimal getReturnValue() {
        return this.returnValue;
    }

    public BigDecimal getNegativeValue() {
        return this.negativeValue;
    }

    public BigDecimal getDestroyedValue() {
        return this.destroyedValue;
    }

    public BigDecimal getRoundValue() {
        return this.roundValue;
    }

    public int getVoidCount() {
        return this.voidCount;
    }

    public int getReturnCount() {
        return this.returnCount;
    }

    public int getNegativeCount() {
        return this.negativeCount;
    }

    public int getDestroyedCount() {
        return this.destroyedCount;
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    private void resetData(NegativeTurnover builder) throws FmStoreToDbException {
        this.voidValue = builder.voidValue;
        this.returnValue = builder.returnValue;
        this.negativeValue = builder.negativeValue;
        this.destroyedValue = builder.destroyedValue;
        this.roundValue = builder.roundValue;
        this.voidCount = builder.voidCount;
        this.returnCount = builder.returnCount;
        this.negativeCount = builder.negativeCount;
        this.destroyedCount = builder.destroyedCount;
        this.roundCount = builder.roundCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidValue.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnValue.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeValue.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedValue.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.round, prefix), this.roundValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.round, prefix), this.roundCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BigDecimal getAllNegativeTotal() {
        return this.returnValue.add(this.negativeValue);
    }

    public int getAllNegativeCount() {
        return this.returnCount + this.negativeCount;
    }

    public void appendVoidValue(BigDecimal appendValue) throws FmStoreToDbException {
        this.voidValue = this.voidValue.add(appendValue);
        ++this.voidCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendReturnValue(BigDecimal appendValue) throws FmStoreToDbException {
        this.returnValue = this.returnValue.add(appendValue);
        ++this.returnCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendNegativeValue(BigDecimal appendValue) throws FmStoreToDbException {
        this.negativeValue = this.negativeValue.add(appendValue);
        ++this.negativeCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendDestroyedValue(BigDecimal appendValue) throws FmStoreToDbException {
        this.destroyedValue = this.destroyedValue.add(appendValue);
        ++this.destroyedCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendRoundValue(BigDecimal appendValue) throws FmStoreToDbException {
        this.roundValue = this.roundValue.add(appendValue);
        ++this.roundCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.round, prefix), this.roundValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.round, prefix), this.roundCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void tilt(NegativeTurnover tiltValue) throws FmStoreToDbException {
        this.voidValue = this.voidValue.add(tiltValue.voidValue);
        this.returnValue = this.returnValue.add(tiltValue.returnValue);
        this.negativeValue = this.negativeValue.add(tiltValue.negativeValue);
        this.destroyedValue = this.destroyedValue.add(tiltValue.destroyedValue);
        this.roundValue = this.roundValue.add(tiltValue.roundValue);
        this.voidCount += tiltValue.voidCount;
        this.returnCount += tiltValue.returnCount;
        this.negativeCount += tiltValue.negativeCount;
        this.destroyedCount += tiltValue.destroyedCount;
        this.roundCount += tiltValue.roundCount;
        try {
            ContentValues values = new ContentValues();
            RowPrefix prefix = this.global ? RowPrefix.global : RowPrefix.local;
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, prefix), this.voidCount);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, prefix), this.returnCount);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, prefix), this.negativeCount);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, prefix), this.destroyedCount);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.round, prefix), this.roundValue.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.round, prefix), this.roundCount);
            this.fm.getDbSource().saveData(Tables.fmGlobals.table(), values);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void reset() throws FmStoreToDbException {
        this.resetData(new Builder(this.fm, this.global).build());
    }

    public static class Builder {
        FmFiscalMemory fm;
        boolean global;
        BigDecimal voidValue = BigDecimal.ZERO;
        BigDecimal returnValue = BigDecimal.ZERO;
        BigDecimal negativeValue = BigDecimal.ZERO;
        BigDecimal destroyedValue = BigDecimal.ZERO;
        BigDecimal roundValue = BigDecimal.ZERO;
        int voidCount;
        int returnCount = 0;
        int negativeCount = 0;
        int destroyedCount = 0;
        int roundCount = 0;

        public Builder(FmFiscalMemory fm, boolean global) {
            this.fm = fm;
            this.global = global;
        }

        public Builder setVoidValue(BigDecimal voidValue) {
            this.voidValue = voidValue;
            return this;
        }

        public Builder setReturnValue(BigDecimal returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public Builder setNegativeValue(BigDecimal negativeValue) {
            this.negativeValue = negativeValue;
            return this;
        }

        public Builder setDestroyedValue(BigDecimal destroyedValue) {
            this.destroyedValue = destroyedValue;
            return this;
        }

        public Builder setRoundValue(BigDecimal roundValue) {
            this.roundValue = roundValue;
            return this;
        }

        public Builder setVoidCount(int voidCount) {
            this.voidCount = voidCount;
            return this;
        }

        public Builder setReturnCount(int returnCount) {
            this.returnCount = returnCount;
            return this;
        }

        public Builder setNegativeCount(int negativeCount) {
            this.negativeCount = negativeCount;
            return this;
        }

        public Builder setDestroyedCount(int destroyedCount) {
            this.destroyedCount = destroyedCount;
            return this;
        }

        public Builder setRoundCount(int roundCount) {
            this.roundCount = roundCount;
            return this;
        }

        public NegativeTurnover build() {
            return new NegativeTurnover(this);
        }
    }
}

