/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.command.ItemPrint;

public class PaymentModel
implements Serializable {
    private static final long serialVersionUID = -4056973743625767538L;
    public int rowNumber;
    public int paymentID;
    public String total;
    public String totalZ;
    public String payedAmount;
    public String exchangeRate;
    public String description;
    public String printRepresentation;
    public String preline;
    public String postline;
    public PaymentType paymentType;

    public PaymentModel(Builder builder) {
        this.paymentType = builder.paymentType;
        this.rowNumber = builder.rowNumber;
        this.paymentID = builder.paymentID;
        this.total = builder.total;
        this.payedAmount = builder.payedAmount;
        this.exchangeRate = builder.exchangeRate;
        this.description = builder.description;
        this.totalZ = builder.totalZ;
        this.printRepresentation = builder.printRepresentation;
        this.preline = builder.preline;
        this.postline = builder.postline;
    }

    private String rewrite(CharSequence original, Pattern pattern) {
        Matcher matcher = pattern.matcher(original);
        StringBuffer result = new StringBuffer(original.length());
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public ArrayList<ItemPrint> getPPEKKFormat(boolean emailed) {
        ArrayList<ItemPrint> prints = new ArrayList<ItemPrint>();
        if (emailed) {
            this.printRepresentation = this.rewrite(this.printRepresentation, Pattern.compile("(~1D~21~[0-9A-F]{2})"));
            this.printRepresentation = this.rewrite(this.printRepresentation, Pattern.compile("(~1B~21~[0-9A-F]{2})"));
        }
        if (this.preline != null) {
            prints.add(ItemPrint.getInstance((String)this.preline));
        }
        boolean firstLine = true;
        String[] stringArray = this.printRepresentation.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            prints.add(ItemPrint.getInstance((String)row));
            if (firstLine) {
                if (this.postline != null) {
                    prints.add(ItemPrint.getInstance((String)this.postline));
                }
                firstLine = false;
            }
            ++n2;
        }
        return prints;
    }

    public static class Builder {
        int rowNumber = 0;
        int paymentID = 16;
        String total = "0.00";
        String totalZ = "0.00";
        String payedAmount = "0.00";
        String exchangeRate = "0.00";
        String description = "";
        String printRepresentation = "";
        String preline = null;
        String postline = null;
        PaymentType paymentType = PaymentType.payment;

        public Builder setPrintRepresentation(String printRepresentation) {
            this.printRepresentation = printRepresentation;
            return this;
        }

        public Builder setPreline(String preline) {
            this.preline = preline;
            return this;
        }

        public Builder setPostline(String postline) {
            this.postline = postline;
            return this;
        }

        public Builder setRow(int rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder setPaymentType(PaymentType paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public Builder setPaymentId(int paymentID) {
            this.paymentID = paymentID;
            return this;
        }

        public Builder setTotal(String total) {
            this.total = total;
            return this;
        }

        public Builder setTotalZ(String totalZ) {
            this.totalZ = totalZ;
            return this;
        }

        public Builder setPayedAmount(String payedAmount) {
            this.payedAmount = payedAmount;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setExchangeRate(String exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public PaymentModel build() {
            return new PaymentModel(this);
        }
    }

    public static enum PaymentType {
        payment,
        payment2;

    }
}

