/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.db.helpers;

import java.io.File;
import java.sql.SQLException;
import sk.singularisdev.ekasask.fm.db.helpers.SQLiteDatabase;

public abstract class SQLiteOpenHelper {
    private static final String DIRECTORY = "DB";
    private SQLiteDatabase db;
    private String dbPath;

    public SQLiteOpenHelper(String databaseName, int version) {
        try {
            if (this.db == null) {
                File f = new File(DIRECTORY, databaseName);
                this.dbPath = f.getAbsolutePath();
                File directory = new File(DIRECTORY);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                this.db = new SQLiteDatabase(this.dbPath, version);
            }
            if (!this.db.isOpen()) {
                this.db.open();
            }
            if (this.db.getVersion() != 0) {
                if (version > this.db.getVersion()) {
                    this.onUpgrade(this.db, this.db.getVersion(), version);
                } else if (version < this.db.getVersion()) {
                    this.onDowngrade(this.db, this.db.getVersion(), version);
                }
            } else {
                this.db.execSQL("PRAGMA main.page_size = 4096");
                this.db.execSQL("PRAGMA main.cache_size=10000");
                this.db.execSQL("PRAGMA main.locking_mode=EXCLUSIVE");
                this.db.execSQL("PRAGMA main.synchronous=NORMAL");
                this.db.execSQL("PRAGMA main.journal_mode=WAL");
                this.db.execSQL("PRAGMA main.cache_size=5000");
                this.db.execSQL("PRAGMA user_version=" + version);
                this.onCreate(this.db);
            }
            this.db.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (this.db != null) {
                this.db.close();
            }
            this.deleteDatabase(databaseName);
        }
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.db != null && !this.db.isOpen()) {
            this.db.open();
            return this.db;
        }
        return this.db;
    }

    public synchronized void close() {
        if (this.db != null && this.db.isOpen()) {
            this.db.close();
            this.db = null;
        }
    }

    private void deleteDatabase(String dbName) {
        File f = new File(DIRECTORY, dbName);
        if (f.exists() && f.isFile()) {
            f.delete();
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public abstract void onDowngrade(SQLiteDatabase var1, int var2, int var3);
}

