/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.test;

import sk.singularisdev.eKasaSK.lib.Charset;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterfaceNoControl;
import sk.singularisdev.ekasask.fm.data.InitConfiguration;
import sk.singularisdev.ekasask.fm.interfaces.GUIThreadListener;

public class ConfigurationRunnable
implements Runnable {
    private LowLevelFMInterfaceNoControl fmInterface;
    private GUIThreadListener listener;
    private InitConfiguration config;

    public ConfigurationRunnable(LowLevelFMInterfaceNoControl fmInterface, InitConfiguration config, GUIThreadListener listener) {
        this.fmInterface = fmInterface;
        this.fmInterface.setCharset(Charset.CP1250);
        this.listener = listener;
        this.config = config;
    }

    @Override
    public void run() {
        try {
            this.fmInterface.openPort();
            if (this.config.deviceId != null && this.config.portType != null && this.config.port != null) {
                this.fmInterface.setPCHDU(this.config.deviceId.intValue(), this.config.portType.intValue(), this.config.port);
            }
            if (this.config.deviceId != null && this.config.autPassword != null && this.config.autPath != null) {
                this.fmInterface.setAutKey(this.config.deviceId.intValue(), this.config.autPassword, this.config.autPath);
            }
            if (this.config.deviceId != null && this.config.ident != null) {
                this.fmInterface.setSubjectIDData(this.config.deviceId.intValue(), this.config.ident);
            }
            if (this.config.deviceId != null && this.config.printerType != null && this.config.printerSpeed != null) {
                this.fmInterface.setPrinterType(this.config.deviceId.intValue(), "Pegas006", "" + this.config.printerType, "" + this.config.printerSpeed);
            }
            if (this.config.vatPayer) {
                if (this.config.deviceId != null) {
                    this.fmInterface.setParameter(this.config.deviceId.intValue(), "Pegas006", "0", "0");
                }
            } else if (this.config.deviceId != null) {
                this.fmInterface.setParameter(this.config.deviceId.intValue(), "Pegas006", "0", "1");
            }
            if (this.config.vatA != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "A", this.config.vatA.toString(), this.config.vatAF.toString());
            } else if (this.config.vatAF != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "A", "0", "0");
            }
            if (this.config.vatB != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "B", this.config.vatB.toString(), this.config.vatBF.toString());
            } else if (this.config.vatBF != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "B", "0", "0");
            }
            if (this.config.vatC != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "C", this.config.vatC.toString(), this.config.vatCF.toString());
            } else if (this.config.vatCF != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "C", "0", "0");
            }
            if (this.config.vatD != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "D", this.config.vatD.toString(), this.config.vatDF.toString());
            } else if (this.config.vatDF != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "D", "0", "0");
            }
            if (this.config.vatE != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "E", this.config.vatE.toString(), this.config.vatEF.toString());
            } else if (this.config.vatEF != null) {
                this.fmInterface.setVAT(this.config.deviceId.intValue(), "Pegas006", "E", "0", "0");
            }
            this.fmInterface.closePort();
            this.listener.processFinished(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.processFinished(false);
        }
    }
}

