/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.test;

import java.util.logging.Level;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterfaceNoControl;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.TcpDriverSwHandshake;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.fm.Daemon;
import sk.singularisdev.ekasask.fm.config.Config;
import sk.singularisdev.ekasask.fm.interfaces.ServerParserListener;
import sk.singularisdev.ekasask.fm.test.ParserServerRunnable;

public class ParserRun
implements ServerParserListener {
    public static void main(String[] args) {
        try {
            Daemon.getInstance();
            Config config = new Config();
            if (args != null) {
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (arg.contains("-port:")) {
                        try {
                            config.setSuperserver(Integer.parseInt(arg.split(":")[1]));
                        }
                        catch (Exception e) {
                            config.setSuperserver(30000);
                        }
                    } else if (arg.contains("-log:")) {
                        switch (arg.split(":")[1].charAt(0)) {
                            case 'A': {
                                config.setLogging(Level.ALL);
                                break;
                            }
                            case 'I': {
                                config.setLogging(Level.INFO);
                            }
                        }
                    } else if (arg.contains("-folder:")) {
                        try {
                            config.setPath(arg.split(":")[1]);
                        }
                        catch (Exception e) {
                            config.setPath("");
                        }
                    } else if (arg.contains("-cert")) {
                        Configuration.setSfsUrl((String)"iekasa.financnasprava.sk/mdu/soap/services/v2");
                    } else if (arg.contains("-hwchdu:")) {
                        // empty if block
                    }
                    ++n2;
                }
            } else {
                config.setSuperserver(30000);
            }
            Daemon.getInstance().install(config);
            Thread thread = new Thread(new ParserServerRunnable(new LowLevelFMInterfaceNoControl((CommunicationDriver)new TcpDriverSwHandshake("127.0.0.1", config.getSuperserverPort())), new ParserRun()));
            thread.start();
        }
        catch (Exception e) {
            Daemon.logger.error("", (Throwable)e);
            Daemon.getInstance().uninstall();
            System.exit(0);
        }
    }

    @Override
    public void fileReadWriteError(Exception e) {
        System.out.println(e.getMessage());
    }

    @Override
    public void fileProcessed(int resultCode, StringBuilder resultInfo) {
    }

    @Override
    public void stopParser() {
        Daemon.getInstance().uninstall();
        System.out.println();
        System.out.print("Parser ukonceny!");
        System.exit(0);
    }
}

