/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa;

import com.sun.org.apache.xml.internal.security.Init;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;

public class Configuration {
    private String path;
    private String alias;
    private String password;
    private String swid;
    private String url;
    private String port;
    private KeyStore ks;
    private Signature signature;
    private MessageDigest md;
    private X509Certificate certificate;
    private boolean debug = false;
    private int timeout = 2000;

    public Configuration(KeyStore ks, String alias, String password, String swid, String url, String port) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, InvalidKeyException {
        this.ks = ks;
        this.certificate = (X509Certificate)ks.getCertificate(alias);
        this.signature = Signature.getInstance("SHA256withRSA");
        this.signature.initSign((PrivateKey)ks.getKey(alias, password.toCharArray()));
        this.swid = swid;
        this.url = url;
        this.port = port;
        this.alias = alias;
        this.password = password;
        Init.init();
        this.md = MessageDigest.getInstance("SHA-256");
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public KeyStore getKs() {
        return this.ks;
    }

    void setKs(KeyStore ks) {
        this.ks = ks;
    }

    public Signature getSignature() {
        return this.signature;
    }

    void setSignature(Signature signature) {
        this.signature = signature;
    }

    public MessageDigest getMd() {
        return this.md;
    }

    void setMd(MessageDigest md) {
        this.md = md;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String keystore_path) {
        this.path = keystore_path;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSwid() {
        return this.swid;
    }

    public void setSwid(String swid) {
        this.swid = swid;
    }
}

