/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa;

import com.notasoftwarecompany.ekasa.location.Location;
import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.platform.Platform;

public class DataSender {
    private static final Logger logger = LoggerManager.getLogger(DataSender.class.getName());
    private String URL;
    private String PORT;
    private String PATH;
    private int timeout;
    private Receipt.ReceiptResponse receiptResponse;
    private Location.LocationResponse locationResponse;

    public DataSender(String url, String port, int timeout, Receipt.ReceiptResponse receiptResponse, Location.LocationResponse locationResponse) {
        String[] split = url.replace("http://", "").replace("https://", "").split("/");
        this.URL = split[0];
        this.PATH = "";
        int i = 1;
        while (i < split.length) {
            this.PATH = String.valueOf(this.PATH) + "/" + split[i];
            ++i;
        }
        this.PORT = port;
        this.timeout = timeout;
        this.receiptResponse = receiptResponse;
        this.locationResponse = locationResponse;
    }

    private String socketSend(String xmldata) throws IOException {
        String line;
        SSLSocket sock;
        if (Configuration.getProxyHost() != null) {
            return this.socketSendProxy(xmldata, Configuration.getProxyHost(), Configuration.getProxyPort());
        }
        try {
            sock = Platform.createSLLSocket(this.URL, Integer.parseInt(this.PORT), this.timeout);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), "UTF-8"));
        wr.write("POST " + this.PATH + " HTTP/1.0\r\n");
        wr.write("Host: " + this.URL + "\r\n");
        byte[] b = xmldata.getBytes("UTF-8");
        wr.write("Content-Length: " + b.length + "\r\n");
        wr.write("Content-Type: application/soap+xml; charset=\"utf-8\"\r\n");
        wr.write("\r\n");
        wr.write(xmldata);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(sock.getInputStream(), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    private String socketSendProxy(String xmldata, String tunnelHost, int tunnelPort) throws IOException {
        String line;
        SSLSocket sock;
        logger.debug("Sending with tunneling [" + tunnelHost + ":" + tunnelPort + "]");
        Socket tunnel = new Socket(tunnelHost, tunnelPort);
        this.doTunnelHandshake(tunnel, this.URL, Integer.parseInt(this.PORT));
        try {
            sock = Platform.createSLLSocket(tunnel, this.URL, Integer.parseInt(this.PORT), true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        sock.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent event) {
                logger.debug("Handshake finished!\n\t CipherSuite:" + event.getCipherSuite() + "\n" + "\t SessionId " + event.getSession() + "\n" + "\t PeerHost " + event.getSession().getPeerHost());
            }
        });
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), "UTF-8"));
        wr.write("POST " + this.PATH + " HTTP/1.0\r\n");
        wr.write("Host: " + this.URL + "\r\n");
        byte[] b = xmldata.getBytes("UTF-8");
        wr.write("Content-Length: " + b.length + "\r\n");
        wr.write("Content-Type: application/soap+xml; charset=\"utf-8\"\r\n");
        wr.write("\r\n");
        wr.write(xmldata);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(sock.getInputStream(), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public Receipt.ReceiptResponse sendReceiptData(String xmldata) throws IOException {
        String retval = this.socketSend(xmldata);
        if (retval != null && retval.length() > 0 && retval.contains("<?xml version=\"1.0\" encoding=\"utf-8\" ?>")) {
            this.receiptResponse.setResponse("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + retval.split("<\\?xml version=\"1.0\" encoding=\"utf-8\" \\?>")[1]);
        }
        if (retval != null && retval.length() > 0 && retval.contains(":ReceiptData Id=")) {
            this.receiptResponse.setUID(retval.split(":ReceiptData Id=\"")[1].split("\"")[0]);
        }
        if (retval.length() > 0 && retval.contains("EkasaErrorCode=\"")) {
            this.receiptResponse.setErrorCode(retval.split("EkasaErrorCode=\"")[1].split("\"")[0]);
        }
        if (retval.length() > 0 && retval.contains("<env:Reason><env:Text xml:lang=\"sk-SK\">")) {
            this.receiptResponse.setErrorResponse(retval.split("<env:Reason><env:Text xml:lang=\"sk-SK\">")[1].split("</env:Text>")[0]);
        }
        if (retval != null && retval.length() > 0) {
            if (retval.contains("HTTP/1.1 200 OK")) {
                this.receiptResponse.setStatus("success");
            } else {
                this.httpErrorEvent(retval);
                this.receiptResponse.setStatus("fail");
            }
        } else {
            this.receiptResponse.setStatus("fail");
        }
        return this.receiptResponse;
    }

    public Location.LocationResponse sendLocationData(String xmldata) throws IOException {
        String retval = this.socketSend(xmldata);
        if (retval.length() > 0 && retval.contains("EkasaErrorCode=\"")) {
            this.locationResponse.setErrorCode(retval.split("EkasaErrorCode=\"")[1].split("\"")[0]);
        }
        if (retval.length() > 0 && retval.contains("<env:Reason><env:Text xml:lang=\"sk-SK\">")) {
            this.locationResponse.setErrorResponse(retval.split("<env:Reason><env:Text xml:lang=\"sk-SK\">")[1].split("</env:Text>")[0]);
        }
        if (retval != null && retval.length() > 0) {
            if (retval.contains("HTTP/1.1 200 OK")) {
                this.locationResponse.setStatus("success");
            } else {
                this.httpErrorEvent(retval);
                this.locationResponse.setStatus("fail");
            }
        } else {
            this.locationResponse.setStatus("fail");
        }
        if (retval != null && retval.length() > 0 && retval.contains("<?xml version=\"1.0\" encoding=\"utf-8\" ?>")) {
            this.locationResponse.setResponse("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + retval.split("<\\?xml version=\"1.0\" encoding=\"utf-8\" \\?>")[1]);
        }
        return this.locationResponse;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String javaVersion = "Java/" + System.getProperty("java.version");
        String userAgent = System.getProperty("http.agent") == null ? javaVersion : String.valueOf(System.getProperty("http.agent")) + " " + javaVersion;
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: " + userAgent + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
            throw new IOException("Unable to tunnel through " + tunnel.getInetAddress().getHostAddress() + ":" + tunnel.getPort() + ".  Proxy returns \"" + replyStr + "\"");
        }
    }

    private void httpErrorEvent(String response) {
        try {
            if (Configuration.getErrorListener() != null) {
                Configuration.getErrorListener().httpErrorListener(response);
            }
        }
        catch (Exception e) {
            logger.fatal("Error call ErrorListener.httpErrorListener", e);
        }
    }
}

