/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa;

import com.notasoftwarecompany.ekasa.xBase64;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Formatter;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Encryption {
    private KeyStore ks;
    private Signature signature;
    private MessageDigest md;
    private String plaintext;
    private X509Certificate certificate;
    private String alias;
    private String password;
    private String path;
    private byte[] pkp;
    private String okp;
    private String SWID;
    private String UUID;

    public Encryption(KeyStore ks, Signature signature, MessageDigest md, X509Certificate certificate, String alias, String password, String path) {
        this.ks = ks;
        this.signature = signature;
        this.md = md;
        this.certificate = certificate;
        this.alias = alias;
        this.password = password;
        this.path = path;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public KeyStore getKs() {
        return this.ks;
    }

    public void setKs(KeyStore ks) {
        this.ks = ks;
    }

    public void GenerateSecrets(String plaintext, String swid) throws SignatureException, ParseException, NoSuchAlgorithmException, UnsupportedEncodingException {
        this.plaintext = plaintext;
        this.setPkp(this.CalculatePKP());
        this.setOkp(this.CalculateOKP(this.getPkp()));
        this.setSWID(swid);
        this.setUUID(this.GenerateUUID());
    }

    public void GenerateSecretsLocation(String swid) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.setSWID(swid);
        this.setUUID(this.GenerateUUID());
    }

    private String GenerateUUID() {
        return java.util.UUID.randomUUID().toString();
    }

    private byte[] CalculatePKP() throws SignatureException, UnsupportedEncodingException {
        this.signature.update(this.plaintext.getBytes("UTF-8"));
        return this.signature.sign();
    }

    private String CalculateSWID(String company, String product, String version) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder message = new StringBuilder();
        message.append(company).append(product).append(version);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return this.byteArray2Hex(md.digest(message.toString().getBytes("UTF-8")));
    }

    private String CalculateOKP(byte[] pkp) throws NoSuchAlgorithmException, ParseException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        String hash_sha1 = this.byteArray2Hex(md.digest(pkp));
        String str = String.valueOf(hash_sha1.substring(0, 8)) + "-" + hash_sha1.substring(8, 16) + "-" + hash_sha1.substring(16, 24) + "-" + hash_sha1.substring(24, 32) + "-" + hash_sha1.substring(32);
        return str.toUpperCase();
    }

    private String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    public String SignBody(String body) throws InvalidCanonicalizerException, IOException, ParserConfigurationException, SAXException, CanonicalizationException, SignatureException {
        Canonicalizer canon = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] canonXmlBytes = canon.canonicalize(body.getBytes("UTF-8"));
        this.signature.update(canonXmlBytes);
        byte[] xml_signature = this.signature.sign();
        return this.getBase64Encoded(xml_signature);
    }

    public String generateDigest(String body) throws InvalidCanonicalizerException, IOException, ParserConfigurationException, SAXException, CanonicalizationException {
        Canonicalizer canon = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] canonXmlBytes = canon.canonicalize(body.getBytes("UTF-8"));
        String canonXmlString = new String(canonXmlBytes, "UTF-8");
        return this.getBase64Encoded(this.md.digest(canonXmlString.getBytes("UTF-8")));
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] getPkp() {
        return this.pkp;
    }

    private void setPkp(byte[] pkp) {
        this.pkp = pkp;
    }

    public String getOkp() {
        return this.okp;
    }

    private void setOkp(String okp) {
        this.okp = okp;
    }

    public String getSWID() {
        return this.SWID;
    }

    private void setSWID(String SWID) {
        this.SWID = SWID;
    }

    public String getUUID() {
        return this.UUID;
    }

    private void setUUID(String UUID2) {
        this.UUID = UUID2;
    }

    private String getBase64Encoded(byte[] text) {
        return xBase64.toString(text);
    }
}

