/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa;

import com.notasoftwarecompany.ekasa.Configuration;
import com.notasoftwarecompany.ekasa.Encryption;
import com.notasoftwarecompany.ekasa.receipt.Receipt;
import com.notasoftwarecompany.ekasa.xBase64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.utils.EKasaXML;

public class XMLHelper {
    private static final Logger logger = LoggerManager.getLogger(XMLHelper.class.getName());

    public static String getFinalXML(String body, Encryption encryption, Configuration configuration) throws IOException, WSSecurityException, CertificateException, NoSuchAlgorithmException, KeyStoreException, CredentialException {
        String xml = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:v2=\"http://financnasprava.sk/ekasa/schema/v2\">\n<soap:Header/>\n" + body + "</soap:Envelope>";
        Security.addProvider((Provider)new XMLDSigRI());
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        try {
            Document doc;
            Document soapPart = doc = XMLHelper.stringToDocument(xml);
            WSSecSignature builder = new WSSecSignature();
            WSSecTimestamp timestamp = new WSSecTimestamp();
            WSSecHeader wsSecHeader = new WSSecHeader();
            wsSecHeader.setMustUnderstand(true);
            wsSecHeader.insertSecurityHeader(doc);
            WSSecTimestamp wsSecTimeStamp = new WSSecTimestamp();
            wsSecTimeStamp.prepare(soapPart);
            Properties cxfProps = new Properties();
            cxfProps.setProperty("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
            cxfProps.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", "pkcs12");
            cxfProps.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", encryption.getAlias());
            cxfProps.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", encryption.getPassword());
            Crypto crypto1 = XMLHelper.getCrypto(encryption.getKs(), cxfProps);
            builder.appendBSTElementToHeader(wsSecHeader);
            builder.setUserInfo(encryption.getAlias(), encryption.getPassword());
            builder.setX509Certificate(encryption.getCertificate());
            builder.setKeyIdentifierType(1);
            builder.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            builder.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#");
            builder.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
            builder.setUseSingleCertificate(true);
            ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
            WSEncryptionPart bodyPart = new WSEncryptionPart("Body", "http://www.w3.org/2003/05/soap-envelope", "");
            parts.add(bodyPart);
            builder.setParts(parts);
            Document dxml = builder.build(soapPart, crypto1, wsSecHeader);
            String finalXml = XMLHelper.documentToString(dxml);
            logger.debug("Final XML for SFS:");
            logger.debug(finalXml);
            return finalXml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Crypto getCrypto(KeyStore keystore, Properties cxfProps) throws CredentialException, IOException {
        Merlin merlin = new Merlin();
        merlin.setKeyStore(keystore);
        merlin.loadProperties(cxfProps);
        return merlin;
    }

    public static String parseXmlValue(String xml, String value) {
        if (xml.contains(String.valueOf(value) + "=")) {
            return EKasaXML.unescapeXML(xml.split(String.valueOf(value) + "=\"")[1].split("\"")[0]);
        }
        if (xml.contains(String.valueOf(value) + ">")) {
            return EKasaXML.unescapeXML(xml.split(String.valueOf(value) + ">")[1].split("<")[0]);
        }
        return null;
    }

    public static List<Receipt.Item> parseItems(String xml, Receipt receipt) {
        ArrayList<Receipt.Item> itemList = new ArrayList<Receipt.Item>();
        String[] items = xml.split("<v2:Item ");
        int i = 1;
        while (i < items.length) {
            Receipt.Item item = new Receipt.Item(receipt);
            item.setName(XMLHelper.parseXmlValue(items[i].split(">")[0], "Name"));
            item.setItemType(XMLHelper.parseXmlValue(items[i].split(">")[0], "ItemType"));
            item.setVatRate(XMLHelper.parseXmlValue(items[i].split(">")[0], "VatRate"));
            item.setQuantity(XMLHelper.parseXmlValue(items[i].split(">")[0], "Quantity"));
            item.setReferenceReceiptId(XMLHelper.parseXmlValue(items[i].split(">")[0], "ReferenceReceiptId"));
            item.setSpecialRegulation(XMLHelper.parseXmlValue(items[i].split(">")[0], "SpecialRegulation"));
            item.setSellerId(XMLHelper.parseXmlValue(items[i].split(">")[0], "SellerId"));
            item.setSellerIdType(XMLHelper.parseXmlValue(items[i].split(">")[0], "SellerIdType"));
            item.setVoucherNumber(XMLHelper.parseXmlValue(items[i].split(">")[0], "VoucherNumber"));
            item.setPrice(XMLHelper.parseXmlValue(items[i].split(">")[0], "Price"));
            itemList.add(item);
            ++i;
        }
        if (itemList.size() > 0) {
            return itemList;
        }
        return null;
    }

    public static String getBase64Encoded(byte[] text) {
        return xBase64.toString(text);
    }

    private static String documentToString(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private static Document stringToDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }
}

