/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa.location;

import com.notasoftwarecompany.ekasa.Configuration;
import com.notasoftwarecompany.ekasa.DataSender;
import com.notasoftwarecompany.ekasa.Encryption;
import com.notasoftwarecompany.ekasa.PreparedRequest;
import com.notasoftwarecompany.ekasa.RequestObject;
import com.notasoftwarecompany.ekasa.ResponseObject;
import com.notasoftwarecompany.ekasa.XMLHelper;
import com.notasoftwarecompany.ekasa.location.XMLGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;

public class Location
implements RequestObject {
    private String Dic;
    private String CashRegisterCode;
    private String Municipality;
    private String StreetName;
    private String BuildingNumber;
    private String PropertyRegistrationNumber;
    private String PostalCode;
    private String AxisX;
    private String AxisY;
    private String Other;
    private String CreateDate;
    private String counter;
    private Configuration configuration;
    private Encryption encryption;
    private XMLGenerator xmlGenerator;
    private DataSender dataSender;
    private LocationResponse locationResponse;

    @Override
    public ResponseObject sendData(Configuration configuration) throws IOException, NoSuchAlgorithmException, WSSecurityException, CertificateException, KeyStoreException, CredentialException {
        String final_xml = this.prepareRequest(configuration).getRequest();
        this.dataSender = new DataSender(configuration.getUrl(), configuration.getPort(), configuration.getTimeout(), null, this.locationResponse);
        LocationResponse locationResponse = this.dataSender.sendLocationData(final_xml);
        locationResponse.setRequest(final_xml);
        return locationResponse;
    }

    public static Location getInstance(String xml) {
        Location location = new Location();
        location.setDic(XMLHelper.parseXmlValue(xml, "Dic"));
        location.setCashRegisterCode(XMLHelper.parseXmlValue(xml, "CashRegisterCode"));
        location.setMunicipality(XMLHelper.parseXmlValue(xml, "Municipality"));
        location.setStreetName(XMLHelper.parseXmlValue(xml, "StreetName"));
        location.setBuildingNumber(XMLHelper.parseXmlValue(xml, "BuildingNumber"));
        location.setPropertyRegistrationNumber(XMLHelper.parseXmlValue(xml, "PropertyRegistrationNumber"));
        location.setPostalCode(XMLHelper.parseXmlValue(xml, "PostalCode"));
        location.setAxisX(XMLHelper.parseXmlValue(xml, "AxisX"));
        location.setAxisY(XMLHelper.parseXmlValue(xml, "AxisY"));
        location.setOther(XMLHelper.parseXmlValue(xml, "Other"));
        location.setCreateDate(XMLHelper.parseXmlValue(xml, "CreateDate"));
        location.setCounter(XMLHelper.parseXmlValue(xml, "SendingCount"));
        return location;
    }

    @Override
    public PreparedRequest prepareRequest(Configuration configuration) throws NoSuchAlgorithmException, IOException, WSSecurityException, CertificateException, KeyStoreException, CredentialException {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.locationResponse = new LocationResponse();
        this.configuration = configuration;
        this.encryption = new Encryption(configuration.getKs(), configuration.getSignature(), configuration.getMd(), configuration.getCertificate(), configuration.getAlias(), configuration.getPassword(), configuration.getPath());
        this.encryption.GenerateSecretsLocation(configuration.getSwid());
        this.xmlGenerator = new XMLGenerator(this.encryption, this);
        PreparedRequest prepared = new PreparedRequest(this.xmlGenerator.GenerateFinalXML(), null, null);
        return prepared;
    }

    public RequestObject getRequestFromXml(String path) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader r = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            int c = 0;
            while ((c = ((Reader)r).read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Location location = Location.getInstance(sb.toString());
        return location;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }

    public String getDic() {
        return this.Dic;
    }

    public void setDic(String dic) {
        this.Dic = dic;
    }

    public String getCashRegisterCode() {
        return this.CashRegisterCode;
    }

    public void setCashRegisterCode(String cashRegisterCode) {
        this.CashRegisterCode = cashRegisterCode;
    }

    public String getMunicipality() {
        return this.Municipality;
    }

    public void setMunicipality(String municipality) {
        this.Municipality = municipality;
    }

    public String getStreetName() {
        return this.StreetName;
    }

    public void setStreetName(String streetName) {
        this.StreetName = streetName;
    }

    public String getBuildingNumber() {
        return this.BuildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.BuildingNumber = buildingNumber;
    }

    public String getPropertyRegistrationNumber() {
        return this.PropertyRegistrationNumber;
    }

    public void setPropertyRegistrationNumber(String propertyRegistrationNumber) {
        this.PropertyRegistrationNumber = propertyRegistrationNumber;
    }

    public String getPostalCode() {
        return this.PostalCode;
    }

    public void setPostalCode(String postalCode) {
        this.PostalCode = postalCode;
    }

    public String getAxisX() {
        return this.AxisX;
    }

    public void setAxisX(String axisX) {
        this.AxisX = axisX;
    }

    public String getAxisY() {
        return this.AxisY;
    }

    public void setAxisY(String axisY) {
        this.AxisY = axisY;
    }

    public String getOther() {
        return this.Other;
    }

    public void setOther(String other) {
        this.Other = other;
    }

    public String getCreateDate() {
        return this.CreateDate;
    }

    public void setCreateDate(String createDate) {
        this.CreateDate = createDate;
    }

    public class LocationResponse
    implements ResponseObject {
        private String response;
        private String status;
        private String request;
        private String errorCode;
        private String errorResponse;

        public void setRequest(String request) {
            this.request = request;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorResponse(String errorResponse) {
            this.errorResponse = errorResponse;
        }

        @Override
        public String getRequest() {
            return this.request;
        }

        @Override
        public String getResponse() {
            return this.response;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public String getPkp() {
            return null;
        }

        @Override
        public String getOkp() {
            return null;
        }

        @Override
        public String getUID() {
            return null;
        }

        @Override
        public String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String getErrorReason() {
            return this.errorResponse;
        }

        public void setResponse(String response) {
            this.response = response;
        }
    }
}

