/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa.location;

import com.notasoftwarecompany.ekasa.Encryption;
import com.notasoftwarecompany.ekasa.TDTool;
import com.notasoftwarecompany.ekasa.XMLHelper;
import com.notasoftwarecompany.ekasa.location.Location;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import sk.singularisdev.ekasask.utils.EKasaXML;

class XMLGenerator {
    private String SWID;
    private String UUID;
    private Encryption encryption;
    private Location location;
    private TDTool tdTool;

    XMLGenerator(Encryption encryption, Location location) {
        this.SWID = encryption.getSWID();
        this.UUID = encryption.getUUID();
        this.encryption = encryption;
        this.location = location;
        this.tdTool = new TDTool();
    }

    private String GenerateHeader() {
        return "<v2:Header RequestDate=\"" + EKasaXML.escapeXML(this.tdTool.getCurrentTimeStamp()) + "\" SendingCount=\"" + EKasaXML.escapeXML(this.location.getCounter()) + "\" SwId=\"" + EKasaXML.escapeXML(this.SWID) + "\" Uuid=\"" + EKasaXML.escapeXML(this.UUID) + "\"/>";
    }

    private String GeneratelocationData() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("<v2:LocationData CashRegisterCode=\"");
        retVal.append(EKasaXML.escapeXML(this.location.getCashRegisterCode()));
        retVal.append("\" CreateDate=\"");
        retVal.append(EKasaXML.escapeXML(this.location.getCreateDate()));
        retVal.append("\" Dic=\"");
        retVal.append(EKasaXML.escapeXML(this.location.getDic()));
        retVal.append("\">");
        retVal.append("<v2:Location>");
        if (this.location.getOther() != null) {
            retVal.append("<v2:Other>");
            retVal.append(EKasaXML.escapeXML(this.location.getOther()));
            retVal.append("</v2:Other>");
        } else if (this.location.getAxisX() != null && this.location.getAxisY() != null) {
            retVal.append("<v2:Gps AxisX=\"").append(EKasaXML.escapeXML(this.location.getAxisX())).append("\" AxisY=\"").append(EKasaXML.escapeXML(this.location.getAxisY())).append("\"/>");
        } else if (this.location.getMunicipality() != null && this.location.getStreetName() != null) {
            retVal.append("<v2:PhysicalAddress ");
            if (this.location.getBuildingNumber() != null) {
                retVal.append("BuildingNumber=\"").append(EKasaXML.escapeXML(this.location.getBuildingNumber())).append("\" ");
            }
            retVal.append("Municipality=\"").append(EKasaXML.escapeXML(this.location.getMunicipality())).append("\" ");
            if (this.location.getPostalCode() != null) {
                retVal.append("PostalCode=\"").append(EKasaXML.escapeXML(this.location.getPostalCode())).append("\" ");
            }
            if (this.location.getPropertyRegistrationNumber() != null) {
                retVal.append("PropertyRegistrationNumber=\"").append(EKasaXML.escapeXML(this.location.getPropertyRegistrationNumber())).append("\" ");
            }
            retVal.append("StreetName=\"").append(EKasaXML.escapeXML(this.location.getStreetName())).append("\"");
            retVal.append("/>");
        }
        retVal.append("</v2:Location>");
        retVal.append("</v2:LocationData>");
        return retVal.toString();
    }

    String GenerateFinalXML() throws IOException, WSSecurityException, CertificateException, NoSuchAlgorithmException, KeyStoreException, CredentialException {
        String body = "<soap:Body><v2:RegisterLocationRequest xmlns:v2=\"http://financnasprava.sk/ekasa/schema/v2\">" + this.GenerateHeader() + this.GeneratelocationData() + "</v2:RegisterLocationRequest></soap:Body>";
        return XMLHelper.getFinalXML(body, this.encryption, this.location.getConfiguration());
    }
}

