/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa.receipt;

import com.notasoftwarecompany.ekasa.Configuration;
import com.notasoftwarecompany.ekasa.DataSender;
import com.notasoftwarecompany.ekasa.Encryption;
import com.notasoftwarecompany.ekasa.PreparedRequest;
import com.notasoftwarecompany.ekasa.RequestObject;
import com.notasoftwarecompany.ekasa.ResponseObject;
import com.notasoftwarecompany.ekasa.XMLHelper;
import com.notasoftwarecompany.ekasa.receipt.XMLGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;

public class Receipt
implements RequestObject {
    private String Amount;
    private String IssueDate;
    private String CreateDate;
    private String ReceiptNumber;
    private String InvoiceNumber;
    private String ParagonNumber;
    private String Dic;
    private String IcDph;
    private String Ico;
    private String CustomerId;
    private String CustomerIdType;
    private String CashRegisterCode;
    private String Paragon;
    private String BasicVatAmount;
    private String ReducedVatAmount;
    private String TaxFreeAmount;
    private String ReceiptType;
    private String TaxBaseBasic;
    private String TaxBaseReduced;
    private String counter;
    private String Exception;
    private List<Item> Item;
    private Encryption encryption;
    private XMLGenerator xmlGenerator;
    private DataSender dataSender;
    private String document;
    private Configuration configuration;
    private ReceiptResponse receiptResponse;

    @Override
    public ResponseObject sendData(Configuration configuration) throws IOException, SignatureException, ParseException, NoSuchAlgorithmException, WSSecurityException, CertificateException, KeyStoreException, CredentialException {
        String final_xml = this.prepareRequest(configuration).getRequest();
        this.dataSender = new DataSender(configuration.getUrl(), configuration.getPort(), configuration.getTimeout(), this.receiptResponse, null);
        ReceiptResponse receiptResponse = this.dataSender.sendReceiptData(final_xml);
        receiptResponse.setOkp(this.encryption.getOkp());
        receiptResponse.setPkp(XMLHelper.getBase64Encoded(this.encryption.getPkp()));
        receiptResponse.setRequest(final_xml);
        return receiptResponse;
    }

    public static Receipt getInstance(String xml) {
        Receipt receipt = new Receipt();
        receipt.setAmount(XMLHelper.parseXmlValue(xml, "Amount"));
        receipt.setIssueDate(XMLHelper.parseXmlValue(xml, "IssueDate"));
        receipt.setCreateDate(XMLHelper.parseXmlValue(xml, "CreateDate"));
        receipt.setReceiptNumber(XMLHelper.parseXmlValue(xml, "ReceiptNumber"));
        receipt.setInvoiceNumber(XMLHelper.parseXmlValue(xml, "InvoiceNumber"));
        receipt.setParagonNumber(XMLHelper.parseXmlValue(xml, "ParagonNumber"));
        receipt.setDic(XMLHelper.parseXmlValue(xml, "Dic"));
        receipt.setIcDph(XMLHelper.parseXmlValue(xml, "IcDph"));
        receipt.setIco(XMLHelper.parseXmlValue(xml, "Ico"));
        receipt.setCustomerId(XMLHelper.parseXmlValue(xml, "CustomerId"));
        receipt.setCustomerIdType(XMLHelper.parseXmlValue(xml, "CustomerIdType"));
        receipt.setCashRegisterCode(XMLHelper.parseXmlValue(xml, "CashRegisterCode"));
        receipt.setParagon(XMLHelper.parseXmlValue(xml, "Paragon"));
        receipt.setBasicVatAmount(XMLHelper.parseXmlValue(xml, "BasicVatAmount"));
        receipt.setReducedVatAmount(XMLHelper.parseXmlValue(xml, "ReducedVatAmount"));
        receipt.setReceiptType(XMLHelper.parseXmlValue(xml, "ReceiptType"));
        receipt.setTaxBaseBasic(XMLHelper.parseXmlValue(xml, "TaxBaseBasic"));
        receipt.setTaxBaseReduced(XMLHelper.parseXmlValue(xml, "TaxBaseReduced"));
        receipt.setTaxFreeAmount(XMLHelper.parseXmlValue(xml, "TaxFreeAmount"));
        receipt.setCounter(XMLHelper.parseXmlValue(xml, "SendingCount"));
        receipt.setException(XMLHelper.parseXmlValue(xml, "Exception"));
        receipt.setItem(XMLHelper.parseItems(xml, receipt));
        return receipt;
    }

    @Override
    public PreparedRequest prepareRequest(Configuration configuration) throws NoSuchAlgorithmException, SignatureException, ParseException, IOException, WSSecurityException, CertificateException, KeyStoreException, CredentialException {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.receiptResponse = new ReceiptResponse();
        this.configuration = configuration;
        this.encryption = new Encryption(configuration.getKs(), configuration.getSignature(), configuration.getMd(), configuration.getCertificate(), configuration.getAlias(), configuration.getPassword(), configuration.getPath());
        String plaintext = String.valueOf(this.getDic()) + "|" + this.getCashRegisterCode() + "|" + this.getReceiptType() + "|" + this.getReceiptNumber() + "|" + this.getCreateDate() + "|" + this.getAmount();
        this.encryption.GenerateSecrets(plaintext, configuration.getSwid());
        this.xmlGenerator = new XMLGenerator(this.encryption, this);
        PreparedRequest prepared = new PreparedRequest(this.xmlGenerator.GenerateFinalXML(), XMLHelper.getBase64Encoded(this.encryption.getPkp()), this.encryption.getOkp());
        return prepared;
    }

    public RequestObject getRequestFromXml(String path) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader r = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            int c = 0;
            while ((c = ((Reader)r).read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Receipt receipt = Receipt.getInstance(sb.toString());
        return receipt;
    }

    public String getParagonNumber() {
        return this.ParagonNumber;
    }

    public void setParagonNumber(String paragonNumber) {
        this.ParagonNumber = paragonNumber;
    }

    public String getException() {
        return this.Exception;
    }

    public void setException(String exception) {
        this.Exception = exception;
    }

    public ReceiptResponse getReceiptResponse() {
        return this.receiptResponse;
    }

    public void setReceiptResponse(ReceiptResponse receiptResponse) {
        this.receiptResponse = receiptResponse;
    }

    String getDocument() {
        return this.document;
    }

    void setDocument(String document) {
        this.document = document;
    }

    void GenerateDocument() throws IOException, WSSecurityException, CertificateException, NoSuchAlgorithmException, KeyStoreException, CredentialException {
        this.setDocument(this.xmlGenerator.GenerateFinalXML());
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String counter) {
        this.counter = counter;
    }

    public String getInvoiceNumber() {
        return this.InvoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.InvoiceNumber = invoiceNumber;
    }

    public String getAmount() {
        return this.Amount;
    }

    public void setAmount(String amount) {
        this.Amount = amount;
    }

    public String getIssueDate() {
        return this.IssueDate;
    }

    public void setIssueDate(String issueDate) {
        this.IssueDate = issueDate;
    }

    public String getCreateDate() {
        return this.CreateDate;
    }

    public void setCreateDate(String createDate) {
        this.CreateDate = createDate;
    }

    public String getReceiptNumber() {
        return this.ReceiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.ReceiptNumber = receiptNumber;
    }

    public String getDic() {
        return this.Dic;
    }

    public void setDic(String dic) {
        this.Dic = dic;
    }

    public String getIcDph() {
        return this.IcDph;
    }

    public void setIcDph(String icDph) {
        this.IcDph = icDph;
    }

    public String getIco() {
        return this.Ico;
    }

    public void setIco(String ico) {
        this.Ico = ico;
    }

    public String getCustomerId() {
        return this.CustomerId;
    }

    public void setCustomerId(String customerId) {
        this.CustomerId = customerId;
    }

    public String getCustomerIdType() {
        return this.CustomerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.CustomerIdType = customerIdType;
    }

    public String getCashRegisterCode() {
        return this.CashRegisterCode;
    }

    public void setCashRegisterCode(String cashRegisterCode) {
        this.CashRegisterCode = cashRegisterCode;
    }

    public String getParagon() {
        return this.Paragon;
    }

    public void setParagon(String paragon) {
        this.Paragon = paragon;
    }

    public String getBasicVatAmount() {
        return this.BasicVatAmount;
    }

    public void setBasicVatAmount(String basicVatAmount) {
        this.BasicVatAmount = basicVatAmount;
    }

    public String getReducedVatAmount() {
        return this.ReducedVatAmount;
    }

    public void setReducedVatAmount(String reducedVatAmount) {
        this.ReducedVatAmount = reducedVatAmount;
    }

    public String getTaxFreeAmount() {
        return this.TaxFreeAmount;
    }

    public void setTaxFreeAmount(String taxFreeAmount) {
        this.TaxFreeAmount = taxFreeAmount;
    }

    public String getReceiptType() {
        return this.ReceiptType;
    }

    public void setReceiptType(String receiptType) {
        this.ReceiptType = receiptType;
    }

    public String getTaxBaseBasic() {
        return this.TaxBaseBasic;
    }

    public void setTaxBaseBasic(String taxBaseBasic) {
        this.TaxBaseBasic = taxBaseBasic;
    }

    public String getTaxBaseReduced() {
        return this.TaxBaseReduced;
    }

    public void setTaxBaseReduced(String taxBaseReduced) {
        this.TaxBaseReduced = taxBaseReduced;
    }

    public List<Item> getItem() {
        return this.Item;
    }

    public void setItem(List<Item> item) {
        this.Item = item;
    }

    public class Item {
        private String ItemType;
        private String Name;
        private String Price;
        private String Quantity;
        private String ReferenceReceiptId;
        private String VatRate;
        private String SpecialRegulation;
        private String SellerIdType;
        private String SellerId;
        private String VoucherNumber;

        public String getSpecialRegulation() {
            return this.SpecialRegulation;
        }

        public void setSpecialRegulation(String specialRegulation) {
            this.SpecialRegulation = specialRegulation;
        }

        public String getSellerIdType() {
            return this.SellerIdType;
        }

        public void setSellerIdType(String sellerIdType) {
            this.SellerIdType = sellerIdType;
        }

        public String getSellerId() {
            return this.SellerId;
        }

        public void setSellerId(String sellerId) {
            this.SellerId = sellerId;
        }

        public String getVoucherNumber() {
            return this.VoucherNumber;
        }

        public void setVoucherNumber(String voucherNumber) {
            this.VoucherNumber = voucherNumber;
        }

        public String getItemType() {
            return this.ItemType;
        }

        public void setItemType(String itemType) {
            this.ItemType = itemType;
        }

        public String getName() {
            return this.Name;
        }

        public void setName(String name) {
            this.Name = name;
        }

        public String getPrice() {
            return this.Price;
        }

        public void setPrice(String price) {
            this.Price = price;
        }

        public String getQuantity() {
            return this.Quantity;
        }

        public void setQuantity(String quantity) {
            this.Quantity = quantity;
        }

        public String getReferenceReceiptId() {
            return this.ReferenceReceiptId;
        }

        public void setReferenceReceiptId(String referenceReceiptId) {
            this.ReferenceReceiptId = referenceReceiptId;
        }

        public String getVatRate() {
            return this.VatRate;
        }

        public void setVatRate(String vatRate) {
            this.VatRate = vatRate;
        }
    }

    public class ReceiptResponse
    implements ResponseObject {
        private String id;
        private String Okp;
        private String Pkp;
        private String request;
        private String response;
        private String status;
        private String errorCode;
        private String errorResponse;

        @Override
        public String getPkp() {
            return this.Pkp;
        }

        public void setPkp(String pkp) {
            this.Pkp = pkp;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @Override
        public String getOkp() {
            return this.Okp;
        }

        public void setOkp(String okp) {
            this.Okp = okp;
        }

        @Override
        public String getUID() {
            return this.id;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorResponse(String errorResponse) {
            this.errorResponse = errorResponse;
        }

        @Override
        public String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public String getErrorReason() {
            return this.errorResponse;
        }

        public void setUID(String id) {
            this.id = id;
        }

        @Override
        public String getRequest() {
            return this.request;
        }

        @Override
        public String getResponse() {
            return this.response;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public void setRequest(String request) {
            this.request = request;
        }
    }
}

