/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa.receipt;

import com.notasoftwarecompany.ekasa.Encryption;
import com.notasoftwarecompany.ekasa.TDTool;
import com.notasoftwarecompany.ekasa.XMLHelper;
import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import sk.singularisdev.ekasask.utils.EKasaXML;

class XMLGenerator {
    private byte[] pkp;
    private String okp;
    private String SWID;
    private String UUID;
    private Receipt receipt;
    private Encryption encryption;
    private TDTool tdTool;

    XMLGenerator(Encryption encryption, Receipt receipt) {
        this.pkp = encryption.getPkp();
        this.okp = encryption.getOkp();
        this.SWID = encryption.getSWID();
        this.UUID = encryption.getUUID();
        this.receipt = receipt;
        this.encryption = encryption;
        this.tdTool = new TDTool();
    }

    private String GenerateHeader() {
        return "<v2:Header Exception=\"" + EKasaXML.escapeXML(this.receipt.getException()) + "\" RequestDate=\"" + EKasaXML.escapeXML(this.tdTool.getCurrentTimeStamp()) + "\" SendingCount=\"" + EKasaXML.escapeXML(this.receipt.getCounter()) + "\" SwId=\"" + EKasaXML.escapeXML(this.SWID) + "\" Uuid=\"" + EKasaXML.escapeXML(this.UUID) + "\"/>";
    }

    private String GenerateSecrets() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("<v2:ValidationCode>");
        retVal.append("<v2:PKP cipher=\"RSA2048\" digest=\"SHA256\" encoding=\"base64\">");
        retVal.append(XMLHelper.getBase64Encoded(this.pkp));
        retVal.append("</v2:PKP>");
        retVal.append("<v2:OKP digest=\"SHA1\" encoding=\"base16\">");
        retVal.append(this.okp);
        retVal.append("</v2:OKP></v2:ValidationCode>");
        return retVal.toString();
    }

    private String GenerateReceiptData() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("<v2:ReceiptData Amount=\"");
        retVal.append(EKasaXML.escapeXML(this.receipt.getAmount()));
        retVal.append("\" CashRegisterCode=\"");
        retVal.append(EKasaXML.escapeXML(this.receipt.getCashRegisterCode()));
        retVal.append("\" CreateDate=\"");
        retVal.append(EKasaXML.escapeXML(this.receipt.getCreateDate()));
        if (this.receipt.getCustomerId() != null) {
            retVal.append("\" CustomerId=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getCustomerId()));
        }
        if (this.receipt.getCustomerIdType() != null) {
            retVal.append("\" CustomerIdType=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getCustomerIdType()));
        }
        if (this.receipt.getDic() != null) {
            retVal.append("\" Dic=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getDic()));
        }
        if (this.receipt.getIcDph() != null) {
            retVal.append("\" IcDph=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getIcDph()));
        }
        if (this.receipt.getIco() != null) {
            retVal.append("\" Ico=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getIco()));
        }
        retVal.append("\" IssueDate=\"");
        retVal.append(EKasaXML.escapeXML(this.receipt.getIssueDate()));
        retVal.append("\" Paragon=\"");
        retVal.append(EKasaXML.escapeXML(this.receipt.getParagon()));
        if (this.receipt.getReceiptNumber() != null) {
            retVal.append("\" ReceiptNumber=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getReceiptNumber()));
        }
        if (this.receipt.getInvoiceNumber() != null) {
            retVal.append("\" InvoiceNumber=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getInvoiceNumber()));
        }
        if (this.receipt.getParagonNumber() != null) {
            retVal.append("\" ParagonNumber=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getParagonNumber()));
        }
        if (this.receipt.getReceiptType() != null) {
            retVal.append("\" ReceiptType=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getReceiptType()));
        }
        if (this.receipt.getReducedVatAmount() != null) {
            retVal.append("\" ReducedVatAmount=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getReducedVatAmount()));
        }
        if (this.receipt.getTaxBaseBasic() != null) {
            retVal.append("\" TaxBaseBasic=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getTaxBaseBasic()));
        }
        if (this.receipt.getTaxBaseReduced() != null) {
            retVal.append("\" TaxBaseReduced=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getTaxBaseReduced()));
        }
        if (this.receipt.getTaxFreeAmount() != null) {
            retVal.append("\" TaxFreeAmount=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getTaxFreeAmount()));
        }
        if (this.receipt.getBasicVatAmount() != null) {
            retVal.append("\" BasicVatAmount=\"");
            retVal.append(EKasaXML.escapeXML(this.receipt.getBasicVatAmount()));
        }
        retVal.append("\">");
        if (this.receipt.getItem() != null && this.receipt.getItem().size() > 0) {
            retVal.append("<v2:Items>");
            for (Receipt.Item item : this.receipt.getItem()) {
                retVal.append("<v2:Item");
                retVal.append(" ItemType=\"");
                retVal.append(EKasaXML.escapeXML(item.getItemType()));
                retVal.append("\" Name=\"");
                retVal.append(EKasaXML.escapeXML(item.getName()));
                retVal.append("\" Price=\"");
                retVal.append(EKasaXML.escapeXML(item.getPrice()));
                retVal.append("\" Quantity=\"");
                retVal.append(EKasaXML.escapeXML(item.getQuantity()));
                if (item.getReferenceReceiptId() != null) {
                    retVal.append("\" ReferenceReceiptId=\"");
                    retVal.append(EKasaXML.escapeXML(item.getReferenceReceiptId()));
                }
                retVal.append("\" VatRate=\"");
                retVal.append(EKasaXML.escapeXML(item.getVatRate()));
                if (item.getSpecialRegulation() != null) {
                    retVal.append("\" SpecialRegulation=\"");
                    retVal.append(EKasaXML.escapeXML(item.getSpecialRegulation()));
                }
                if (item.getSellerId() != null) {
                    retVal.append("\" SellerId=\"");
                    retVal.append(EKasaXML.escapeXML(item.getSellerId()));
                }
                if (item.getSellerIdType() != null) {
                    retVal.append("\" SellerIdType=\"");
                    retVal.append(EKasaXML.escapeXML(item.getSellerIdType()));
                }
                if (item.getVoucherNumber() != null) {
                    retVal.append("\" VoucherNumber=\"");
                    retVal.append(EKasaXML.escapeXML(item.getVoucherNumber()));
                }
                retVal.append("\"/>");
            }
            retVal.append("</v2:Items>");
        }
        retVal.append("</v2:ReceiptData>");
        return retVal.toString();
    }

    String GenerateFinalXML() throws IOException, WSSecurityException, CertificateException, NoSuchAlgorithmException, KeyStoreException, CredentialException {
        String body = "<soap:Body wsu:Id=\"id-2B5596EB448137D6AA15341674920959\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><v2:RegisterReceiptRequest>" + this.GenerateHeader() + this.GenerateReceiptData() + this.GenerateSecrets() + "</v2:RegisterReceiptRequest></soap:Body>";
        return XMLHelper.getFinalXML(body, this.encryption, this.receipt.getConfiguration());
    }
}

