/*
 * Decompiled with CFR 0.152.
 */
package com.notasoftwarecompany.ekasa;

public class xBase64 {
    private String lineSeparator = System.getProperty("line.separator");
    private int lineLength = 0;
    private static final char[] ENCODE = new char[64];
    private static final int[] DECODE = new int[256];
    private static final int IGNORE = -1;
    private static final int PAD = -2;
    private static final xBase64 BASE64 = new xBase64();

    static {
        int xa = 0;
        while (xa <= 25) {
            xBase64.ENCODE[xa] = (char)(65 + xa);
            ++xa;
        }
        xa = 0;
        while (xa <= 25) {
            xBase64.ENCODE[xa + 26] = (char)(97 + xa);
            ++xa;
        }
        xa = 0;
        while (xa <= 9) {
            xBase64.ENCODE[xa + 52] = (char)(48 + xa);
            ++xa;
        }
        xBase64.ENCODE[62] = 43;
        xBase64.ENCODE[63] = 47;
        xa = 0;
        while (xa < 256) {
            xBase64.DECODE[xa] = -1;
            ++xa;
        }
        xa = 0;
        while (xa < 64) {
            xBase64.DECODE[xBase64.ENCODE[xa]] = xa;
            ++xa;
        }
        xBase64.DECODE[61] = -2;
    }

    public String encode(byte[] bin) {
        return this.encode(bin, 0, bin.length);
    }

    public String encode(byte[] bin, int str, int len) {
        int lines;
        int ol = (len + 2) / 3 * 4;
        if (this.lineLength != 0 && (lines = (ol + this.lineLength - 1) / this.lineLength - 1) > 0) {
            ol += lines * this.lineSeparator.length();
        }
        StringBuffer sb = new StringBuffer(ol);
        int lp = 0;
        int el = len / 3 * 3;
        int ll = len - el;
        int xa = 0;
        while (xa < el) {
            if (this.lineLength != 0 && (lp += 4) > this.lineLength) {
                sb.append(this.lineSeparator);
                lp = 4;
            }
            int cv = bin[xa + str + 0] & 0xFF;
            cv <<= 8;
            cv |= bin[xa + str + 1] & 0xFF;
            cv <<= 8;
            int c3 = (cv |= bin[xa + str + 2] & 0xFF) & 0x3F;
            int c2 = (cv >>>= 6) & 0x3F;
            int c1 = (cv >>>= 6) & 0x3F;
            int c0 = (cv >>>= 6) & 0x3F;
            sb.append(ENCODE[c0]);
            sb.append(ENCODE[c1]);
            sb.append(ENCODE[c2]);
            sb.append(ENCODE[c3]);
            xa += 3;
        }
        if (this.lineLength != 0 && ll > 0 && (lp += 4) > this.lineLength) {
            sb.append(this.lineSeparator);
            lp = 4;
        }
        if (ll == 1) {
            byte[] byArray = new byte[3];
            byArray[0] = bin[el + str];
            sb.append(this.encode(byArray).substring(0, 2)).append("==");
        } else if (ll == 2) {
            byte[] byArray = new byte[3];
            byArray[0] = bin[el + str];
            byArray[1] = bin[el + str + 1];
            sb.append(this.encode(byArray).substring(0, 3)).append("=");
        }
        if (ol != sb.length()) {
            throw new RuntimeException("Error in Base64 encoding method: Calculated output length of " + ol + " did not match actual length of " + sb.length());
        }
        return sb.toString();
    }

    public byte[] decode(String b64) {
        return this.decode(b64, 0, b64.length());
    }

    public byte[] decode(String b64, int str, int len) {
        byte[] ba = new byte[len / 4 * 3];
        int dc = 0;
        int rv = 0;
        int ol = 0;
        int pc = 0;
        int xa = 0;
        while (xa < len) {
            int value;
            char ch = b64.charAt(xa + str);
            int n = value = ch <= '\u00ff' ? DECODE[ch] : -1;
            if (value != -1) {
                if (value == -2) {
                    value = 0;
                    ++pc;
                }
                switch (dc) {
                    case 0: {
                        rv = value;
                        dc = 1;
                        break;
                    }
                    case 1: {
                        rv <<= 6;
                        rv |= value;
                        dc = 2;
                        break;
                    }
                    case 2: {
                        rv <<= 6;
                        rv |= value;
                        dc = 3;
                        break;
                    }
                    case 3: {
                        rv <<= 6;
                        ba[ol + 2] = (byte)(rv |= value);
                        ba[ol + 1] = (byte)(rv >>>= 8);
                        ba[ol] = (byte)(rv >>>= 8);
                        ol += 3;
                        dc = 0;
                    }
                }
            }
            ++xa;
        }
        if (dc != 0) {
            throw new ArrayIndexOutOfBoundsException("Base64 data given as input was not an even multiple of 4 characters (should be padded with '=' characters).");
        }
        if (ba.length != (ol -= pc)) {
            byte[] b2 = new byte[ol];
            System.arraycopy(ba, 0, b2, 0, ol);
            ba = b2;
        }
        return ba;
    }

    public void setLineLength(int len) {
        this.lineLength = len / 4 * 4;
    }

    public void setLineSeparator(String linsep) {
        this.lineSeparator = linsep;
    }

    public static String toString(byte[] dta) {
        return BASE64.encode(dta);
    }

    public static String toString(byte[] dta, int str, int len) {
        return BASE64.encode(dta, str, len);
    }

    public static byte[] toBytes(String b64) {
        return BASE64.decode(b64);
    }

    public static byte[] toBytes(String b64, int str, int len) {
        return BASE64.decode(b64, str, len);
    }
}

