/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu;

import sk.singularisdev.chdu.Chdu;
import sk.singularisdev.chdu.ProtocolChdu;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.Socket;
import sk.singularisdev.cryptoprotocol.keys.KeyLoader;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.layers.SessionLayer;
import sk.singularisdev.cryptoprotocol.layers.TransportLayer;
import sk.singularisdev.platform.Platform;

public class ChduFactory {
    private static final String RS232 = "RS232";
    private static final Logger logger = LoggerManager.getLogger(ChduFactory.class.getName());
    private static int timeout = 10000;
    private static int packetSize = 1024;
    private static String ourIdentificationName = "";
    private static String theirIdentificationName = "";
    private static boolean keepalive = true;
    private static TransportLayer.Listener transportLayerListener;
    private static SessionLayer.OnRttStatusChangedListener rttListener;
    private static SessionLayer.SessionLayerListener sessionLayerListener;
    private static KeyLoader keyLoader;

    public static void setTimeout(int timeout) {
        ChduFactory.timeout = timeout;
    }

    public static void setPacketSize(int packetSize) {
        ChduFactory.packetSize = packetSize;
    }

    public static void setIdentification(String ourIdentificationName, String theirIdentificationName) {
        ChduFactory.ourIdentificationName = ourIdentificationName;
        ChduFactory.theirIdentificationName = theirIdentificationName;
    }

    public static void enableKeepAlive(boolean keepalive) {
        ChduFactory.keepalive = keepalive;
    }

    public static void setTransportLayerListener(TransportLayer.Listener listener) {
        transportLayerListener = listener;
    }

    public static void setRttListener(SessionLayer.OnRttStatusChangedListener listener) {
        rttListener = listener;
    }

    public static void setSessionLayerListener(SessionLayer.SessionLayerListener listener) {
        sessionLayerListener = listener;
    }

    public static void setKeyloader(KeyLoader keyloader) {
        keyLoader = keyloader;
    }

    public static Chdu createInstance(String connectionString, String secondaryConnectionString) throws ChduException {
        if (ourIdentificationName.length() == 0 || theirIdentificationName.length() == 0 || timeout < 0 || packetSize < 0) {
            logger.error("Wrong configuration for CHDU connection");
            throw new ChduException(7);
        }
        String[] tokens = connectionString.split(":");
        if (tokens.length == 0) {
            logger.error("Missing configuration for CHDU connection");
            throw new ChduException(5);
        }
        PhysicalDriver primaryPhysicalDriver = Platform.CreatePhysicalDriverInstance(connectionString);
        if (primaryPhysicalDriver == null) {
            logger.error("Unsupported Driver");
            throw new ChduException(5);
        }
        TransportLayer transportLayer = transportLayerListener == null ? new TransportLayer(primaryPhysicalDriver, new DefaultTransportLayerListener()) : new TransportLayer(primaryPhysicalDriver, transportLayerListener);
        if (rttListener == null) {
            rttListener = new SessionLayer.OnRttStatusChangedListener(){

                @Override
                public void OnChange(long rtt) {
                }
            };
        }
        SessionLayer.Builder sessionLayerBuilder = new SessionLayer.Builder(ourIdentificationName, theirIdentificationName, transportLayer, keyLoader);
        sessionLayerBuilder.setConnectionStatusListener(sessionLayerListener).setRttListener(rttListener).setKeepAliveEnabled(keepalive);
        SessionLayer sessionLayer = sessionLayerBuilder.build();
        Socket socket = new Socket(sessionLayer);
        if (secondaryConnectionString != null && secondaryConnectionString.length() > 0) {
            try {
                PhysicalDriver secondaryPhysicalDriver = Platform.CreatePhysicalDriverInstance(secondaryConnectionString);
                if (secondaryPhysicalDriver != null) {
                    TransportLayer secondaryTransportLayer = transportLayerListener == null ? new TransportLayer(secondaryPhysicalDriver, new DefaultTransportLayerListener()) : new TransportLayer(secondaryPhysicalDriver, transportLayerListener);
                    if (secondaryPhysicalDriver != null) {
                        SessionLayer.Builder secondarySessionLayerBuilder = new SessionLayer.Builder(ourIdentificationName, theirIdentificationName, secondaryTransportLayer, keyLoader);
                        secondarySessionLayerBuilder.setConnectionStatusListener(sessionLayerListener).setRttListener(rttListener).setKeepAliveEnabled(keepalive);
                        SessionLayer secondarySessionLayer = secondarySessionLayerBuilder.build();
                        Socket secondarySocket = new Socket(secondarySessionLayer);
                        return new ProtocolChdu(packetSize, socket, secondarySocket);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ProtocolChdu(packetSize, socket);
    }

    private static class DefaultTransportLayerListener
    implements TransportLayer.Listener {
        private DefaultTransportLayerListener() {
        }

        @Override
        public void onPacketCrcError() {
        }

        @Override
        public void onPacketHeaderError() {
        }

        @Override
        public void onPacketTransmitted(int length, boolean error) {
        }

        @Override
        public void onPacketReceived(int length, boolean error) {
        }
    }
}

