/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import sk.singularisdev.chdu.Chdu;
import sk.singularisdev.chdu.command.CommandFactory;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.chdu.parameter.EscSequence;
import sk.singularisdev.chdu.parameter.Others;
import sk.singularisdev.chdu.parameter.Polling;
import sk.singularisdev.chdu.parameter.Transaction;
import sk.singularisdev.chdu.protocol.Protocol;
import sk.singularisdev.chdu.result.ReadResult;
import sk.singularisdev.chdu.result.WriteResult;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.ISocket;
import sk.singularisdev.cryptoprotocol.ciphers.Util;
import sk.singularisdev.cryptoprotocol.exception.SocketException;

public class ProtocolChdu
implements Chdu {
    private final Logger logger = LoggerManager.getLogger(ProtocolChdu.class.getName());
    private int packetSize;
    private ISocket primarySocket;
    private ISocket secondarySocket;
    private ISocket activeSocket;
    private Protocol protocol;

    ProtocolChdu(int packetSize, ISocket primarySocket, ISocket secondarySocket) {
        this.packetSize = packetSize;
        this.primarySocket = primarySocket;
        this.secondarySocket = secondarySocket;
    }

    ProtocolChdu(int packetSize, ISocket socket) {
        this.packetSize = packetSize;
        this.primarySocket = socket;
    }

    @Override
    public void connect() throws ChduException {
        try {
            this.activeSocket = null;
            this.logger.info("Connecting primary socket");
            this.primarySocket.init();
            this.primarySocket.connect();
            this.activeSocket = this.primarySocket;
            this.protocol = new Protocol(this.packetSize, this.activeSocket);
            this.logger.info("Primary socket created");
        }
        catch (SocketException e) {
            this.logger.info("Primary socket connection error");
            if (this.secondarySocket != null) {
                try {
                    this.logger.info("Connecting secondary socket");
                    this.secondarySocket.init();
                    this.secondarySocket.connect();
                    this.activeSocket = this.secondarySocket;
                    this.protocol = new Protocol(this.packetSize, this.activeSocket);
                }
                catch (SocketException e1) {
                    this.logger.error("Connecting error");
                    throw new ChduException(2, (Throwable)e);
                }
            }
            throw new ChduException(2, (Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.activeSocket == null) {
            return false;
        }
        return this.activeSocket.isConnected();
    }

    @Override
    public void disconnect() {
        this.activeSocket.close();
    }

    @Override
    public WriteResult poll(Polling.Type type, Date date) throws ChduException {
        byte[] command = CommandFactory.CreatePollingCommand(type, date);
        this.logger.info("Polling: " + type.name());
        long ts = System.currentTimeMillis();
        WriteResult writeResult = this.protocol.sendWriteCommand(command, new ByteArrayInputStream(new byte[0]));
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command Polling result: " + writeResult.toString());
        return writeResult;
    }

    @Override
    public WriteResult writeTransaction(Transaction.Type transaction, Date date, Transaction.ID id, InputStream inputStream) throws ChduException {
        byte[] command = CommandFactory.CreateWriteTransactionCommand(transaction, date, id);
        long ts = System.currentTimeMillis();
        this.logger.info("Command writeTransaction: " + transaction.getString() + ": " + Util.bytesToHex(command));
        WriteResult writeResult = this.protocol.sendWriteCommand(command, inputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command writeTransaction result: " + writeResult.toString());
        return writeResult;
    }

    @Override
    public ReadResult writeEscapeSequence(EscSequence.Type type, Transaction.ID transactionID, int expectedBytes, InputStream inputStream, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateWriteEscSequenceCommand(type, transactionID, expectedBytes);
        this.logger.info("Command writeEscapeSequence: " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        ReadResult readResult = this.protocol.sendWriteReadCommand(command, inputStream, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command writeEscapeSequence result: " + readResult.toString());
        return readResult;
    }

    @Override
    public WriteResult writeOthers(Others.Write type, Date date, InputStream ... inputStreams) throws ChduException {
        byte[] command = CommandFactory.CreateWriteOthersCommand(type, date);
        this.logger.info("Command writeOthers " + type.name() + ": " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        WriteResult writeResult = this.protocol.sendWriteCommand(command, inputStreams);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command writeOthers result: " + writeResult.toString());
        return writeResult;
    }

    @Override
    public ReadResult readTransaction(Transaction.Type transactionType, Transaction.ID id, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateReadTransactionCommand(transactionType, id);
        this.logger.info("Command readTransaction " + transactionType.getString() + ": " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        ReadResult readResult = this.protocol.sendReadCommand(command, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command readTransaction result: " + readResult.toString());
        return readResult;
    }

    @Override
    public ReadResult readTransaction(Transaction.Type transactionType, Date date, Transaction.ID id, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateReadTransactionCommand(transactionType, date, id);
        this.logger.info("Command readTransaction: " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        ReadResult readResult = this.protocol.sendReadCommand(command, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command readTransaction result: " + readResult.toString());
        return readResult;
    }

    @Override
    public ReadResult readOthers(Others.Read type, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateReadOthersCommand(type);
        this.logger.info("Command readOthers " + type.name() + ": " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        ReadResult readResult = this.protocol.sendReadCommand(command, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command readOthers result: " + readResult.toString());
        return readResult;
    }

    @Override
    public ReadResult readOthers(Others.Read type, Date date, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateReadOthersCommand(type, date);
        this.logger.info("Command readOthers: " + Util.bytesToHex(command));
        long ts = System.currentTimeMillis();
        ReadResult readResult = this.protocol.sendReadCommand(command, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command readOthers result: " + readResult.toString());
        return readResult;
    }

    @Override
    public ReadResult readBin(Others.ReadBin binType, int sector, OutputStream outputStream) throws ChduException {
        byte[] command = CommandFactory.CreateReadBinCommand(binType.getValue(), sector);
        long ts = System.currentTimeMillis();
        this.logger.info("Command readBin: " + Util.bytesToHex(command));
        ReadResult readResult = this.protocol.sendReadCommand(command, outputStream);
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms] Command readBin result: " + readResult.toString());
        return readResult;
    }

    @Override
    public void interrupt() throws ChduException {
        this.protocol.interrupt();
        this.logger.info("Command interrupt");
        long ts = System.currentTimeMillis();
        WriteResult writeResult = this.poll(Polling.Type.CancelProcess, new Date());
        this.logger.info("Delta: " + (System.currentTimeMillis() - ts) + "[ms]  result: " + writeResult.toString());
    }
}

