/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.chdu.parameter.EscSequence;
import sk.singularisdev.chdu.parameter.Others;
import sk.singularisdev.chdu.parameter.Polling;
import sk.singularisdev.chdu.parameter.Transaction;

public class CommandFactory {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");

    public static byte[] CreateWriteTransactionCommand(Transaction.Type type, Date date, Transaction.ID id) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandFactory.CreateCommand((byte)27, type.getType(), date, id, baos);
        return baos.toByteArray();
    }

    public static byte[] CreatePollingCommand(Polling.Type type, Date date) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandFactory.CreateCommand((byte)59, type.getValue(), date, baos);
        return baos.toByteArray();
    }

    public static byte[] CreateWriteOthersCommand(Others.Write type, Date date) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandFactory.CreateCommand((byte)28, type.getValue(), date, baos);
        return baos.toByteArray();
    }

    public static byte[] CreateReadTransactionCommand(Transaction.Type type, Date date, Transaction.ID id) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandFactory.CreateCommand((byte)43, type.getType(), date, id, baos);
        return baos.toByteArray();
    }

    public static byte[] CreateReadTransactionCommand(Transaction.Type type, Transaction.ID id) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(43);
        baos.write(type.getType());
        baos.write(0);
        baos.write(0);
        baos.write(0);
        try {
            baos.write(id.format().getBytes());
        }
        catch (IOException e) {
            throw new ChduException(3);
        }
        baos.write(0);
        return baos.toByteArray();
    }

    public static byte[] CreateReadOthersCommand(Others.Read type, Date date) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(44);
            baos.write(type.getValue());
            baos.write(0);
            CommandFactory.addDate(date, baos);
        }
        catch (IOException e) {
            throw new ChduException(3);
        }
        return baos.toByteArray();
    }

    public static byte[] CreateReadOthersCommand(Others.Read type) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(44);
        baos.write(type.getValue());
        baos.write(0);
        baos.write(0);
        baos.write(0);
        return baos.toByteArray();
    }

    public static byte[] CreateReadBinCommand(int binType, int sector) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(45);
        baos.write(binType);
        baos.write(0);
        baos.write(sector & 0xFF);
        baos.write(sector >> 8 & 0xFF);
        baos.write(sector >> 16 & 0xFF);
        baos.write(sector >> 24 & 0xFF);
        baos.write(0);
        return baos.toByteArray();
    }

    public static byte[] CreateWriteEscSequenceCommand(EscSequence.Type type, Transaction.ID id, int expectedBytes) throws ChduException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(75);
        baos.write(type.getType());
        baos.write(0);
        try {
            baos.write(id.format().getBytes());
            baos.write(0);
            baos.write(Integer.toString(expectedBytes).getBytes());
            baos.write(0);
        }
        catch (IOException e) {
            throw new ChduException(3);
        }
        return baos.toByteArray();
    }

    public static byte[] CreateDataCommand(byte[] data, boolean last) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(58);
        baos.write(data.length & 0xFF);
        baos.write(data.length >> 8 & 0xFF);
        baos.write(data, 0, data.length);
        baos.write(0);
        baos.write(last ? 3 : 23);
        return baos.toByteArray();
    }

    private static void CreateCommand(byte command, byte type, Date date, Transaction.ID id, ByteArrayOutputStream output) throws ChduException {
        try {
            CommandFactory.CreateCommand(command, type, date, output);
            output.write(id.format().getBytes());
            output.write(0);
        }
        catch (IOException e) {
            throw new ChduException(3);
        }
    }

    private static void CreateCommand(byte command, byte type, Date date, ByteArrayOutputStream output) throws ChduException {
        try {
            output.write(command);
            output.write(type);
            output.write(0);
            CommandFactory.addDate(date, output);
        }
        catch (IOException e) {
            throw new ChduException(3);
        }
    }

    private static void addDate(Date date, ByteArrayOutputStream baos) throws IOException {
        baos.write(dateFormat.format(date).getBytes());
        baos.write(0);
        baos.write(timeFormat.format(date).getBytes());
        baos.write(0);
    }
}

