/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.parameter;

import sk.singularisdev.cryptoprotocol.command.CommandException;

public class SyncAndInfo {
    private String original;
    private String name;
    private String version;
    private String subversion;
    private String release;
    private String sn;
    private String lastTransactionId;
    private String lastPrintedTransactionId;
    private long storageSize;
    private long sectorSize;
    private long sectorCount;
    private Drive driveC;
    private Drive driveD;
    private Drive driveE;

    private SyncAndInfo() {
    }

    public static SyncAndInfo CreateInstance(byte[] data) throws CommandException {
        String original = new String(data);
        String[] tokens = original.split(";");
        if (tokens.length < 13) {
            throw new CommandException("Error parsing data into sync and info class: " + original);
        }
        SyncAndInfo syncAndInfo = new SyncAndInfo();
        syncAndInfo.original = original;
        syncAndInfo.name = tokens[0];
        String[] versionTokens = tokens[1].split("\\.");
        if (versionTokens.length < 3) {
            throw new CommandException("Error parsing data into sync and info class: " + original);
        }
        syncAndInfo.version = versionTokens[0];
        syncAndInfo.subversion = versionTokens[1];
        syncAndInfo.release = versionTokens[2];
        syncAndInfo.sn = tokens[2];
        syncAndInfo.lastTransactionId = tokens[3];
        syncAndInfo.lastPrintedTransactionId = tokens[4];
        syncAndInfo.storageSize = SyncAndInfo.ParseLong(tokens[5]);
        syncAndInfo.sectorSize = SyncAndInfo.ParseLong(tokens[6]);
        syncAndInfo.sectorCount = SyncAndInfo.ParseLong(tokens[7]);
        syncAndInfo.driveC = new Drive(SyncAndInfo.ParseLong(tokens[8]), SyncAndInfo.ParseLong(tokens[11]));
        syncAndInfo.driveD = new Drive(SyncAndInfo.ParseLong(tokens[9]), SyncAndInfo.ParseLong(tokens[12]));
        syncAndInfo.driveE = new Drive(SyncAndInfo.ParseLong(tokens[10]), SyncAndInfo.ParseLong(tokens[13]));
        return syncAndInfo;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSubVersion() {
        return this.subversion;
    }

    public String getRelease() {
        return this.release;
    }

    public String getSerialNumber() {
        return this.sn;
    }

    public String getLastTransactionId() {
        return this.lastTransactionId;
    }

    public String getLastPrintedTransactionId() {
        return this.lastPrintedTransactionId;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public long getSectorSize() {
        return this.sectorSize;
    }

    public long getSectorCount() {
        return this.sectorCount;
    }

    public Drive getDriveC() {
        return this.driveC;
    }

    public Drive getDriveD() {
        return this.driveD;
    }

    public Drive getDriveE() {
        return this.driveE;
    }

    public String toString() {
        return "SyncAndInfo{original='" + this.original + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", subversion='" + this.subversion + '\'' + ", release='" + this.release + '\'' + ", SN='" + this.sn + '\'' + ", lastTransactionId='" + this.lastTransactionId + '\'' + ", lastPrintedTransactionId='" + this.lastPrintedTransactionId + '\'' + ", storageSize=" + this.storageSize + ", sectorSize=" + this.sectorSize + ", sectorCount=" + this.sectorCount + ", driveC=" + this.driveC + ", driveD=" + this.driveD + ", driveE=" + this.driveE + '}';
    }

    private static long ParseLong(String number) throws CommandException {
        try {
            return Long.parseLong(number);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static class Drive {
        long size;
        long free;

        Drive(long size, long free) {
            this.size = size;
            this.free = free;
        }

        public long getSize() {
            return this.size;
        }

        public long getFree() {
            return this.free;
        }

        public String toString() {
            return "Drive{size=" + this.size + ", free=" + this.free + " " + (float)this.free / (float)this.size * 100.0f + "%" + '}';
        }
    }
}

