/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.parameter;

import sk.singularisdev.cryptoprotocol.utils.Utility;

public class Transaction {

    public static class ID
    implements Comparable<ID> {
        private static final int TRANSACTION_PER_DIR = 25;
        public static final ID ID_0 = new ID(0, 0);
        private int dirSeq;
        private int transSeq;
        private IDListener listener;

        public ID(int dirSeq, int transSeq, IDListener listener) {
            this.dirSeq = dirSeq;
            this.transSeq = transSeq;
            this.listener = listener;
        }

        public ID(int dirSeq, int transSeq) {
            this(dirSeq, transSeq, null);
        }

        public ID(String idString) {
            this.parse(idString);
        }

        public void setId(int dirSeq, int transSeq) {
            this.dirSeq = dirSeq;
            this.transSeq = transSeq;
        }

        public void setId(ID transactionId) {
            this.dirSeq = transactionId.dirSeq;
            this.transSeq = transactionId.transSeq;
        }

        public void increment() {
            int oldTransSeq = this.transSeq++;
            int oldDirSeq = this.dirSeq++;
            if (this.transSeq % 25 != 0 || this.transSeq > 0) {
                // empty if block
            }
            if (this.listener != null) {
                this.listener.onChduTransactionIdChanged(this, oldDirSeq, this.dirSeq, oldTransSeq, this.transSeq, this.format());
            }
        }

        public void decrement() {
            int oldTransSeq = this.transSeq;
            int oldDirSeq = this.dirSeq--;
            if (this.transSeq % 25 != 0 || this.transSeq > 0) {
                // empty if block
            }
            --this.transSeq;
            if (this.listener != null) {
                this.listener.onChduTransactionIdChanged(this, oldDirSeq, this.dirSeq, oldTransSeq, this.transSeq, this.format());
            }
        }

        public String format() {
            return String.format("%1$06d%2$08d", this.dirSeq, this.transSeq);
        }

        public void parse(String id) {
            if (id.length() == 0) {
                this.dirSeq = 0;
                this.transSeq = 0;
            } else {
                id = id.replace(".", "");
                this.dirSeq = Integer.parseInt(id.substring(0, 6));
                this.transSeq = Integer.parseInt(id.substring(6));
            }
        }

        @Override
        public int compareTo(ID other) {
            if (this.dirSeq == other.dirSeq) {
                return Utility.compare(this.transSeq, other.transSeq);
            }
            return Utility.compare(this.dirSeq, other.dirSeq);
        }
    }

    public static interface IDListener {
        public void onChduTransactionIdChanged(Object var1, int var2, int var3, int var4, int var5, String var6);
    }

    public static class Type {
        private String type;

        public Type(String type) {
            if (type == null || type.length() == 0) {
                throw new RuntimeException("Transaction type cannot be null or zero length");
            }
            this.type = type.equals("LPT") ? "0" : (type.equals("SFS_RESPONSE") ? "R" : (type.equals("SFS_REQUEST") ? "D" : (type.equals("SFS_STATUS") ? "S" : "")));
            this.type = this.type.concat(type);
        }

        public byte getType() {
            return (byte)this.type.charAt(0);
        }

        public String getString() {
            return this.type;
        }
    }
}

