/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import sk.singularisdev.chdu.command.CommandFactory;
import sk.singularisdev.chdu.exception.ChduCommunicationException;
import sk.singularisdev.chdu.result.ReadResult;
import sk.singularisdev.chdu.result.WriteResult;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.ISocket;
import sk.singularisdev.cryptoprotocol.exception.SocketException;

public class Protocol {
    private final Logger logger = LoggerManager.getLogger(Protocol.class.getName());
    private static final byte NACK = 21;
    private static final byte[] ACK_PACKET = new byte[]{6};
    private static final byte[] ETX_PACKET = new byte[]{3};
    private static final byte[] NACK_PACKET = new byte[]{21, 29};
    private int dataPacketLength;
    private ReentrantLock lock;
    private AtomicBoolean keepRunning;
    private ISocket socket;

    public Protocol(int dataPacketLength, ISocket socket) {
        this.dataPacketLength = dataPacketLength;
        this.socket = socket;
        this.lock = new ReentrantLock();
        this.keepRunning = new AtomicBoolean();
    }

    public void interrupt() {
        if (this.lock.isLocked()) {
            this.keepRunning.set(false);
        }
    }

    /*
     * Exception decompiling
     */
    public WriteResult sendWriteCommand(byte[] command, InputStream ... inputStreams) throws ChduCommunicationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ReadResult sendReadCommand(byte[] command, OutputStream outputStream) throws ChduCommunicationException {
        try {
            this.lock.lock();
            this.keepRunning.set(true);
            try {
                this.socket.send(command);
            }
            catch (SocketException e) {
                throw new ChduCommunicationException(-1001, (Throwable)e);
            }
            try {
                ReadResult readResult;
                long bytesRead = 0L;
                do {
                    if (!this.keepRunning.get()) {
                        throw new ChduCommunicationException(-1008);
                    }
                    readResult = this.readData(outputStream);
                    bytesRead += readResult.getLength();
                    if (!readResult.isError()) continue;
                    ReadResult readResult2 = readResult;
                    return readResult2;
                } while (!readResult.isEtx() || readResult.isError());
                ReadResult readResult3 = new ReadResult(bytesRead, false, true);
                return readResult3;
            }
            catch (ChduCommunicationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ChduCommunicationException(-9999, (Throwable)ex);
            }
        }
        finally {
            this.lock.unlock();
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ReadResult sendWriteReadCommand(byte[] command, InputStream inputStream, OutputStream outputStream) throws ChduCommunicationException {
        this.lock.lock();
        WriteResult writeResult = this.sendWriteCommand(command);
        if (!writeResult.isOK()) {
            ReadResult readResult = new ReadResult((byte)writeResult.getCode(), (byte)writeResult.getErrorCode().getValue(), false, false);
            return readResult;
        }
        int bytes = inputStream.available();
        byte[] data = new byte[bytes];
        int read = inputStream.read(data);
        if (read != data.length) {
            throw new ChduCommunicationException(-1004);
        }
        byte[] dataCommand = CommandFactory.CreateDataCommand(data, true);
        ReadResult readResult = this.sendReadCommand(dataCommand, outputStream);
        return readResult;
        finally {
            this.lock.unlock();
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private WriteResult sendWriteCommand(byte[] command) throws ChduCommunicationException {
        WriteResult writeResult;
        try {
            this.socket.send(command);
            byte[] resp = this.socket.read();
            if (resp.length == 0) {
                throw new ChduCommunicationException(-1002);
            }
            writeResult = new WriteResult(resp);
        }
        catch (SocketException e) {
            throw new ChduCommunicationException(-1003, (Throwable)e);
        }
        return writeResult;
    }

    private ReadResult readData(OutputStream outputStream) throws ChduCommunicationException {
        boolean success = false;
        ReadResult readResult = new ReadResult();
        try {
            byte[] resp = this.socket.read();
            if (resp.length == 0) {
                throw new ChduCommunicationException(-1002);
            }
            if (resp[0] == 21) {
                readResult = new ReadResult(resp[0], resp[1], false, true);
            } else {
                if (resp[0] != 58 || resp.length < 4) {
                    throw new ChduCommunicationException(-1005);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(resp);
                int command = bais.read();
                if (command != 58) {
                    throw new ChduCommunicationException(-1006);
                }
                int lenLow = bais.read();
                int lenHigh = bais.read();
                if (lenHigh < 0 || lenLow < 0) {
                    throw new ChduCommunicationException(-1007);
                }
                int len = (lenHigh & 0xFF) << 8 | lenLow & 0xFF;
                if (len > bais.available()) {
                    throw new ChduCommunicationException(-1007);
                }
                byte[] data = new byte[len];
                int read = bais.read(data);
                if (read != len) {
                    throw new ChduCommunicationException(-1007);
                }
                int zero = bais.read();
                int last = bais.read();
                boolean etb = last == 23;
                boolean etx = last == 3;
                success = true;
                outputStream.write(data);
                outputStream.flush();
                readResult = new ReadResult(len, etb, etx);
            }
            ReadResult readResult2 = readResult;
            return readResult2;
        }
        catch (SocketException e) {
            throw new ChduCommunicationException(-1003, (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ChduCommunicationException(3, (Throwable)e);
        }
        finally {
            try {
                if (success && !readResult.isEtx()) {
                    this.socket.send(ACK_PACKET);
                } else if (success) {
                    this.socket.send(ETX_PACKET);
                } else if (!readResult.isError() || readResult.getErrorCode() != 21) {
                    this.socket.send(NACK_PACKET);
                }
            }
            catch (SocketException socketException) {}
        }
    }

    public ISocket getSocket() {
        return this.socket;
    }
}

