/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.result;

import sk.singularisdev.chdu.error.ErrorCode;

public class ReadResult {
    private long length;
    private boolean error;
    private boolean etb;
    private boolean etx;
    private byte errorCode;
    private ErrorCode.Code errorSubCode;

    public ReadResult() {
    }

    public ReadResult(long length, boolean etb, boolean etx) {
        this.length = length;
        this.etb = etb;
        this.etx = etx;
        this.error = false;
    }

    public ReadResult(byte errorCode, byte errorSubCode, boolean etb, boolean etx) {
        this.errorCode = errorCode;
        this.errorSubCode = ErrorCode.Code.getValue(errorSubCode);
        this.etb = etb;
        this.etx = etx;
        this.error = true;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isEtb() {
        return this.etb;
    }

    public boolean isEtx() {
        return this.etx;
    }

    public byte getErrorCode() {
        return this.errorCode;
    }

    public ErrorCode.Code getErrorSubCode() {
        return this.errorSubCode;
    }

    public String toString() {
        return "ReadResult{length=" + this.length + ", error=" + this.error + ", etb=" + this.etb + ", etx=" + this.etx + ", errorCode=0x" + Integer.toHexString(this.errorCode) + ", errorSubCode=" + (this.errorSubCode != null ? this.errorSubCode.toString() : "") + '}';
    }

    public boolean isOK() {
        return !this.isError();
    }
}

