/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.chdu.result;

import sk.singularisdev.chdu.error.ErrorCode;

public class WriteResult {
    public static final int ACK = 6;
    public static final int ETX = 3;
    public static final int NACK = 21;
    public static final int UNKNOWN = -1;
    private int code;
    private ErrorCode.Code errorCode;

    public WriteResult(byte[] resp) {
        if (resp == null || resp.length == 0) {
            this.code = -1;
            this.errorCode = ErrorCode.Code.Unknown;
        } else {
            this.code = resp[0];
            if (resp.length > 1) {
                this.errorCode = ErrorCode.Code.getValue(resp[1]);
            }
        }
    }

    public boolean isOK() {
        return this.code == 6 || this.code == 3;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public ErrorCode.Code getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode.Code errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        return "WriteResult{code=0x" + Integer.toHexString(this.code) + ", errorCode=" + (this.errorCode != null ? this.errorCode.toString() : "") + '}';
    }
}

