/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.common.logs;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerJava;

public class LoggerManager {
    private static final Map<String, Logger> LOGGERS = new HashMap<String, Logger>();
    private static final Map<String, Handler> HANDLERS = new HashMap<String, Handler>();
    private static final Map<String, Filter> FILTERS = new HashMap<String, Filter>();
    private static final Map<String, Level> LEVELS = new HashMap<String, Level>();
    private static Class<? extends Logger> LOGGER_CLASS = LoggerJava.class;

    public static void setLoggerClass(Class<? extends Logger> loggerClass) {
        LOGGER_CLASS = loggerClass;
    }

    public static synchronized Logger getLogger(String name) {
        if (LOGGERS.containsKey(name)) {
            return LOGGERS.get(name);
        }
        try {
            Method m = LOGGER_CLASS.getMethod("getLogger", String.class);
            Logger logger = LOGGER_CLASS.cast(m.invoke(null, name));
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.OFF);
            logger.removeAllHandler();
            for (String n : HANDLERS.keySet()) {
                if (!name.startsWith(n)) continue;
                logger.addHandler(HANDLERS.get(n));
            }
            for (String n : FILTERS.keySet()) {
                if (!name.startsWith(n)) continue;
                logger.setFilter(FILTERS.get(n));
            }
            for (String n : LEVELS.keySet()) {
                if (!name.startsWith(n)) continue;
                logger.setLevel(LEVELS.get(n));
            }
            LOGGERS.put(name, logger);
            return logger;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized boolean addHandler(String name, Handler handler) {
        boolean changed = false;
        HANDLERS.put(name, handler);
        for (String n : LOGGERS.keySet()) {
            if (!n.startsWith(name)) continue;
            changed = true;
            LOGGERS.get(n).addHandler(handler);
        }
        return changed;
    }

    public synchronized boolean removeHandler(Handler handler) {
        boolean removed = false;
        for (String handlerName : HANDLERS.keySet()) {
            if (HANDLERS.get(handlerName) != handler) continue;
            for (String loggerName : LOGGERS.keySet()) {
                if (!loggerName.startsWith(handlerName)) continue;
                LOGGERS.get(loggerName).removeHandler(handler);
                removed = true;
            }
            HANDLERS.remove(handlerName);
        }
        return removed;
    }

    public synchronized void removeAllHandler() {
        for (String loggerName : LOGGERS.keySet()) {
            LOGGERS.get(loggerName).removeAllHandler();
        }
        HANDLERS.clear();
    }

    public static boolean setFilter(String name, Filter filter) {
        boolean changed = false;
        FILTERS.put(name, filter);
        for (String n : LOGGERS.keySet()) {
            if (!n.startsWith(name)) continue;
            changed = true;
            LOGGERS.get(n).setFilter(filter);
        }
        return changed;
    }

    public static boolean setLevel(String name, Level level) {
        boolean changed = false;
        LEVELS.put(name, level);
        for (String n : LOGGERS.keySet()) {
            if (!n.startsWith(name)) continue;
            changed = true;
            LOGGERS.get(n).setLevel(level);
        }
        return changed;
    }
}

