/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol;

import java.io.OutputStream;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.ISocket;
import sk.singularisdev.cryptoprotocol.exception.SessionException;
import sk.singularisdev.cryptoprotocol.exception.SocketException;
import sk.singularisdev.cryptoprotocol.layers.SessionLayer;

public class Socket
implements ISocket {
    private final Logger logger = LoggerManager.getLogger(Socket.class.getName());
    private SessionLayer sessionLayer;
    private boolean initialized;

    public Socket(SessionLayer sessionLayer) {
        this.sessionLayer = sessionLayer;
        this.initialized = false;
    }

    @Override
    public void init() throws SocketException {
        try {
            this.initialized = true;
            this.sessionLayer.init();
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            throw new SocketException(8);
        }
    }

    @Override
    public void connect() throws SocketException {
        if (!this.initialized) {
            throw new SocketException(1);
        }
        try {
            this.sessionLayer.connect();
            this.sessionLayer.createSecuredChannel();
            this.logger.info("Selected cipher: " + this.sessionLayer.getSymmetricCipher().toString());
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            throw new SocketException(3, (Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.sessionLayer.isConnected();
    }

    @Override
    @Deprecated
    public void bind() {
        throw new RuntimeException("Unimplemented !!!");
    }

    @Override
    public long ping() throws SocketException {
        if (!this.initialized) {
            throw new SocketException(1);
        }
        try {
            return this.sessionLayer.requestKeepAlive();
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            throw new SocketException(7, (Throwable)e);
        }
    }

    @Override
    public byte[] read() throws SocketException {
        if (!this.initialized) {
            throw new SocketException(1);
        }
        try {
            return this.sessionLayer.read();
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            this.logger.error("Error reading data from socket: " + e.getMessage());
            throw new SocketException(6, (Throwable)e);
        }
    }

    @Override
    public void read(OutputStream outputStream) throws SocketException {
        if (!this.initialized) {
            throw new SocketException(1);
        }
        try {
            this.sessionLayer.read(outputStream);
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            this.logger.error("Error reading data from socket: " + e.getMessage());
            throw new SocketException(6, (Throwable)e);
        }
    }

    @Override
    public void send(byte[] data) throws SocketException {
        if (!this.initialized) {
            throw new SocketException(1);
        }
        try {
            this.sessionLayer.send(data);
        }
        catch (SessionException e) {
            this.sessionLayer.close();
            throw new SocketException(5, (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.sessionLayer.close();
            Thread.sleep(100L);
        }
        catch (Exception ex) {
            this.logger.error("Error closing socket: " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.sessionLayer.getPpekkName();
    }
}

