/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.algorithm;

public class SupportedAlgorithms {

    public static enum HMAC {
        No(0, "Unknown", 0),
        SHA1(1280, "HmacSHA1", 20),
        SHA224(1281, "HmacSHA224", 28),
        SHA256(1282, "HmacSHA256", 32),
        SHA384(1283, "HmacSHA384", 48),
        SHA512(1284, "HmacSHA512", 64),
        Unknown(65535, "Unknown", 0);

        private final int id;
        private final int keySize;
        private String name;

        private HMAC(int id, String name, int keySize) {
            this.id = id;
            this.name = name;
            this.keySize = keySize;
        }

        public static HMAC getById(int id) {
            HMAC[] hMACArray = HMAC.values();
            int n = hMACArray.length;
            int n2 = 0;
            while (n2 < n) {
                HMAC s = hMACArray[n2];
                if (s.id == id) {
                    return s;
                }
                ++n2;
            }
            return Unknown;
        }

        public int getId() {
            return this.id;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public String getStringRepresentation() {
            return this.name;
        }
    }

    public static enum SymmetricCipher {
        Raw(256),
        Aes128Cbc(257),
        Unknown(65535);

        private final int id;

        private SymmetricCipher(int id) {
            this.id = id;
        }

        public static SymmetricCipher getById(int id) {
            SymmetricCipher[] symmetricCipherArray = SymmetricCipher.values();
            int n = symmetricCipherArray.length;
            int n2 = 0;
            while (n2 < n) {
                SymmetricCipher s = symmetricCipherArray[n2];
                if (s.id == id) {
                    return s;
                }
                ++n2;
            }
            return Unknown;
        }

        public int getId() {
            return this.id;
        }
    }
}

