/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.ciphers;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.cryptoprotocol.ciphers.SymmetricCipher;
import sk.singularisdev.cryptoprotocol.ciphers.SymmetricCipherException;

public class Aes128Cbc
implements SymmetricCipher {
    private IvParameterSpec ivParameterSpec;
    private SecretKeySpec secretKeySpec;
    private Cipher cipher;

    public Aes128Cbc(byte[] key, byte[] iv) {
        this.ivParameterSpec = new IvParameterSpec(iv);
        this.secretKeySpec = new SecretKeySpec(key, "AES");
    }

    @Override
    public void init() throws SymmetricCipherException {
        this.createCipherInstance();
    }

    private void createCipherInstance() throws SymmetricCipherException {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SymmetricCipherException("AES/128/CBC initialization error");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new SymmetricCipherException("AES/128/CBC initialization error");
        }
    }

    public void setKey(byte[] key) throws SymmetricCipherException {
        this.secretKeySpec = new SecretKeySpec(key, "AES");
        this.createCipherInstance();
    }

    public void setIv(byte[] iv) throws SymmetricCipherException {
        this.ivParameterSpec = new IvParameterSpec(iv);
        this.createCipherInstance();
    }

    @Override
    public byte[] encrypt(byte[] input) throws SymmetricCipherException {
        try {
            this.cipher.init(1, (Key)this.secretKeySpec, this.ivParameterSpec);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SymmetricCipherException("AES/128/CBC encryption error");
        }
    }

    @Override
    public byte[] decrypt(byte[] input) throws SymmetricCipherException {
        try {
            this.cipher.init(2, (Key)this.secretKeySpec, this.ivParameterSpec);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SymmetricCipherException("AES/128/CBC decryption error");
        }
    }

    public String toString() {
        return "AES/128/CBC";
    }
}

