/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.ciphers;

import java.io.ByteArrayOutputStream;

public class Util {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, char delimiter, int lineLen) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            baos.write(hexArray[v >>> 4]);
            baos.write(hexArray[v & 0xF]);
            baos.write(delimiter);
            if ((j + 1) % lineLen == 0) {
                baos.write(10);
            }
            ++j;
        }
        return new String(baos.toByteArray());
    }

    public static String bytesToHex(byte[] bytes, char delimiter) {
        char[] hexChars = new char[bytes.length * 3];
        int j = 0;
        int i = 0;
        while (j < bytes.length) {
            int v = bytes[i] & 0xFF;
            hexChars[j * 3] = hexArray[v >>> 4];
            hexChars[j * 3 + 1] = hexArray[v & 0xF];
            hexChars[j * 3 + 2] = delimiter;
            ++j;
            ++i;
        }
        return new String(hexChars);
    }
}

