/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.command;

import java.io.ByteArrayOutputStream;

public class Command {
    private CommandType command;
    private byte version;
    private byte subVersion;
    private int id;
    private boolean isLast;
    private Status status;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public CommandType getCommand() {
        return this.command;
    }

    public void setCommand(CommandType command) {
        this.command = command;
    }

    public short getVersion() {
        return this.version;
    }

    public short getSubVersion() {
        return this.subVersion;
    }

    public void setVersion(byte version) {
        this.subVersion = (byte)(version & 0xF);
        this.version = (byte)((version & 0xF0) >> 4);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void setLast(boolean last) {
        this.isLast = last;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setData(byte[] array) {
        this.bos.write(array, 0, array.length);
    }

    public void resetData() {
        this.bos.reset();
    }

    public byte[] getData() {
        return this.bos.toByteArray();
    }

    public static enum CommandType {
        ExchangeCertificateReq(1),
        ExchangeCertificateResp(2),
        ExchangeCiphersReq(3),
        ExchangeCiphersResp(4),
        ExchangeSharedSecretKeyReq(5),
        ExchangeSharedSecretKeyResp(6),
        CreateSecureSessionReq(7),
        CreateSecureSessionResp(8),
        CloseConnectionReq(9),
        CloseConnectionResp(10),
        ExchangePubKeysReq(17),
        ExchangePubKeysResp(18),
        ForceCloseConnection(64),
        KeepAlive(80),
        Initialize(96),
        EncryptedData(128),
        DataSignature(129),
        Unknown(255);

        private int value;

        private CommandType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CommandType GetValue(int id) {
            CommandType[] values;
            CommandType[] commandTypeArray = values = CommandType.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                CommandType value1 = commandTypeArray[n2];
                if (value1.getValue() == id) {
                    return value1;
                }
                ++n2;
            }
            return Unknown;
        }
    }

    static enum Status {
        OK(0),
        Unknown(255);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        public static Status GetValue(int id) {
            Status[] values;
            Status[] statusArray = values = Status.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Status value1 = statusArray[n2];
                if (value1.getValue() == id) {
                    return value1;
                }
                ++n2;
            }
            return Unknown;
        }

        public int getValue() {
            return this.value;
        }
    }
}

