/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.command;

import java.io.ByteArrayOutputStream;
import java.util.List;
import sk.singularisdev.cryptoprotocol.algorithm.SupportedAlgorithms;
import sk.singularisdev.cryptoprotocol.command.Command;

public class CommandFactory {
    private static ByteArrayOutputStream createEnvelope(Command.CommandType command, boolean isLast, short id, byte status) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(command.getValue());
        bos.write(isLast ? 1 : 0);
        bos.write(id & 0xFF);
        bos.write(id >> 8 & 0xFF);
        bos.write(1);
        bos.write(status);
        return bos;
    }

    public static byte[] CreatePublicKeyExchangeRequest(String publicKey) {
        byte[] pubKey = publicKey.getBytes();
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.ExchangePubKeysReq, true, (short)0, (byte)0);
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(pubKey, 0, pubKey.length);
        bos.write(0);
        return bos.toByteArray();
    }

    public static byte[] CreateCreateSecureSessionRequest(String name, byte[] encryptedBuffer) {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.CreateSecureSessionReq, true, (short)0, (byte)0);
        bos.write(name.getBytes(), 0, name.length());
        bos.write(0);
        bos.write(encryptedBuffer, 0, encryptedBuffer.length);
        return bos.toByteArray();
    }

    public static byte[] CreateSupportedCiphers(List<SupportedAlgorithms.SymmetricCipher> symmetricCiphers) {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.ExchangeCiphersReq, true, (short)0, (byte)0);
        for (SupportedAlgorithms.SymmetricCipher sc : symmetricCiphers) {
            short value = (short)sc.getId();
            bos.write(value & 0xFF);
            bos.write(value >> 8 & 0xFF);
        }
        return bos.toByteArray();
    }

    public static byte[] CreateSharedSecretKey(byte[] bytes) {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.ExchangeSharedSecretKeyReq, true, (short)0, (byte)0);
        bos.write(bytes, 0, bytes.length);
        return bos.toByteArray();
    }

    public static byte[] CreateEncryptedDataPacket(byte[] payload, boolean isLast, short id, byte status) {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.EncryptedData, isLast, id, status);
        bos.write(payload, 0, payload.length);
        return bos.toByteArray();
    }

    public static byte[] CreateDataFinPacket(byte[] signature, short id, byte status) {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.DataSignature, true, id, status);
        bos.write(signature, 0, signature.length);
        return bos.toByteArray();
    }

    public static byte[] CreateCloseSocketCommand() {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.CloseConnectionReq, true, (short)0, (byte)0);
        return bos.toByteArray();
    }

    public static byte[] CreateKeepAliveCommand() {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.KeepAlive, true, (short)0, (byte)0);
        return bos.toByteArray();
    }

    public static byte[] CreateInitializeCommand() {
        ByteArrayOutputStream bos = CommandFactory.createEnvelope(Command.CommandType.Initialize, true, (short)0, (byte)0);
        return bos.toByteArray();
    }
}

