/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import sk.singularisdev.cryptoprotocol.command.Command;
import sk.singularisdev.cryptoprotocol.command.CommandException;
import sk.singularisdev.cryptoprotocol.command.ParsingException;

public class CommandParser {
    public static Command ParseCommand(byte[] packet) throws CommandException {
        int read;
        Command command = new Command();
        ByteArrayInputStream bis = new ByteArrayInputStream(packet);
        int commandValue = bis.read();
        int isLast = bis.read();
        int idLow = bis.read();
        int idHigh = bis.read();
        int version = bis.read();
        int status = bis.read();
        if (commandValue == -1 || isLast == -1 || idLow == -1 || idHigh == -1 || version == -1 || status == -1) {
            throw new ParsingException("Error parsing exception");
        }
        Command.CommandType commandType = Command.CommandType.GetValue(commandValue);
        command.setCommand(commandType);
        command.setLast(CommandParser.ParseBoolean(isLast));
        command.setId(CommandParser.ParseShort(idLow, idHigh));
        command.setVersion((byte)version);
        command.setStatus(Command.Status.GetValue(status));
        int avail = bis.available();
        byte[] array = new byte[avail];
        if (avail > 0 && (read = bis.read(array, 0, avail)) != avail) {
            throw new ParsingException("Error parsing exception");
        }
        command.setData(array);
        return command;
    }

    public static Object ParseCommandParameters(Command command) {
        switch (command.getCommand()) {
            case ExchangeCertificateReq: 
            case ExchangeCertificateResp: {
                CommandParser.ParseCertificate(command);
                break;
            }
            case ExchangePubKeysReq: 
            case ExchangePubKeysResp: {
                return CommandParser.ParsePubKey(command);
            }
            case ExchangeCiphersReq: {
                break;
            }
            case ExchangeCiphersResp: {
                return CommandParser.ParseSelectedCipher(command);
            }
            case CreateSecureSessionResp: {
                break;
            }
            case ExchangeSharedSecretKeyReq: {
                break;
            }
            case ExchangeSharedSecretKeyResp: {
                break;
            }
            case CreateSecureSessionReq: {
                break;
            }
            case CloseConnectionReq: {
                break;
            }
            case CloseConnectionResp: {
                break;
            }
            case ForceCloseConnection: {
                break;
            }
            case KeepAlive: {
                break;
            }
            case EncryptedData: {
                break;
            }
            case DataSignature: {
                return CommandParser.ParseSignature(command);
            }
            case Initialize: {
                return CommandParser.ParseSerialNumber(command);
            }
            case Unknown: {
                break;
            }
        }
        return null;
    }

    private static Object ParseSignature(Command command) {
        return command.getData();
    }

    private static Object ParseSelectedCipher(Command command) {
        SelectedCipher selectedCipher = new SelectedCipher();
        ByteArrayInputStream bis = new ByteArrayInputStream(command.getData());
        if (bis.available() < 2) {
            return selectedCipher;
        }
        selectedCipher.selectedCipher = CommandParser.ParseShort(bis.read(), bis.read());
        return selectedCipher;
    }

    private static String ParseSerialNumber(Command command) {
        int val;
        StringBuilder stringBuilder = new StringBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(command.getData());
        while ((val = bis.read()) != -1 && val != 0) {
            stringBuilder.append((char)val);
        }
        return stringBuilder.toString();
    }

    public static CreateSecuredSessionStatus ParseCreateSecureSessionRespParameters(Command command, Cipher cipher) throws BadPaddingException, IllegalBlockSizeException {
        int val;
        CreateSecuredSessionStatus status = new CreateSecuredSessionStatus();
        ByteArrayInputStream bis = new ByteArrayInputStream(command.getData());
        StringBuilder stringBuilder = new StringBuilder();
        while ((val = bis.read()) != -1 && val != 0) {
            stringBuilder.append((char)val);
        }
        byte[] encodedBuffer = new byte[bis.available()];
        try {
            bis.read(encodedBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] decodedKeyBytes = cipher.doFinal(encodedBuffer);
        bis = new ByteArrayInputStream(decodedKeyBytes);
        status.code = bis.read();
        status.subCode = CreateSecuredSessionStatus.Error.GetValue(bis.read());
        status.symmetricAlgId = CommandParser.ParseShort(bis.read(), bis.read());
        status.hmacAlgId = CommandParser.ParseShort(bis.read(), bis.read());
        while (bis.available() > 0) {
            status.sharedRandomData.write(bis.read());
        }
        status.name = stringBuilder.toString();
        return status;
    }

    private static void ParseCertificate(Command command) {
    }

    private static PublicKeyParameter ParsePubKey(Command command) {
        ByteArrayInputStream bis = new ByteArrayInputStream(command.getData());
        PublicKeyParameter publicKeyParameter = new PublicKeyParameter();
        if (bis.available() < 4) {
            return publicKeyParameter;
        }
        publicKeyParameter.result = CommandParser.ParseInt(bis.read(), bis.read(), bis.read(), bis.read());
        publicKeyParameter.pemPublicKey = "";
        StringBuilder sb = new StringBuilder();
        while (bis.available() > 0) {
            int b = bis.read();
            if (b == 0) continue;
            sb.append((char)b);
        }
        publicKeyParameter.pemPublicKey = sb.toString();
        return publicKeyParameter;
    }

    private static int ParseInt(int llow, int lhigh, int hlow, int hhigh) {
        short low = (short)((lhigh & 0xFF) << 8 | llow & 0xFF);
        short high = (short)((hhigh & 0xFF) << 8 | hlow & 0xFF);
        return (high & 0xFFFF) << 16 | low & 0xFFFF;
    }

    private static int ParseShort(int low, int high) {
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    private static boolean ParseBoolean(int value) {
        return value != 0;
    }

    public static class CreateSecuredSessionStatus {
        public int code;
        public Error subCode;
        public String name;
        public ByteArrayOutputStream sharedRandomData = new ByteArrayOutputStream();
        public int symmetricAlgId;
        public int hmacAlgId;

        public static enum Error {
            OK(0),
            ErrorReadingPrivateKey(1),
            ErrorDecryptingData(2),
            ErrorComputingShaSignature(3),
            ErrorParsingName(4),
            ErrorParsingSymmetricCipherType(5),
            ErrorParsingHMACType(6),
            ErrorAllocatingMemory(7),
            WrongShaSignature(8),
            WrongCipher(9),
            WrongHMAC(10),
            UnsupportedClient(11),
            UnknownError(100);

            private int id;

            private Error(int i) {
                this.id = i;
            }

            private int getValue() {
                return this.id;
            }

            public static Error GetValue(int id) {
                Error[] values;
                Error[] errorArray = values = Error.values();
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Error value1 = errorArray[n2];
                    if (value1.getValue() == id) {
                        return value1;
                    }
                    ++n2;
                }
                return UnknownError;
            }
        }
    }

    public static class PublicKeyParameter {
        public int result;
        public String pemPublicKey;
    }

    public static class SelectedCipher {
        public int selectedCipher = 0;
    }
}

