/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.layers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.algorithm.SupportedAlgorithms;
import sk.singularisdev.cryptoprotocol.ciphers.Aes128Cbc;
import sk.singularisdev.cryptoprotocol.ciphers.SymmetricCipher;
import sk.singularisdev.cryptoprotocol.ciphers.SymmetricCipherException;
import sk.singularisdev.cryptoprotocol.ciphers.Unencrypted;
import sk.singularisdev.cryptoprotocol.ciphers.Util;
import sk.singularisdev.cryptoprotocol.command.Command;
import sk.singularisdev.cryptoprotocol.command.CommandException;
import sk.singularisdev.cryptoprotocol.command.CommandFactory;
import sk.singularisdev.cryptoprotocol.command.CommandParser;
import sk.singularisdev.cryptoprotocol.exception.SessionException;
import sk.singularisdev.cryptoprotocol.exception.TransportLayerException;
import sk.singularisdev.cryptoprotocol.keys.KeyLoader;
import sk.singularisdev.cryptoprotocol.keys.KeyParseException;
import sk.singularisdev.cryptoprotocol.keys.KeyStoreException;
import sk.singularisdev.cryptoprotocol.layers.TransportLayer;

public class SessionLayer {
    private final Logger logger = LoggerManager.getLogger(SessionLayer.class.getName());
    private final boolean keepAliveEnabled;
    private boolean transportLayerConnected;
    private boolean connected;
    private String ppekkName;
    private String chduSerialNumber;
    private final String expectedChduName;
    private String receivedChduName;
    private KeyLoader keyLoader;
    private static final int MaxPacketSize = 1024;
    private TransportLayer transportLayer;
    private SupportedAlgorithms.SymmetricCipher encryptionCipher;
    private SupportedAlgorithms.HMAC hmac;
    private SymmetricCipher symmetricCipher;
    private SecretKeySpec signingKey;
    private Mac mac;
    private AtomicBoolean enableKeepAlive;
    private Lock communicationLock;
    private AtomicLong communicationTimestamp;
    private RSAPublicKey serverPublicKey;
    private RSAPrivateKey privateKey;
    private boolean closeSilently;
    private List<Long> rttList;
    private SessionLayerListener listener;
    private OnRttStatusChangedListener rttListener;
    private ScheduledExecutorService ses;

    private SessionLayer(String ppekkName, String expectedChduName, TransportLayer transportLayer, boolean keepAliveEnabled, KeyLoader keyLoader, SessionLayerListener listener, OnRttStatusChangedListener rttListener) {
        this.logger.info("Session layer created");
        this.ppekkName = ppekkName;
        this.expectedChduName = expectedChduName;
        this.keyLoader = keyLoader;
        this.enableKeepAlive = new AtomicBoolean();
        this.transportLayer = transportLayer;
        this.encryptionCipher = SupportedAlgorithms.SymmetricCipher.Aes128Cbc;
        this.hmac = SupportedAlgorithms.HMAC.SHA256;
        this.symmetricCipher = new Unencrypted();
        this.closeSilently = false;
        this.keepAliveEnabled = keepAliveEnabled;
        this.connected = false;
        this.listener = listener;
        this.communicationLock = new ReentrantLock();
        this.communicationTimestamp = new AtomicLong();
        this.rttListener = rttListener;
        this.rttList = new ArrayList<Long>();
    }

    public String getPpekkName() {
        return this.receivedChduName != null ? this.receivedChduName : "";
    }

    public SymmetricCipher getSymmetricCipher() {
        return this.symmetricCipher;
    }

    public boolean isConnected() {
        try {
            this.lock();
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void init() throws SessionException {
        try {
            try {
                this.lock();
                this.logger.info("Initialization started");
                this.serverPublicKey = this.keyLoader.loadServerPublicKey();
                this.privateKey = this.keyLoader.loadSelfPrivateKey();
                this.transportLayer.init();
                this.connected = false;
                this.logger.info("Initialization finished");
            }
            catch (KeyParseException e) {
                this.logger.error("Initialization error", e);
                e.printStackTrace();
                throw new SessionException(12, (Throwable)e);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void connect() throws SessionException {
        try {
            try {
                this.lock();
                try {
                    this.connected = true;
                    this.transportLayerConnected = true;
                    this.logger.info("Connecting");
                    this.transportLayer.connect();
                    this.logger.info("Connected");
                }
                catch (TransportLayerException e) {
                    this.connected = false;
                    this.transportLayerConnected = false;
                    this.logger.error("Connection error: " + e);
                    throw new SessionException(1);
                }
            }
            catch (SessionException e) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw e;
            }
            catch (Exception e) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw new SessionException(1, (Throwable)e);
            }
        }
        finally {
            this.unlock();
        }
        this.logger.info("Pinging CHDU");
        this.connected = true;
        this.transportLayerConnected = true;
        this.requestInitialize();
        this.logger.info("CHDU pinged SN: " + (this.chduSerialNumber != null ? this.chduSerialNumber : "Unknown"));
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void createSecuredChannel() throws SessionException {
        this.logger.info("Creating secured channel");
        try {
            try {
                byte[] key;
                byte[] encodedKeyBytes;
                byte[] hash;
                String serverPublicKeyPem;
                this.lock();
                if (!this.transportLayerConnected) {
                    throw new SessionException(20);
                }
                this.connected = true;
                try {
                    serverPublicKeyPem = this.keyLoader.loadServerPublicKeyPem();
                    this.logger.debug("Server key loaded");
                }
                catch (KeyParseException e) {
                    throw new SessionException(12, (Throwable)e);
                }
                try {
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    hash = digest.digest(serverPublicKeyPem.getBytes());
                    this.logger.debug("SHA256: " + Util.bytesToHex(hash));
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.error("Cannot create SHA256 instance", e);
                    throw new RuntimeException("Cannot create SHA256 instance!!!");
                }
                byte[] random = this.createRandom();
                byte[] securedChannelSpecCommand = this.createSecuredChannelSpecCommand(random, hash);
                try {
                    Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                    cipher.init(1, this.serverPublicKey);
                    encodedKeyBytes = cipher.doFinal(securedChannelSpecCommand);
                }
                catch (Exception e) {
                    this.logger.error("RSA encryption error", e);
                    throw new SessionException(2, (Throwable)e);
                }
                try {
                    byte[] packet = CommandFactory.CreateCreateSecureSessionRequest(this.ppekkName, encodedKeyBytes);
                    this.transmit(packet);
                }
                catch (TransportLayerException e) {
                    this.logger.error("Transmitting shared secret error" + e);
                    throw new SessionException(3, (Throwable)e);
                }
                try {
                    byte[] receivedSHA;
                    CommandParser.CreateSecuredSessionStatus securedSessionStatus;
                    Command command = this.receive();
                    if (command.getCommand() != Command.CommandType.CreateSecureSessionResp) {
                        this.closeSilently = true;
                        throw new SessionException(13);
                    }
                    try {
                        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                        cipher.init(2, this.privateKey);
                        securedSessionStatus = CommandParser.ParseCreateSecureSessionRespParameters(command, cipher);
                    }
                    catch (Exception e) {
                        this.logger.error("RSA encryption error", e);
                        throw new SessionException(4, (Throwable)e);
                    }
                    if (securedSessionStatus == null || securedSessionStatus.code != 6) {
                        if (securedSessionStatus != null) {
                            this.logger.error("Error creating secured connection: " + securedSessionStatus.subCode.name());
                        } else {
                            this.logger.error("Error parsing status");
                        }
                        throw new SessionException(5);
                    }
                    this.receivedChduName = securedSessionStatus.name;
                    if (!this.expectedChduName.startsWith(securedSessionStatus.name)) {
                        this.logger.error("Unsupported Server Exception: Cannot communicate with: " + securedSessionStatus.name);
                        throw new SessionException(6);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(securedSessionStatus.sharedRandomData.toByteArray());
                    int read = byteArrayInputStream.read(receivedSHA = new byte[32]);
                    if (read != 32) {
                        this.logger.error("Error parsing response");
                        throw new SessionException(7);
                    }
                    read = byteArrayInputStream.read(random);
                    if (read != random.length) {
                        this.logger.error("Error parsing response");
                        throw new SessionException(7);
                    }
                }
                catch (TransportLayerException e) {
                    this.logger.error("Error creating secured connection", e);
                    throw new SessionException(8, (Throwable)e);
                }
                catch (CommandException e) {
                    this.logger.error("Command parsing error", e);
                    throw new SessionException(7, (Throwable)e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SessionException(15, (Throwable)e);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(random);
                switch (this.encryptionCipher) {
                    case Aes128Cbc: {
                        key = new byte[16];
                        int read = byteArrayInputStream.read(key, 0, 16);
                        if (read != 16) {
                            throw new SessionException(4);
                        }
                        byte[] iv = new byte[16];
                        this.symmetricCipher = new Aes128Cbc(key, iv);
                        break;
                    }
                }
                key = new byte[this.hmac.getKeySize()];
                int read = byteArrayInputStream.read(key, 0, key.length);
                if (read != key.length) {
                    throw new SessionException(4);
                }
                this.signingKey = new SecretKeySpec(key, this.hmac.getStringRepresentation());
                this.mac = null;
                try {
                    this.mac = Mac.getInstance(this.hmac.getStringRepresentation());
                    this.mac.init(this.signingKey);
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.error("Error HMAC initialization", e);
                    throw new SessionException(9, (Throwable)e);
                }
                catch (InvalidKeyException e) {
                    this.logger.error("Error HMAC key initialization", e);
                    throw new SessionException(10, (Throwable)e);
                }
                try {
                    this.symmetricCipher.init();
                }
                catch (SymmetricCipherException e) {
                    this.logger.error("Error symmetric cipher initialization", e);
                    throw new SessionException(9, (Throwable)e);
                }
                this.listener.OnConnected();
                this.startScheduler();
            }
            catch (SessionException ex) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw ex;
            }
            catch (Exception ex) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw new SessionException(99, (Throwable)ex);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void requestPublicKeysExchange() throws SessionException {
        if (!this.transportLayerConnected) {
            throw new SessionException(20);
        }
        try {
            try {
                this.lock();
                byte[] packet = CommandFactory.CreatePublicKeyExchangeRequest(this.keyLoader.loadSelfPublicKeyPem());
                try {
                    this.transmit(packet);
                }
                catch (TransportLayerException e) {
                    this.logger.error("Sending packet error. Caused by Transport layer");
                    throw new SessionException(8, (Throwable)e);
                }
                try {
                    Command command = this.receive();
                    Object o = CommandParser.ParseCommandParameters(command);
                    if (o instanceof CommandParser.PublicKeyParameter) {
                        CommandParser.PublicKeyParameter publicKeyParameter = (CommandParser.PublicKeyParameter)o;
                        this.keyLoader.storeServerPublicKey(publicKeyParameter.pemPublicKey);
                        this.serverPublicKey = this.keyLoader.loadServerPublicKey();
                    }
                }
                catch (TransportLayerException e) {
                    this.logger.error("Receiving packet error. Caused by Transport layer");
                    throw new SessionException(8, (Throwable)e);
                }
                catch (CommandException e) {
                    this.logger.error("Command creating exception");
                    throw new SessionException(11, (Throwable)e);
                }
                catch (KeyParseException e) {
                    this.logger.error("Error parsing server public key");
                    throw new SessionException(12, (Throwable)e);
                }
                catch (KeyStoreException e) {
                    this.logger.error("Error storing server public key");
                    throw new SessionException(12, (Throwable)e);
                }
            }
            catch (SessionException ex) {
                this.connected = false;
                throw ex;
            }
            catch (Exception ex) {
                this.connected = false;
                this.logger.error("Unknown error: " + ex.getMessage());
                throw new SessionException(99, (Throwable)ex);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void requestSymmetricCipherExchange(List<SupportedAlgorithms.SymmetricCipher> symmetricCiphers) throws SessionException {
        if (!this.transportLayerConnected) {
            throw new SessionException(20);
        }
        try {
            try {
                this.lock();
                byte[] packet = CommandFactory.CreateSupportedCiphers(symmetricCiphers);
                try {
                    this.transmit(packet);
                }
                catch (TransportLayerException e) {
                    e.printStackTrace();
                    throw new SessionException(8, (Throwable)e);
                }
                try {
                    Command command = this.receive();
                    Object o = CommandParser.ParseCommandParameters(command);
                    if (o instanceof CommandParser.SelectedCipher) {
                        CommandParser.SelectedCipher selectedCipher = (CommandParser.SelectedCipher)o;
                        this.encryptionCipher = SupportedAlgorithms.SymmetricCipher.getById(selectedCipher.selectedCipher);
                    }
                }
                catch (TransportLayerException e) {
                    this.logger.error("Transport layer exception");
                    throw new SessionException(8, (Throwable)e);
                }
                catch (CommandException e) {
                    this.logger.error("Command creating exception");
                    throw new SessionException(11);
                }
            }
            catch (SessionException ex) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw ex;
            }
            catch (Exception ex) {
                this.connected = false;
                this.transportLayerConnected = false;
                throw new SessionException(99);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void send(byte[] data) throws SessionException {
        if (!this.connected || !this.transportLayerConnected) {
            throw new SessionException(20);
        }
        try {
            try {
                byte[] encrypted;
                this.lock();
                this.listener.OnCommandTransmitionStarted();
                byte[] sign = this.getSignature(data);
                try {
                    encrypted = this.symmetricCipher.encrypt(data);
                }
                catch (SymmetricCipherException e) {
                    throw new SessionException(14, (Throwable)e);
                }
                int sent = 0;
                int toSend = encrypted.length;
                try {
                    byte[] payload;
                    int read;
                    ByteArrayInputStream is = new ByteArrayInputStream(encrypted);
                    short id = 0;
                    while ((read = ((InputStream)is).read(payload = new byte[((InputStream)is).available() >= 1024 ? 1024 : ((InputStream)is).available()], 0, payload.length)) != -1) {
                        byte[] packet = CommandFactory.CreateEncryptedDataPacket(payload, ((InputStream)is).available() == 0, id, (byte)0);
                        id = (short)(id + 1);
                        try {
                            try {
                                this.transmit(packet);
                                sent += read;
                                this.listener.OnCommandFrameTransmitted(read);
                            }
                            catch (TransportLayerException e) {
                                throw new SessionException(8, (Throwable)e);
                            }
                        }
                        finally {
                            this.communicationTimestamp.set(System.currentTimeMillis());
                        }
                        if (((InputStream)is).available() > 0) continue;
                    }
                    this.logger.debug("Sent: " + sent);
                    byte[] packet = CommandFactory.CreateDataFinPacket(sign, id, (byte)0);
                    this.transmit(packet);
                    this.listener.OnCommandTransmitted(sent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SessionException(15, (Throwable)e);
                }
                catch (TransportLayerException e) {
                    throw new SessionException(8, (Throwable)e);
                }
            }
            catch (SessionException e) {
                this.connected = false;
                throw e;
            }
            catch (Exception ex) {
                this.connected = false;
                throw new SessionException(99);
            }
        }
        finally {
            if (!this.connected) {
                this.listener.OnCommandTransmitionError();
                this.listener.OnDisconnected();
            }
            this.unlock();
        }
    }

    public byte[] read() throws SessionException {
        if (!this.transportLayerConnected || !this.connected) {
            this.connected = false;
            this.transportLayerConnected = false;
            throw new SessionException(20);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this._read(baos);
        return baos.toByteArray();
    }

    public void read(OutputStream output) throws SessionException {
        if (!this.transportLayerConnected || !this.connected) {
            this.connected = false;
            this.transportLayerConnected = false;
            throw new SessionException(20);
        }
        this._read(output);
    }

    private void _read(OutputStream output) throws SessionException {
        int read = 0;
        ByteArrayOutputStream receivedBytes = new ByteArrayOutputStream();
        try {
            try {
                byte[] decryptedSignature;
                byte[] decrypted;
                boolean isLast;
                this.lock();
                this.listener.OnCommandReceiveStarted();
                do {
                    try {
                        Command command = this.receive();
                        if (command.getCommand() == Command.CommandType.ForceCloseConnection) {
                            throw new SessionException(16);
                        }
                        if (command.getCommand() != Command.CommandType.EncryptedData) {
                            throw new SessionException(13);
                        }
                        isLast = command.isLast();
                        read += command.getData().length;
                        receivedBytes.write(command.getData(), 0, command.getData().length);
                    }
                    catch (TransportLayerException e) {
                        this.logger.error("TransportLayerException: " + e);
                        throw new SessionException(8, (Throwable)e);
                    }
                    catch (CommandException e) {
                        this.logger.error("CommandException: " + e);
                        throw new SessionException(7, (Throwable)e);
                    }
                } while (!isLast);
                this.logger.debug("Read: " + read);
                byte[] receivedSignature = new byte[]{};
                if (this.hmac != SupportedAlgorithms.HMAC.No) {
                    receivedSignature = this.receiveSignature();
                }
                try {
                    decrypted = this.symmetricCipher.decrypt(receivedBytes.toByteArray());
                    output.write(decrypted, 0, decrypted.length);
                }
                catch (SymmetricCipherException e) {
                    throw new SessionException(17, (Throwable)e);
                }
                catch (IOException e) {
                    throw new SessionException(15, (Throwable)e);
                }
                if (this.hmac != SupportedAlgorithms.HMAC.No && !Arrays.equals(decryptedSignature = this.getSignature(decrypted), receivedSignature)) {
                    throw new SessionException(18);
                }
                this.listener.OnCommandReceived(decrypted.length);
            }
            catch (SessionException e) {
                this.connected = false;
                throw e;
            }
        }
        finally {
            if (!this.connected) {
                this.listener.onCommandReceivingError();
                this.listener.OnDisconnected();
            }
            this.unlock();
        }
    }

    private byte[] receiveSignature() throws SessionException {
        try {
            try {
                Command command = this.receive();
                if (command.getCommand() != Command.CommandType.DataSignature) {
                    throw new SessionException(13);
                }
                Object parameter = CommandParser.ParseCommandParameters(command);
                if (!(parameter instanceof byte[])) {
                    throw new SessionException(7);
                }
                return (byte[])CommandParser.ParseCommandParameters(command);
            }
            catch (TransportLayerException e) {
                throw new SessionException(8, (Throwable)e);
            }
            catch (CommandException e) {
                throw new SessionException(7, (Throwable)e);
            }
        }
        catch (SessionException e) {
            this.connected = false;
            throw e;
        }
        catch (Exception e) {
            this.connected = false;
            throw new SessionException(99, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.lock();
            if (!this.transportLayerConnected || !this.connected) {
                this.connected = false;
                this.transportLayerConnected = false;
                this.transportLayer.deinit();
                this.listener.OnDisconnected();
                return;
            }
            byte[] packet = CommandFactory.CreateCloseSocketCommand();
            try {
                try {
                    if (!this.closeSilently) {
                        this.logger.info("Closing in normal mode");
                        this.transmit(packet);
                        byte[] received = this.transportLayer.receive();
                        CommandParser.ParseCommand(received);
                    } else {
                        this.logger.info("Closing silently");
                    }
                    this.transportLayer.deinit();
                }
                catch (TransportLayerException transportLayerException) {
                    this.transportLayer.close();
                    this.listener.OnDisconnected();
                }
                catch (CommandException commandException) {
                    this.transportLayer.close();
                    this.listener.OnDisconnected();
                }
            }
            finally {
                this.transportLayer.close();
                this.listener.OnDisconnected();
            }
        }
        finally {
            this.unlock();
            this.stopScheduler();
        }
    }

    public long requestKeepAlive() throws SessionException {
        try {
            this.lock();
            byte[] packet = CommandFactory.CreateKeepAliveCommand();
            long l = this.transmitSimpleCommand(packet, new ByteArrayOutputStream());
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private void requestInitialize() throws SessionException {
        try {
            try {
                this.lock();
                byte[] packet = CommandFactory.CreateInitializeCommand();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.transmitSimpleCommand(packet, byteArrayOutputStream);
                Command command = CommandParser.ParseCommand(byteArrayOutputStream.toByteArray());
                if (command.getCommand() != Command.CommandType.Initialize) {
                    throw new SessionException(13);
                }
                if (command.getData() == null) {
                    throw new SessionException(7);
                }
                this.chduSerialNumber = (String)CommandParser.ParseCommandParameters(command);
            }
            catch (Exception e) {
                throw new SessionException(1, (Throwable)e);
            }
        }
        finally {
            this.unlock();
        }
    }

    private long transmitSimpleCommand(byte[] command, ByteArrayOutputStream outputStream) throws SessionException {
        if (!this.transportLayerConnected || !this.connected) {
            this.connected = false;
            this.transportLayerConnected = false;
            return -1L;
        }
        long st = System.currentTimeMillis();
        try {
            this.transmit(command);
            byte[] data = this.transportLayer.receive();
            outputStream.write(data);
            return System.currentTimeMillis() - st;
        }
        catch (Exception e) {
            this.connected = false;
            this.transportLayerConnected = false;
            this.listener.OnDisconnected();
            throw new SessionException(19, (Throwable)e);
        }
    }

    private void lock() {
        try {
            this.communicationLock.lock();
            this.enableKeepAlive.set(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unlock() {
        try {
            this.communicationLock.unlock();
            this.enableKeepAlive.set(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transmit(byte[] packet) throws TransportLayerException {
        this.transportLayer.transmit(packet);
        this.communicationTimestamp.set(System.currentTimeMillis());
    }

    private Command receive() throws TransportLayerException, CommandException, SessionException {
        byte[] data = this.transportLayer.receive();
        Command command = CommandParser.ParseCommand(data);
        this.communicationTimestamp.set(System.currentTimeMillis());
        return command;
    }

    private void startScheduler() {
        if (!this.keepAliveEnabled) {
            return;
        }
        if (this.ses != null) {
            this.ses.shutdown();
        }
        this.ses = Executors.newScheduledThreadPool(1);
        this.logger.info("Keepalive sheduler starting");
        this.enableKeepAlive.set(true);
        this.communicationTimestamp.set(System.currentTimeMillis());
        this.ses.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SessionLayer.this.connected || !SessionLayer.this.transportLayerConnected) {
                        SessionLayer.this.ses.shutdown();
                    } else {
                        SessionLayer.this.keepAlive();
                    }
                }
                catch (Exception e) {
                    SessionLayer.this.close();
                    SessionLayer.this.connected = false;
                    SessionLayer.this.enableKeepAlive.set(false);
                    SessionLayer.this.logger.error("Keepalive sheduler exception: " + e);
                    SessionLayer.this.ses.shutdown();
                    SessionLayer.this.listener.OnDisconnected();
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    private void stopScheduler() {
        this.enableKeepAlive.set(false);
        if (!this.keepAliveEnabled) {
            return;
        }
        this.logger.debug("Keepalive sheduler shutdown");
        if (this.ses != null) {
            this.ses.shutdown();
            this.ses = null;
        }
    }

    private void keepAlive() throws SessionException {
        if (!this.enableKeepAlive.get()) {
            return;
        }
        this.lock();
        try {
            if (System.currentTimeMillis() < this.communicationTimestamp.get() + 3000L) {
                this.logger.info("Keepalive not needed");
                return;
            }
            this.logger.info("Sending keepalive");
            try {
                byte[] packet = CommandFactory.CreateKeepAliveCommand();
                long tsStart = System.currentTimeMillis();
                this.transmit(packet);
                Command c = this.receive();
                long tsEnd = System.currentTimeMillis();
                if (c.getCommand() != Command.CommandType.KeepAlive) {
                    throw new SessionException(19);
                }
                this.updateRtt(tsEnd - tsStart);
            }
            catch (Exception e) {
                this.logger.error("Keepalive scheduler exception: " + e);
                throw new SessionException(19);
            }
        }
        finally {
            this.unlock();
        }
    }

    private void updateRtt(long rtt) {
        this.rttList.add(rtt);
        if (this.rttList.size() > 4) {
            this.rttList.remove(0);
        }
        if (!this.rttList.isEmpty()) {
            long sum = 0L;
            for (long v : this.rttList) {
                sum += v;
            }
            this.rttListener.OnChange(sum /= (long)this.rttList.size());
        }
    }

    private byte[] getSignature(byte[] data) {
        try {
            this.mac.init(this.signingKey);
            return this.mac.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private byte[] createRandom() {
        int randomKeySize;
        SecureRandom random = new SecureRandom();
        switch (this.encryptionCipher) {
            case Aes128Cbc: {
                randomKeySize = 16;
                break;
            }
            default: {
                randomKeySize = 0;
            }
        }
        int randomHmacKeySize = this.hmac.getKeySize();
        byte[] bytes = new byte[randomKeySize + randomHmacKeySize];
        ((Random)random).nextBytes(bytes);
        return bytes;
    }

    private byte[] createSecuredChannelSpecCommand(byte[] randomBytes, byte[] hash) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.encryptionCipher.getId() & 0xFF);
        bos.write(this.encryptionCipher.getId() >> 8 & 0xFF);
        bos.write(this.hmac.getId() & 0xFF);
        bos.write(this.hmac.getId() >> 8 & 0xFF);
        bos.write(hash, 0, hash.length);
        bos.write(randomBytes, 0, randomBytes.length);
        return bos.toByteArray();
    }

    /* synthetic */ SessionLayer(String string, String string2, TransportLayer transportLayer, boolean bl, KeyLoader keyLoader, SessionLayerListener sessionLayerListener, OnRttStatusChangedListener onRttStatusChangedListener, SessionLayer sessionLayer) {
        this(string, string2, transportLayer, bl, keyLoader, sessionLayerListener, onRttStatusChangedListener);
    }

    public static class Builder {
        private String ppekkName;
        private String expectedChduName;
        private TransportLayer transportLayer;
        private boolean keepAliveEnabled;
        private SessionLayerListener connectionStatusChangedListener;
        private KeyLoader keyLoader;
        private OnRttStatusChangedListener rttListener;

        public Builder(String ppekkName, String expectedChduName, TransportLayer transportLayer, KeyLoader keyLoader) {
            this.ppekkName = ppekkName;
            this.expectedChduName = expectedChduName;
            this.keyLoader = keyLoader;
            this.transportLayer = transportLayer;
            this.keepAliveEnabled = true;
            this.connectionStatusChangedListener = new SessionLayerListener(){

                @Override
                public void OnDisconnected() {
                }

                @Override
                public void OnConnected() {
                }

                @Override
                public void OnCommandTransmitionStarted() {
                }

                @Override
                public void OnCommandFrameTransmitted(int sent) {
                }

                @Override
                public void OnCommandTransmitted(long totalSent) {
                }

                @Override
                public void OnCommandReceiveStarted() {
                }

                @Override
                public void OnCommandFrameReceived(int received) {
                }

                @Override
                public void OnCommandReceived(long totalReceived) {
                }

                @Override
                public void OnCommandTransmitionError() {
                }

                @Override
                public void onCommandReceivingError() {
                }
            };
            this.rttListener = new OnRttStatusChangedListener(){

                @Override
                public void OnChange(long rtt) {
                }
            };
        }

        public Builder setKeepAliveEnabled(boolean enabled) {
            this.keepAliveEnabled = enabled;
            return this;
        }

        public Builder setRttListener(OnRttStatusChangedListener rttListener) {
            this.rttListener = rttListener;
            return this;
        }

        public Builder setConnectionStatusListener(SessionLayerListener connectionStatusChangedListener) {
            this.connectionStatusChangedListener = connectionStatusChangedListener;
            return this;
        }

        public SessionLayer build() {
            return new SessionLayer(this.ppekkName, this.expectedChduName, this.transportLayer, this.keepAliveEnabled, this.keyLoader, this.connectionStatusChangedListener, this.rttListener, null);
        }
    }

    public static interface OnRttStatusChangedListener {
        public void OnChange(long var1);
    }

    public static interface SessionLayerListener {
        public void OnConnected();

        public void OnDisconnected();

        public void OnCommandTransmitionStarted();

        public void OnCommandFrameTransmitted(int var1);

        public void OnCommandTransmitted(long var1);

        public void OnCommandTransmitionError();

        public void OnCommandReceiveStarted();

        public void OnCommandFrameReceived(int var1);

        public void OnCommandReceived(long var1);

        public void onCommandReceivingError();
    }
}

