/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.layers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.exception.PhysicalDriverException;
import sk.singularisdev.cryptoprotocol.exception.TransportLayerException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.utils.Crc32;

public class TransportLayer {
    public static int BW_PROTO_MAX_ATTEMPTS = 3;
    private static final int BW_PROTO_EOT = 4;
    private static final int BW_PROTO_ACK = 6;
    private static final int BW_PROTO_CRC = 9;
    private static final int BW_PROTO_HEADER = 10;
    private static final int BW_PROTO_TIMEOUT = 11;
    private final Logger logger = LoggerManager.getLogger(TransportLayer.class.getName());
    private PhysicalDriver physicalDriver;
    private Listener listener;

    public TransportLayer(PhysicalDriver physicalDriver, Listener listener) {
        this.physicalDriver = physicalDriver;
        this.listener = listener;
    }

    void init() {
        try {
            this.physicalDriver.init();
        }
        catch (PhysicalDriverException e) {
            this.logger.error("Physical driver initialization error");
        }
    }

    void deinit() {
        this.physicalDriver.deinit();
    }

    int getTimeout() {
        return this.physicalDriver.getTimeout();
    }

    void connect() throws TransportLayerException {
        try {
            this.physicalDriver.connect();
            this.logger.info("Connected");
        }
        catch (PhysicalDriverException e) {
            this.logger.error("Connecting error");
            throw new TransportLayerException(1, (Throwable)e);
        }
    }

    void close() {
        this.physicalDriver.close();
    }

    synchronized void transmit(byte[] packet) throws TransportLayerException {
        boolean error = false;
        try {
            try {
                byte[] frame = TransportLayer.CreateFrame(packet);
                this.SendFrame(frame);
            }
            catch (TransportLayerException e) {
                error = true;
                this.logger.error("Error transmitting frame");
                throw new TransportLayerException(2, (Throwable)e);
            }
        }
        finally {
            this.listener.onPacketTransmitted(packet.length, error);
        }
    }

    synchronized byte[] receive() throws TransportLayerException {
        byte[] byArray;
        boolean error = false;
        byte[] received = null;
        try {
            byArray = received = this.Receive();
            this.listener.onPacketReceived(received != null ? received.length : 0, error);
        }
        catch (TransportLayerException e) {
            try {
                this.logger.error("Error receiving frame");
                throw new TransportLayerException(2, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.listener.onPacketReceived(received != null ? received.length : 0, error);
                throw throwable;
            }
        }
        return byArray;
    }

    private void SendFrame(byte[] frame) throws TransportLayerException {
        int repeat = BW_PROTO_MAX_ATTEMPTS;
        while (repeat > 0) {
            byte[] status;
            try {
                this.logger.debug("SendFrame transmitting frame");
                this.physicalDriver.send(frame);
                this.logger.debug("SendFrame Frame transmitted");
            }
            catch (PhysicalDriverException e) {
                throw new TransportLayerException(2, (Throwable)e);
            }
            try {
                this.logger.debug("Receiving status");
                status = this.physicalDriver.recv();
                this.logger.debug("Status received");
            }
            catch (PhysicalDriverException e) {
                throw new TransportLayerException(4);
            }
            if (status.length == 0) {
                throw new TransportLayerException(4);
            }
            if (status.length == 1) {
                switch (status[0]) {
                    case 6: {
                        this.logger.debug("Frame acknowledged [0x06]");
                        return;
                    }
                    case 4: {
                        this.logger.debug("EOT Received [0x04]");
                        throw new TransportLayerException(5);
                    }
                    case 9: {
                        this.logger.debug("CRC error [0x09]");
                        break;
                    }
                    case 11: {
                        this.logger.debug("Timeoutt error [0x0B]");
                        break;
                    }
                    case 10: {
                        this.logger.debug("Wrong header [0x0A]");
                        break;
                    }
                    default: {
                        throw new TransportLayerException(6);
                    }
                }
            }
            --repeat;
        }
        throw new TransportLayerException(2);
    }

    private byte[] Receive() throws TransportLayerException {
        int repeat = BW_PROTO_MAX_ATTEMPTS;
        byte[] statusByte = new byte[1];
        while (repeat > 0) {
            byte[] data;
            try {
                this.logger.debug("Receive receiving frame");
                data = this.physicalDriver.recv();
                this.logger.debug("Receive frame received");
            }
            catch (PhysicalDriverException e) {
                throw new TransportLayerException(3, (Throwable)e);
            }
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            int status = TransportLayer.ValidateFrame(data, payload);
            if (status >= 0) {
                this.logger.debug("Frame OK");
                statusByte[0] = 6;
            } else if (status == -1) {
                this.logger.debug("Wrong header");
                statusByte[0] = 10;
                this.listener.onPacketHeaderError();
            } else if (status == -2) {
                this.logger.debug("Wrong header");
                statusByte[0] = 10;
                this.listener.onPacketHeaderError();
            } else if (status == -3) {
                this.logger.debug("Wrong CRC");
                statusByte[0] = 9;
                this.listener.onPacketCrcError();
            } else {
                this.logger.debug("Unknown error");
                statusByte[0] = 10;
            }
            try {
                this.logger.debug("Receive frame transmitting status");
                this.physicalDriver.send(statusByte);
                this.logger.debug("Receive frame status transmitted");
            }
            catch (PhysicalDriverException e) {
                throw new TransportLayerException(8, (Throwable)e);
            }
            if (status > 0) {
                return payload.toByteArray();
            }
            --repeat;
        }
        throw new TransportLayerException(3);
    }

    private static byte[] CreateFrame(byte[] data) throws TransportLayerException {
        if (data.length == 0) {
            throw new TransportLayerException(7);
        }
        int crc = Crc32.Compute(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(66);
        bos.write(87);
        bos.write(data.length & 0xFF);
        bos.write(data.length >> 8 & 0xFF);
        bos.write(data, 0, data.length);
        bos.write(crc & 0xFF);
        bos.write(crc >> 8 & 0xFF);
        return bos.toByteArray();
    }

    private static int ValidateFrame(byte[] data, ByteArrayOutputStream payload) throws TransportLayerException {
        int crc;
        int avail;
        if (data.length == 0) {
            throw new TransportLayerException(7);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        int b = bis.read();
        int w = bis.read();
        if (b != 66 || w != 87) {
            return -1;
        }
        int len = bis.read();
        if ((len |= bis.read() << 8) + 2 != (avail = bis.available())) {
            return -2;
        }
        byte[] _payload = new byte[len];
        int read = bis.read(_payload, 0, len);
        if (read != len) {
            return -2;
        }
        int expectedCrc = bis.read();
        if ((expectedCrc |= bis.read() << 8) != (crc = Crc32.Compute(_payload))) {
            return -3;
        }
        payload.write(_payload, 0, _payload.length);
        return _payload.length;
    }

    public static interface Listener {
        public void onPacketTransmitted(int var1, boolean var2);

        public void onPacketReceived(int var1, boolean var2);

        public void onPacketCrcError();

        public void onPacketHeaderError();
    }
}

