/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class Cobs {
    public static byte[] encode(byte[] data) {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream tmpOutput = new ByteArrayOutputStream();
        output.write(0);
        int code = 1;
        while (input.available() > 0) {
            int c;
            if (code != 255 && (c = input.read()) != 0) {
                tmpOutput.write(c);
                ++code;
                continue;
            }
            output.write(code);
            output.write(tmpOutput.toByteArray(), 0, tmpOutput.size());
            tmpOutput.reset();
            code = 1;
        }
        output.write(code);
        output.write(tmpOutput.toByteArray(), 0, tmpOutput.size());
        output.write(0);
        return output.toByteArray();
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        int copy = 0;
        int code = 255;
        boolean waitForSof = true;
        int i = 0;
        while (i < data.length) {
            if (copy != 0) {
                bos.write(data[i]);
                ++i;
            } else if (waitForSof && data[i] == 0) {
                ++i;
            } else {
                waitForSof = false;
                if (code != 255) {
                    bos.write(0);
                }
                copy = code = data[i] & 0xFF;
                ++i;
                if (code == 0) break;
            }
            copy = copy - 1 & 0xFF;
        }
        return bos.toByteArray();
    }
}

