/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.cryptoprotocol.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import sk.singularisdev.cryptoprotocol.utils.PemParserException;

public class PemParser {
    public static RSAPublicKey parsePublicKey(String pem) throws IOException, PemParserException {
        BufferedReader fRd = new BufferedReader(new StringReader(pem));
        PEMParser pemParser = new PEMParser((Reader)fRd);
        SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        try {
            PublicKey k = converter.getPublicKey(pub);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)k;
            return rSAPublicKey;
        }
        catch (PEMException e) {
            e.printStackTrace();
            throw new PemParserException("Error parsing PEM file");
        }
        finally {
            pemParser.close();
        }
    }

    public static RSAPrivateKey parsePrivateKey(String pem, String password) throws IOException, PemParserException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
        BufferedReader fRd = new BufferedReader(new StringReader(pem));
        PEMParser pemParser = new PEMParser((Reader)fRd);
        Object o = pemParser.readObject();
        if (!(o instanceof PEMKeyPair) && !(o instanceof PEMEncryptedKeyPair)) {
            throw new PemParserException("Didn't find OpenSSL key");
        }
        KeyPair kp = o instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)o);
        return (RSAPrivateKey)kp.getPrivate();
    }
}

