/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import sk.singularisdev.chdu.parameter.Transaction;
import sk.singularisdev.common.image.Image;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKAuthentication;
import sk.singularisdev.ekasask.PPEKKChduListener;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKIdentity;
import sk.singularisdev.ekasask.PPEKKInfo;
import sk.singularisdev.ekasask.PPEKKListener;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.chdu.CHDU;
import sk.singularisdev.ekasask.chdu.CHDUListener;
import sk.singularisdev.ekasask.chdu.CHDUState;
import sk.singularisdev.ekasask.chdu.ChduCertificateValidator;
import sk.singularisdev.ekasask.chdu.ChduTransaction;
import sk.singularisdev.ekasask.chdu.ConnectionInfo;
import sk.singularisdev.ekasask.chdu.DriveInfo;
import sk.singularisdev.ekasask.chdu.SfsDataInfo;
import sk.singularisdev.ekasask.chdu.SfsDataRequest;
import sk.singularisdev.ekasask.chdu.SfsDataResponse;
import sk.singularisdev.ekasask.chdu.StorageInfo;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.CashIn;
import sk.singularisdev.ekasask.command.CashOut;
import sk.singularisdev.ekasask.command.CorrectHelper;
import sk.singularisdev.ekasask.command.Correction;
import sk.singularisdev.ekasask.command.Display;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.command.ElectronicReceiptInterface;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.InvalidReceipt;
import sk.singularisdev.ekasask.command.Location;
import sk.singularisdev.ekasask.command.PaymentOfClaim;
import sk.singularisdev.ekasask.command.PrintInterface;
import sk.singularisdev.ekasask.command.Receipt;
import sk.singularisdev.ekasask.command.ReceiptNumberInterface;
import sk.singularisdev.ekasask.command.internal.ChduConnect;
import sk.singularisdev.ekasask.command.internal.ChduDisconnect;
import sk.singularisdev.ekasask.command.internal.GetCertificateInfo;
import sk.singularisdev.ekasask.command.internal.GetChduConnectionInfo;
import sk.singularisdev.ekasask.command.internal.GetChduDataPacket;
import sk.singularisdev.ekasask.command.internal.GetChduIndex;
import sk.singularisdev.ekasask.command.internal.GetChduInfo;
import sk.singularisdev.ekasask.command.internal.GetChduSize;
import sk.singularisdev.ekasask.command.internal.GetIdentityInfo;
import sk.singularisdev.ekasask.command.internal.GetPrinterState;
import sk.singularisdev.ekasask.command.internal.GetUnsendedTransaction;
import sk.singularisdev.ekasask.command.internal.LoadLogo;
import sk.singularisdev.ekasask.command.internal.PrintLastReceiptCopy;
import sk.singularisdev.ekasask.command.internal.PrintTransactionCopy;
import sk.singularisdev.ekasask.command.internal.SetPrinterEsc;
import sk.singularisdev.ekasask.command.internal.SynchronizeData;
import sk.singularisdev.ekasask.command.internal.UnsendedTransaction;
import sk.singularisdev.ekasask.command.internal.Upgrade;
import sk.singularisdev.ekasask.command.internal.response.ChduConnectResponse;
import sk.singularisdev.ekasask.command.internal.response.ChduConnectionInfoResponse;
import sk.singularisdev.ekasask.command.internal.response.ChduDisconnectResponse;
import sk.singularisdev.ekasask.command.internal.response.ChduInfoResponse;
import sk.singularisdev.ekasask.command.internal.response.ChduSizeResponse;
import sk.singularisdev.ekasask.command.internal.response.GetCertificateInfoResponse;
import sk.singularisdev.ekasask.command.internal.response.GetChduDataPacketResponse;
import sk.singularisdev.ekasask.command.internal.response.GetChduIndexResponse;
import sk.singularisdev.ekasask.command.internal.response.GetIdentityInfoResponse;
import sk.singularisdev.ekasask.command.internal.response.GetPrinterStateResponse;
import sk.singularisdev.ekasask.command.internal.response.SetPrinterEscResponse;
import sk.singularisdev.ekasask.command.internal.response.UnsendedTransactionResponse;
import sk.singularisdev.ekasask.command.setup.ChangeConnectionStringAtChdu;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationData;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationPassword;
import sk.singularisdev.ekasask.command.setup.SetupItemIdentityData;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterBaudrate;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterType;
import sk.singularisdev.ekasask.db.Database;
import sk.singularisdev.ekasask.db.DbTransactionStatusFetchListenerInterface;
import sk.singularisdev.ekasask.db.TransactionInfo;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.enumeration.AUTHENTICATION_ALERT_TYPE;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.enumeration.DISPLAY_TYPE;
import sk.singularisdev.ekasask.enumeration.EVENT_TYPE;
import sk.singularisdev.ekasask.enumeration.PPEKK_STATE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.RESEND_STATUS;
import sk.singularisdev.ekasask.enumeration.SYNCHRO_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrintDataHolder;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.UnsendedTransactionPrint;
import sk.singularisdev.ekasask.printer.driver.BmpPrinter;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;
import sk.singularisdev.ekasask.sfs.EKasaReturn;
import sk.singularisdev.ekasask.sfs.EKasaServer;
import sk.singularisdev.ekasask.sfs.UnsendedTransactionIndex;
import sk.singularisdev.ekasask.utils.CertificateValidator;
import sk.singularisdev.ekasask.utils.Validate;
import sk.singularisdev.ekasask.xmlparser.IdentityData;
import sk.singularisdev.platform.Platform;

public final class PPEKK {
    public static Logger logger = LoggerManager.getLogger(PPEKK.class.getName());
    private static Map<Long, PPEKK> PPEKK = new HashMap<Long, PPEKK>();
    private UUID uuid;
    private long id;
    private List<PPEKKListener> listeners = new ArrayList<PPEKKListener>();
    private List<PPEKKChduListener> chduListeners = new ArrayList<PPEKKChduListener>();
    private Database db;
    private CHDU chdu;
    private AbstractPrinter printer = null;
    private EKasaServer sfs;
    private PPEKKSetup activeConfiguration;
    private PPEKKSetup chduConfiguration;
    private String swId = "";
    private boolean license = false;
    private PPEKK_STATE ppekkState = PPEKK_STATE.CHDU_NOT_READY;
    private boolean synchronizeUnsendedTransaction = false;
    private ResendTransactionTask resendTask = new ResendTransactionTask();
    private ChduCertificateValidator chduCertificateValidator = null;
    private CHDUState chduState = new CHDUState();

    public static synchronized PPEKK install(long id, String initString) throws EKasaException {
        return sk.singularisdev.ekasask.PPEKK.install(id, initString, null);
    }

    public static synchronized PPEKK install(long id, String initString, PPEKKListener ppekkListener) throws EKasaException {
        return sk.singularisdev.ekasask.PPEKK.install(id, initString, ppekkListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PPEKK install(long id, String initString, PPEKKListener ppekkListener, PPEKKChduListener chduListener) throws EKasaException {
        if (initString.equals("AA1")) {
            Map<Long, PPEKK> map = PPEKK;
            synchronized (map) {
                PPEKK ppekk;
                if (PPEKK.containsKey(id)) {
                    ppekk = PPEKK.get(id);
                    if (ppekkListener != null) {
                        ppekk.addListener(ppekkListener);
                    }
                    if (chduListener != null) {
                        ppekk.addChduListener(chduListener);
                    }
                } else {
                    ppekk = new PPEKK(id);
                    PPEKK.put(id, ppekk);
                    if (ppekkListener != null) {
                        ppekk.addListener(ppekkListener);
                    }
                    if (chduListener != null) {
                        ppekk.addChduListener(chduListener);
                    }
                    ppekk.start();
                }
                return ppekk;
            }
        }
        throw new EKasaException(49L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninstallAll() {
        Map<Long, PPEKK> map = PPEKK;
        synchronized (map) {
            for (long id : PPEKK.keySet()) {
                sk.singularisdev.ekasask.PPEKK.uninstall(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninstall(long id) {
        Map<Long, PPEKK> map = PPEKK;
        synchronized (map) {
            PPEKK ppekk = PPEKK.remove(id);
            ppekk.stop();
            if (ppekk.chdu != null) {
                ppekk.chdu.disconnect();
            }
        }
    }

    public static synchronized PPEKK getPpekk(long id) throws EKasaException {
        if (PPEKK.containsKey(id)) {
            return PPEKK.get(id);
        }
        return null;
    }

    private PPEKK(long id) throws EKasaException {
        Locale currentLocale = new Locale("sk");
        Localization.setBundle(ResourceBundle.getBundle("sk.singularisdev.ekasask.localization.ekasask", currentLocale));
        this.uuid = UUID.randomUUID();
        this.id = id;
        this.db = new Database(Platform.GetDataDirectory(), id);
        Platform.CreateAndSetPrinterRendererInstance();
        final PPEKK ppekk = this;
        this.chdu = CHDU.getInstance(this, this.uuid, new CHDUListener(){

            @Override
            public void onChduTransactionIdChanged(Object source, Transaction.ID oldTransactionId, Transaction.ID newTransactionId) {
                String strTransactionId = newTransactionId.format();
                long transactionId = Long.parseLong(strTransactionId);
                PPEKK.this.chduState.setTransactionId(strTransactionId);
                if (transactionId % Configuration.getIndexSynchronizationCount() == 0L) {
                    PPEKK.this.synchronizeUnsendedTransaction = true;
                }
            }

            @Override
            public void onChduConnect(Object source) {
                try {
                    ppekk.initPrinter(PPEKK.this.printer, ppekk.getCHDU(PPEKK.this.uuid));
                    String sn = ppekk.getCHDU(PPEKK.this.uuid).getSN();
                    ppekk.license = false;
                    if (CHDU.isLicensed(sn)) {
                        try {
                            Class<?> clazz = Class.forName("sk.singularisdev.ekasask.client.License");
                            Method method = clazz.getMethod("register", String.class);
                            if (((Boolean)method.invoke(null, sn)).booleanValue()) {
                                ppekk.license = true;
                            }
                        }
                        catch (Exception e) {
                            logger.fatal("Check license for CHDU", e);
                        }
                    } else {
                        ppekk.license = true;
                    }
                    ppekk.generSwId();
                    PPEKK.this.chduCertificateValidator = ChduCertificateValidator.getInstance(PPEKK.this.uuid, ppekk);
                    PPEKK.this.chduState.setConnected(true);
                    Date when = new Date();
                    for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                        try {
                            listener.onChduConnect(PPEKK.this, when);
                        }
                        catch (Exception e) {
                            logger.fatal("ERROR OnChduConnect listener", e);
                        }
                    }
                    if (!PPEKK.this.db.isSyncChdu(PPEKK.this.chdu.getSN(), PPEKK.this.chdu.getLastTransactionId())) {
                        long l = System.currentTimeMillis();
                        PPEKK.this.synchronizeTransactionChdu2Ppekk();
                        System.out.println("sync [" + (System.currentTimeMillis() - l) + "]");
                    }
                }
                catch (EKasaException e) {
                    logger.error("Error getting CHDU info in onChduConnect listener event: " + e.getMessage());
                    PPEKK.this.ppekkState = PPEKK_STATE.CHDU_NOT_READY;
                    ppekk.swId = null;
                    ppekk.license = false;
                    PPEKK.this.chduState.setConnected(false);
                }
            }

            @Override
            public void onChduDisconnect(Object source) {
                ppekk.swId = null;
                ppekk.license = false;
                PPEKK.this.ppekkState = PPEKK_STATE.CHDU_NOT_READY;
                PPEKK.this.chduConfiguration = PPEKKSetup.getInstance(null, null, null);
                PPEKK.this.chduState.setConnected(false);
                Date when = new Date();
                for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                    try {
                        listener.onChduDisconnect(PPEKK.this, when);
                    }
                    catch (Exception e) {
                        logger.fatal("ERROR OnChduDisconnect listener", e);
                    }
                }
            }

            @Override
            public void onChduPacketTransmitStart() {
                long time = System.currentTimeMillis();
                PPEKK.this.chduState.setTransmitted(true);
                Date when = new Date(time);
                for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                    try {
                        listener.onChduPacket(PPEKK.this, PPEKKChduListener.COMMUNICATION_TYPE.TRANSMIT_START, when);
                    }
                    catch (Exception e) {
                        logger.fatal("ERROR OnChduPacket listener", e);
                    }
                }
            }

            @Override
            public void onChduPacketTransmitEnd(boolean error) {
                long time = System.currentTimeMillis();
                PPEKK.this.chduState.setTransmitted(false);
                Date when = new Date(time);
                for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                    try {
                        listener.onChduPacket(PPEKK.this, PPEKKChduListener.COMMUNICATION_TYPE.TRANSMIT_END, when);
                    }
                    catch (Exception e) {
                        logger.fatal("ERROR onChduPacket listener", e);
                    }
                }
            }

            @Override
            public void onChduPacketReceiveStart() {
                long time = System.currentTimeMillis();
                PPEKK.this.chduState.setReceived(true);
                Date when = new Date(time);
                for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                    try {
                        listener.onChduPacket(PPEKK.this, PPEKKChduListener.COMMUNICATION_TYPE.RECEIVE_START, when);
                    }
                    catch (Exception e) {
                        logger.fatal("ERROR OnChduPacket listener", e);
                    }
                }
            }

            @Override
            public void onChduPacketReceiveEnd(boolean error) {
                long time = System.currentTimeMillis();
                PPEKK.this.chduState.setReceived(false);
                Date when = new Date(time);
                for (PPEKKChduListener listener : PPEKK.this.chduListeners) {
                    try {
                        listener.onChduPacket(PPEKK.this, PPEKKChduListener.COMMUNICATION_TYPE.RECEIVE_END, when);
                    }
                    catch (Exception e) {
                        logger.fatal("ERROR OnChduPacket listener", e);
                    }
                }
            }

            @Override
            public void onChduDiscovered(String connectionString) {
            }
        });
        this.sfs = EKasaServer.getInstance(this, this.uuid);
    }

    public long getId() {
        return this.id;
    }

    public AbstractPrinter getPrinter() {
        return this.printer;
    }

    public DISPLAY_TYPE getDisplay(DISPLAY_NUMBER display) {
        if (this.activeConfiguration == null || this.activeConfiguration.getConfiguration() == null) {
            return null;
        }
        switch (display) {
            case INTERNAL: {
                return this.activeConfiguration.getConfiguration().getDisplay1() == null ? null : this.activeConfiguration.getConfiguration().getDisplay1().getDisplayType();
            }
            case EXTERNAL: {
                return this.activeConfiguration.getConfiguration().getDisplay1() == null ? null : this.activeConfiguration.getConfiguration().getDisplay1().getDisplayType();
            }
        }
        return null;
    }

    public PPEKKSetup getConfiguration(UUID uuid) throws EKasaException {
        if (this.uuid.equals(uuid)) {
            return this.activeConfiguration;
        }
        throw new EKasaException(6L);
    }

    public PPEKKSetup getChduConfiguration(UUID uuid) throws EKasaException {
        if (this.uuid.equals(uuid)) {
            return this.chduConfiguration;
        }
        throw new EKasaException(6L);
    }

    public void addListener(PPEKKListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addChduListener(PPEKKChduListener listener) {
        this.chduListeners.add(listener);
    }

    public boolean removeListener(PPEKKListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeChduListener(PPEKKChduListener listener) {
        return this.chduListeners.add(listener);
    }

    public void removeAllListener() {
        this.listeners.clear();
    }

    public void removeAllChduListener() {
        this.chduListeners.clear();
    }

    private void start() throws EKasaException {
        this.resendTask.start();
        this.initChdu(true);
    }

    private void stop() {
        try {
            this.resendTask.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initChdu(boolean initPrinter) throws EKasaException {
        PPEKKConfiguration configuration = this.db.getConfiguration();
        PPEKKAuthentication authentication = this.db.getAuthentication();
        PPEKKIdentity identity = this.db.getIdentity();
        this.activeConfiguration = PPEKKSetup.getInstance(configuration, authentication, identity);
        try {
            String printerType;
            if (!this.chdu.isConnected()) {
                this.chdu.connect();
            }
            try {
                if (this.swId == null || this.swId.isEmpty()) {
                    this.chdu.initChdu();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((printerType = this.activeConfiguration.getConfiguration().getPrinterType()) != null) {
                this.printer = AbstractPrinter.getInstance(printerType);
                if (initPrinter) {
                    this.initPrinter(this.printer, this.chdu);
                }
            }
            this.chduConfiguration = PPEKKSetup.getInstance(null, null, null);
            PPEKK_STATE ppekkState = PPEKK_STATE.READY;
            PPEKKConfiguration chduCfg = null;
            PPEKKAuthentication chduAuth = null;
            PPEKKIdentity chduIdent = null;
            try {
                chduAuth = this.chdu.loadAuth();
                if (this.activeConfiguration.getAuthentication().isEmpty()) {
                    ppekkState = PPEKK_STATE.NOT_INITIALIZED_AUTHENTICATION;
                } else if (!this.activeConfiguration.getAuthentication().equals(chduAuth)) {
                    ppekkState = PPEKK_STATE.CHDU_PPEKK_MISMATCH;
                }
            }
            catch (EKasaException e) {
                ppekkState = PPEKK_STATE.NOT_INITIALIZED_AUTHENTICATION;
            }
            try {
                chduIdent = this.chdu.loadIdent();
                if (this.activeConfiguration.getIdentity().isEmpty()) {
                    ppekkState = chduIdent.isEmpty() ? PPEKK_STATE.NOT_INITIALIZED_IDENTITY : PPEKK_STATE.CHDU_PPEKK_MISMATCH;
                } else if (!this.activeConfiguration.getIdentity().equals(chduIdent)) {
                    ppekkState = PPEKK_STATE.CHDU_PPEKK_MISMATCH;
                }
            }
            catch (EKasaException e) {
                ppekkState = PPEKK_STATE.NOT_INITIALIZED_IDENTITY;
            }
            try {
                chduCfg = this.chdu.loadCfg();
                if (chduCfg != null && this.activeConfiguration != null && this.activeConfiguration.getConfiguration() != null && this.activeConfiguration.getConfiguration().getChduConnectionString() != null) {
                    chduCfg.setChduConnectionString(this.activeConfiguration.getConfiguration().getChduConnectionString());
                }
                if (!this.activeConfiguration.getConfiguration().equals(chduCfg)) {
                    ppekkState = PPEKK_STATE.CHDU_PPEKK_MISMATCH;
                }
            }
            catch (EKasaException e) {
                ppekkState = this.chdu.isConnected() ? PPEKK_STATE.EMPTY_CHDU : PPEKK_STATE.CHDU_NOT_READY;
            }
            this.chduConfiguration = PPEKKSetup.getInstance(chduCfg, chduAuth, chduIdent);
            this.ppekkState = ppekkState;
            this.invokeEventChduLoadConfig(chduCfg, chduAuth, chduIdent);
        }
        catch (EKasaException e) {
            if (e.getErrorCode() == 7L) {
                this.ppekkState = PPEKK_STATE.CHDU_NOT_READY;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(AbstractCommand message) throws EKasaException {
        try {
            Object transactionId;
            if (!(message instanceof CashIn || message instanceof CashOut || message instanceof InternalDocument || message instanceof InvalidReceipt || message instanceof Receipt || message instanceof PaymentOfClaim || message instanceof Location || message instanceof Setup || message instanceof ChangeConnectionStringAtChdu || message instanceof UnsendedTransaction || message instanceof GetCertificateInfo || message instanceof GetChduIndex || message instanceof GetChduInfo || message instanceof GetChduConnectionInfo || message instanceof ChduDisconnect || message instanceof ChduConnect || message instanceof GetChduSize || message instanceof GetUnsendedTransaction || message instanceof SynchronizeData || message instanceof GetIdentityInfo || message instanceof Display || message instanceof GetPrinterState || message instanceof SetPrinterEsc || message instanceof Upgrade || message instanceof PrintLastReceiptCopy || message instanceof PrintTransactionCopy || message instanceof Correction || message instanceof LoadLogo || message instanceof GetChduDataPacket)) {
                throw new EKasaException(5L);
            }
            if (TimeUnit.MILLISECONDS.toHours(TimeZone.getDefault().getRawOffset()) != 1L) {
                throw new EKasaException(51L);
            }
            logger.debug("Command processing begin");
            if (message instanceof ChduDisconnect) {
                ChduDisconnect chduDisconnect = (ChduDisconnect)message;
                chduDisconnect.setResponse(ChduDisconnectResponse.getInstance());
                this.ppekkState = PPEKK_STATE.CHDU_NOT_READY;
                this.chdu.disconnect();
                if (!chduDisconnect.isAutoConnect()) return;
                this.chdu.connect();
                return;
            }
            if (message instanceof ChduConnect) {
                ChduConnect chduConnect = (ChduConnect)message;
                chduConnect.setResponse(ChduConnectResponse.getInstance());
                this.initChdu(true);
                return;
            }
            if (this.ppekkState == PPEKK_STATE.CHDU_NOT_READY) {
                this.initChdu(true);
            }
            message.validate(this.activeConfiguration.getConfiguration());
            if (message instanceof ChangeConnectionStringAtChdu) {
                logger.debug("Command processing 'ChangeConnectionStringAtChdu'");
                ChangeConnectionStringAtChdu changeConnectionStringAtChdu = (ChangeConnectionStringAtChdu)message;
                PPEKKConfiguration configuration = this.chdu.loadCfg();
                configuration.setChduConnectionString(changeConnectionStringAtChdu.getConnectionString());
                this.chdu.saveCfg(configuration);
                configuration = this.db.getConfiguration();
                configuration.setChduConnectionString(changeConnectionStringAtChdu.getConnectionString());
                this.db.setConfiguration(configuration);
                this.initChdu(true);
                return;
            }
            if (message instanceof Setup) {
                logger.debug("Command processing 'Setup'");
                Setup setup = (Setup)message;
                PPEKKConfiguration tmpConfiguration = null;
                try {
                    tmpConfiguration = this.db.loadConfiguration();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Validate.validateSetup(this.activeConfiguration, setup);
                PPEKKAuthentication authentication = null;
                PPEKKIdentity identity = null;
                PPEKKConfiguration configuration = null;
                boolean initPrinterFlag = true;
                int index = 0;
                while (true) {
                    if (index >= setup.itemCount()) {
                        this.initChdu(initPrinterFlag);
                        if (authentication != null) {
                            logger.debug("Command processing SETUP -> save authentication to CHDU");
                            this.chdu.saveAuth(authentication);
                            this.chduCertificateValidator = ChduCertificateValidator.getInstance(this.uuid, this);
                        }
                        if (identity != null) {
                            logger.debug("Command processing SETUP -> save identity to CHDU");
                            this.chdu.saveIdent(identity);
                        }
                        if (configuration == null) break;
                        logger.debug("Command processing SETUP -> save configuration to CHDU");
                        try {
                            this.chdu.saveCfg(configuration);
                        }
                        catch (Exception ignoreit) {
                            logger.error("Error saving configuration into CHDU");
                            this.initChdu(false);
                            if (this.ppekkState != PPEKK_STATE.CHDU_PPEKK_MISMATCH || tmpConfiguration == null || this.activeConfiguration == null || this.activeConfiguration.getConfiguration() == null) break;
                            logger.error("Trying to rollback");
                            PPEKKConfiguration chduCfg = this.chdu.loadCfg();
                            if (chduCfg != null && chduCfg.equals(tmpConfiguration) && !this.activeConfiguration.getConfiguration().equals(chduCfg)) {
                                logger.error("Processing rollback");
                                this.db.setConfiguration(tmpConfiguration);
                                this.initChdu(false);
                                throw new EKasaException(53L);
                            }
                            logger.error("Rollback skipped, fatal error");
                        }
                        break;
                    }
                    SetupItemInterface setupItem = setup.getItemAt(index);
                    this.db.setSetup(setupItem);
                    logger.debug("Command processing SETUP (item:" + setupItem.getClass().getName() + ")");
                    if (setupItem instanceof SetupItemAuthenticationData) {
                        authentication = this.db.getAuthentication();
                    } else if (setupItem instanceof SetupItemAuthenticationPassword) {
                        authentication = this.db.getAuthentication();
                    } else if (setupItem instanceof SetupItemIdentityData) {
                        identity = this.db.getIdentity();
                    } else {
                        if (setupItem instanceof SetupItemPrinterType || setupItem instanceof SetupItemPrinterBaudrate) {
                            initPrinterFlag = false;
                        }
                        configuration = this.db.getConfiguration();
                    }
                    ++index;
                }
                this.initChdu(true);
                return;
            }
            if (message instanceof GetChduDataPacket) {
                logger.debug("Command processing 'GetChduDataPacket'");
                GetChduDataPacket getChduDataPacket = (GetChduDataPacket)message;
                ChduTransaction transaction = this.chdu.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.getValue(getChduDataPacket.getPacketType()), getChduDataPacket.getTransactionId());
                getChduDataPacket.setResponse(GetChduDataPacketResponse.getInstance(transaction == null ? null : transaction.getData()));
                return;
            }
            if (message instanceof GetCertificateInfo) {
                logger.debug("Command processing 'GetCertificateInfo'");
                GetCertificateInfo getCertificateInfo = (GetCertificateInfo)message;
                if (getCertificateInfo.isFromPpekk()) {
                    if (this.activeConfiguration.getAuthentication() == null) throw new EKasaException(22L);
                    if (this.activeConfiguration.getAuthentication().getAuthentication() == null) throw new EKasaException(22L);
                    if (this.activeConfiguration.getAuthentication().getAuthenticationPassword() == null) {
                        throw new EKasaException(22L);
                    }
                    CertificateValidator certValid = new CertificateValidator(this.activeConfiguration.getAuthentication().getAuthentication(), this.activeConfiguration.getAuthentication().getAuthenticationPassword());
                    if (!certValid.isValid()) throw new EKasaException(32L);
                    getCertificateInfo.setResponse(GetCertificateInfoResponse.getInstance(certValid.getValidTo()));
                    return;
                }
                PPEKKAuthentication chduAuth = this.chdu.loadAuth();
                if (chduAuth == null) throw new EKasaException(22L);
                if (chduAuth.getAuthentication() == null) throw new EKasaException(22L);
                if (chduAuth.getAuthenticationPassword() == null) {
                    throw new EKasaException(22L);
                }
                CertificateValidator certValid = new CertificateValidator(chduAuth.getAuthentication(), chduAuth.getAuthenticationPassword());
                if (!certValid.isValid()) throw new EKasaException(32L);
                getCertificateInfo.setResponse(GetCertificateInfoResponse.getInstance(certValid.getValidTo()));
                return;
            }
            if (message instanceof GetChduIndex) {
                logger.debug("Command processing 'GetChduIndex'");
                GetChduIndex getChduIndex = (GetChduIndex)message;
                getChduIndex.setResponse(GetChduIndexResponse.getInstance(this.db.getAllMaxReceiptNumber()));
                return;
            }
            if (message instanceof GetIdentityInfo) {
                logger.debug("Command processing 'GetIdentityInfo'");
                GetIdentityInfo getIdentityInfo = (GetIdentityInfo)message;
                if (getIdentityInfo.isFromPpekk()) {
                    if (this.activeConfiguration.getIdentity() == null) throw new EKasaException(28L);
                    if (this.activeConfiguration.getIdentity().getIdentity() == null) {
                        throw new EKasaException(28L);
                    }
                    IdentityData ident = this.activeConfiguration.getIdentity().getIdentity();
                    getIdentityInfo.setResponse(GetIdentityInfoResponse.getInstance(ident.getIco(), ident.getDic(), ident.getIcdph(), ident.getOrganizationUnit() == null ? "" : ident.getOrganizationUnit().getCashRegisterCode(), ident.isPlatcaDph(), ident.getHeader(this.printer.getCharPerRow(), this.getId())));
                    return;
                }
                PPEKKIdentity chduIdent = this.chdu.loadIdent();
                if (chduIdent == null) throw new EKasaException(28L);
                if (chduIdent.getIdentity() == null) {
                    throw new EKasaException(28L);
                }
                IdentityData ident = chduIdent.getIdentity();
                getIdentityInfo.setResponse(GetIdentityInfoResponse.getInstance(ident.getIco(), ident.getDic(), ident.getIcdph(), ident.getOrganizationUnit() == null ? "" : ident.getOrganizationUnit().getCashRegisterCode(), ident.isPlatcaDph(), ident.getHeader(this.printer.getCharPerRow(), this.getId())));
                return;
            }
            if (this.ppekkState == PPEKK_STATE.CHDU_NOT_READY) {
                throw new EKasaException(7L);
            }
            if (message instanceof GetUnsendedTransaction) {
                logger.debug("Command processing 'GetUnsendedTransaction'");
                GetUnsendedTransaction getUnsendedTransaction = (GetUnsendedTransaction)message;
                List<String> listOfErroredTransaction = this.db.getListOfErroredTransaction(this.chdu.getSN());
                getUnsendedTransaction.setResponse(UnsendedTransactionResponse.getInstance(this.resendTask.resendStatus, this.db.getTimeoutedTransactionCount(this.chdu.getSN()) + listOfErroredTransaction.size(), this.db.getListOfTimeoutedTransaction(this.chdu.getSN()), listOfErroredTransaction));
                return;
            }
            if (message instanceof LoadLogo) {
                PPEKK pPEKK = this;
                synchronized (pPEKK) {
                    logger.debug("Command processing 'LoadLogo'");
                    LoadLogo obj = (LoadLogo)message;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(this.printer.loadNvImage(obj.getLogoCount(), obj.getData()));
                    int logoIndex = 0;
                    while (true) {
                        if (logoIndex >= obj.getLogoCount()) {
                            String transactionId2 = this.chdu.generTransactionId();
                            ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, transactionId2, baos.toByteArray());
                            this.chdu.setChduTransaction(transaction);
                            return;
                        }
                        baos.write(Printer.alignText(this.printer, "Logo " + (logoIndex + 1), PRINT_ALIGNMENT.LEFT));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        baos.write(this.printer.printNvImage(logoIndex + 1));
                        ++logoIndex;
                    }
                }
            }
            if (message instanceof Upgrade) {
                logger.debug("Command processing 'Upgrade'");
                Upgrade upgrade = (Upgrade)message;
                this.chdu.upgrade(upgrade.getInputStream());
                return;
            }
            if (message instanceof GetPrinterState) {
                logger.debug("Command processing 'GetPrinterState'");
                GetPrinterState getPrinterState = (GetPrinterState)message;
                boolean ready = this.chdu.isPrinterReady();
                PrinterStatus printerStatus = null;
                if (getPrinterState.isFullState()) {
                    PrinterEsc[] escRequest;
                    PrinterEsc[] chduCfg = escRequest = this.printer.getPrinterStatusEsc();
                    int ignoreit = escRequest.length;
                    int initPrinterFlag = 0;
                    while (true) {
                        if (initPrinterFlag >= ignoreit) {
                            printerStatus = this.printer.parsePrinterStatus(escRequest);
                            break;
                        }
                        PrinterEsc esc = chduCfg[initPrinterFlag];
                        esc.setResponse(this.chdu.setEsc(esc.getEsc(), esc.getResposneCount()));
                        ++initPrinterFlag;
                    }
                }
                getPrinterState.setResponse(GetPrinterStateResponse.getInstance(ready, printerStatus));
                return;
            }
            if (message instanceof SetPrinterEsc) {
                logger.debug("Command processing 'SetPrinterEsc'");
                SetPrinterEsc setPrinterEsc = (SetPrinterEsc)message;
                setPrinterEsc.setResponse(SetPrinterEscResponse.getInstance(this.chdu.setEsc(setPrinterEsc.getEsc(), setPrinterEsc.getResponseCount())));
                return;
            }
            if (message instanceof Display) {
                logger.debug("Command processing 'Display'");
                Display display = (Display)message;
                this.chdu.setDisplay(display.getDisplayNumber(), display.getData());
                return;
            }
            if (message instanceof GetChduSize) {
                logger.debug("Command processing 'GetChduSize'");
                GetChduSize getChduSize = (GetChduSize)message;
                StorageInfo storageInfo = this.chdu.getStorageInfo();
                DriveInfo dataStorage = storageInfo.getDataStorage();
                DriveInfo keyStorage = storageInfo.getKeyStorage();
                DriveInfo internalStorage = storageInfo.getInternalStorage();
                long sectorSize = storageInfo.getSectorSize();
                long storageSize = storageInfo.getSize();
                getChduSize.setResponse(ChduSizeResponse.getInstance(storageSize, sectorSize, dataStorage.getSize(), dataStorage.getFree(), keyStorage.getSize(), keyStorage.getFree(), internalStorage.getSize(), internalStorage.getFree()));
                return;
            }
            if (message instanceof GetChduInfo) {
                logger.debug("Command processing 'GetChduInfo'");
                GetChduInfo getChduInfo = (GetChduInfo)message;
                getChduInfo.setResponse(ChduInfoResponse.getInstance(this.chdu.getProductName(), this.chdu.getProductVersion(), this.chdu.getProductRelease(), this.chdu.getSN(), this.chdu.getLastTransactionId()));
                return;
            }
            if (message instanceof GetChduConnectionInfo) {
                logger.debug("Command processing 'GetChduConnectionInfo'");
                GetChduConnectionInfo getChduConnectionInfo = (GetChduConnectionInfo)message;
                ConnectionInfo connectionInfo = this.chdu.getConnectionInfo();
                getChduConnectionInfo.setResponse(ChduConnectionInfoResponse.getInstance(connectionInfo.getRtt(), connectionInfo.getCrcErrrors(), connectionInfo.getHeaderErrors(), connectionInfo.getPacketReceivedCount(), connectionInfo.getPacketTransmittedCount()));
                return;
            }
            if (message instanceof PrintTransactionCopy) {
                PPEKK pPEKK = this;
                synchronized (pPEKK) {
                    logger.debug("Command processing 'PrintTransactionCopy'");
                    transactionId = ((PrintTransactionCopy)message).getTransactionId();
                    TransactionStatus transactionStatus = this.chdu.getTransactionStatus((String)transactionId);
                    if (transactionStatus != null) {
                        byte[] paragonCopy = transactionStatus.getParagonCopy();
                        String newTransactionId = this.chdu.generTransactionId();
                        ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, newTransactionId, paragonCopy);
                        this.chdu.setChduTransaction(transaction);
                    }
                }
            }
            if (message instanceof PrintLastReceiptCopy) {
                PPEKK pPEKK = this;
                synchronized (pPEKK) {
                    logger.debug("Command processing 'PrintLastReceiptCopy'");
                    transactionId = new Transaction.ID(this.chdu.getLastTransactionId());
                    while (((Transaction.ID)transactionId).compareTo(Transaction.ID.ID_0) != 0) {
                        String tId = ((Transaction.ID)transactionId).format();
                        TransactionInfo info = this.chdu.getTransactionInfo(tId);
                        if (info != null) {
                            ByteArrayOutputStream baos;
                            ChduTransaction chduTransaction;
                            TransactionStatus tStatus = info.getTransactionStatus();
                            if (tStatus == null) {
                                if (info.getType() == 'R' && ((chduTransaction = this.chdu.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, tId)) != null || info.getRetryTransactionId() == null && info.getStatus() == 0) && (tStatus = this.chdu.getTransactionStatus(tId)) != null && tStatus.getRequestType() == SfsDataRequest.RequestType.RECEIPT) {
                                    baos = new ByteArrayOutputStream();
                                    baos.write(tStatus.getParagonCopy());
                                    baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                                    chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.chdu.generTransactionId(), baos.toByteArray());
                                    this.chdu.setChduTransaction(chduTransaction);
                                    break;
                                }
                            } else if (tStatus.getRequestType() == SfsDataRequest.RequestType.RECEIPT && ((chduTransaction = this.chdu.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, tId)) != null || tStatus.getRetryTransactionId() == null && tStatus.getStatus() == 0)) {
                                baos = new ByteArrayOutputStream();
                                baos.write(tStatus.getParagonCopy());
                                baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                                chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.chdu.generTransactionId(), baos.toByteArray());
                                this.chdu.setChduTransaction(chduTransaction);
                                break;
                            }
                        }
                        ((Transaction.ID)transactionId).decrement();
                    }
                }
            }
            if (message instanceof SynchronizeData) {
                logger.debug("Command processing 'SynchronizeData'");
                SYNCHRO_TYPE sYNCHRO_TYPE = ((SynchronizeData)message).getSynchroType();
                switch (sYNCHRO_TYPE) {
                    case PPEKK2CHDU: {
                        logger.debug("\tPPEKK -> CHDU");
                        if (this.ppekkState == PPEKK_STATE.EMPTY_CHDU) {
                            this.chdu.saveCfg(this.activeConfiguration.getConfiguration());
                            this.chdu.saveIdent(this.activeConfiguration.getIdentity());
                            this.chdu.saveAuth(this.activeConfiguration.getAuthentication());
                            this.db.resetData(this.chdu.getSN(), false);
                            this.initChdu(true);
                            return;
                        }
                        logger.warn("\tnot finished [CHDU not EMPTY]");
                        throw new EKasaException(42L);
                    }
                    case CHDU2PPEKK_ONLY_INDEX: {
                        logger.debug("\tCHDU -> PPEKK (ONLY_INDEX)");
                        this.synchronizeTransactionChdu2Ppekk();
                        return;
                    }
                    case CHDU2PPEKK: {
                        logger.debug("\tCHDU -> PPEKK");
                        if (this.ppekkState == PPEKK_STATE.CHDU_PPEKK_MISMATCH) {
                            PPEKKConfiguration newCfg = PPEKKConfiguration.getInstance(this.chduConfiguration.getConfiguration(), this.activeConfiguration.getConfiguration().getChduConnectionString());
                            this.synchronizeTransactionChdu2Ppekk();
                            this.db.setConfiguration(newCfg);
                            this.db.setAuthentication(PPEKKAuthentication.getInstance(null, null));
                            this.db.setIdentity(this.chduConfiguration.getIdentity());
                            this.initChdu(true);
                            return;
                        }
                        logger.warn("\tnot finished [CHDU same as PPEKK]");
                        throw new EKasaException(42L);
                    }
                }
                throw new EKasaException(42L);
            }
            if (this.ppekkState == PPEKK_STATE.CHDU_PPEKK_MISMATCH) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(31L);
            }
            if (this.swId == null) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(39L);
            }
            if (this.ppekkState == PPEKK_STATE.NOT_INITIALIZED_IDENTITY) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(28L);
            }
            if (this.ppekkState == PPEKK_STATE.NOT_INITIALIZED_AUTHENTICATION) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(22L);
            }
            if (this.ppekkState == PPEKK_STATE.EMPTY_CHDU) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(8L);
            }
            if (this.ppekkState == PPEKK_STATE.CHDU_NOT_READY) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(7L);
            }
            if (!this.license) {
                logger.warn("Command processing finished [ERROR:" + this.ppekkState.name());
                throw new EKasaException(40L);
            }
            if (message instanceof UnsendedTransaction) {
                PPEKK pPEKK = this;
                synchronized (pPEKK) {
                    logger.debug("Command processing 'UnsendedTransaction'");
                    UnsendedTransaction obj = (UnsendedTransaction)message;
                    if (obj.isResend()) {
                        this.resendTask.setResendStatus(RESEND_STATUS.RUNNING);
                    }
                    if (obj.isPrint()) {
                        this.synchronizeTransactionChdu2Ppekk();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(Printer.replaceEsc(this.printer, Localization.getString("report.unsended_transaction")).getBytes(this.printer.getCharset()));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        baos.write(Printer.replaceEsc(this.printer, this.activeConfiguration.getIdentity().getIdentity().getOrganizationUnit().getCashRegisterCode()).getBytes(this.printer.getCharset()));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        baos.write(Printer.replaceEsc(this.printer, this.getSwId()).getBytes(this.printer.getCharset()));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy;HH:mm:ss");
                        baos.write(Printer.replaceEsc(this.printer, sdf.format(new Date(System.currentTimeMillis()))).getBytes(this.printer.getCharset()));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        StringBuilder sb = new StringBuilder();
                        if (obj.getPrintDateFrom() != null || obj.getPrintDateTo() != null) {
                            sb.setLength(0);
                            sb.append(obj.getPrintDateFrom() == null ? "" : sdf.format(obj.getPrintDateFrom()));
                            sb.append("<=");
                            sb.append(Localization.getString("report.unsended_transaction.filter.date"));
                            sb.append("<=");
                            sb.append(obj.getPrintDateTo() == null ? "" : sdf.format(obj.getPrintDateTo()));
                            baos.write(Printer.replaceEsc(this.printer, sb.toString()).getBytes(this.printer.getCharset()));
                            baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        }
                        if (obj.getPrintNumberFrom() != null || obj.getPrintNumberTo() != null) {
                            sb.setLength(0);
                            sb.append(obj.getPrintNumberFrom() == null ? "" : obj.getPrintNumberFrom());
                            sb.append("<=");
                            sb.append(Localization.getString("report.unsended_transaction.filter.number"));
                            sb.append("<=");
                            sb.append(obj.getPrintNumberTo() == null ? "" : obj.getPrintNumberTo());
                            baos.write(Printer.replaceEsc(this.printer, sb.toString()).getBytes(this.printer.getCharset()));
                            baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        }
                        baos.write(Printer.replaceEsc(this.printer, this.printer.getDoubleSeparator()).getBytes(this.printer.getCharset()));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        UnsendedTransactionPrint udp = new UnsendedTransactionPrint(this.printer, this.activeConfiguration, baos.toByteArray());
                        this.db.getTimeoutedTransactionsStatus(this.chdu, this.chdu.getSN(), true, obj.getPrintDateFrom(), obj.getPrintDateTo(), obj.getPrintNumberFrom(), obj.getPrintNumberTo(), (DbTransactionStatusFetchListenerInterface)udp);
                        this.db.getErroredTransactionsStatus(this.chdu, this.chdu.getSN(), true, obj.getPrintDateFrom(), obj.getPrintDateTo(), obj.getPrintNumberFrom(), obj.getPrintNumberTo(), (DbTransactionStatusFetchListenerInterface)udp);
                        baos.reset();
                        baos.write(udp.getData());
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                        ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.chdu.generTransactionId(), baos.toByteArray());
                        this.chdu.setChduTransaction(chduTransaction);
                    }
                    List<String> listOfErroredTransaction = this.db.getListOfErroredTransaction(this.chdu.getSN());
                    obj.setResponse(UnsendedTransactionResponse.getInstance(this.resendTask.resendStatus, this.db.getTimeoutedTransactionCount(this.chdu.getSN()) + listOfErroredTransaction.size(), this.db.getListOfTimeoutedTransaction(this.chdu.getSN()), listOfErroredTransaction));
                    return;
                }
            }
            if (message instanceof Correction) {
                this.processCorrection((Correction)message);
            }
            if (!(message instanceof PrintInterface)) return;
            logger.debug("Command processing 'PrinterInterface'");
            PPEKK pPEKK = this;
            synchronized (pPEKK) {
                String transactionId3;
                PrinterEsc escRequest;
                if (this.printer == null) {
                    throw new EKasaException(15L);
                }
                boolean electronicReceipt = false;
                if (message instanceof ElectronicReceiptInterface) {
                    electronicReceipt = ((ElectronicReceiptInterface)((Object)message)).isElectronicReceipt();
                    logger.debug("\temail:" + ((ElectronicReceiptInterface)((Object)message)).getEmail());
                }
                if ((escRequest = this.printer.getPrinterConnectionStatus()) != null && this.chdu.setEsc(escRequest.getEsc(), escRequest.getResposneCount()).length == 0) {
                    logger.debug("Printer not responding");
                    throw new EKasaException(23L);
                }
                while (true) {
                    if (this.chdu.isPrinterReady()) {
                        transactionId3 = this.chdu.generTransactionId();
                        if (!(message instanceof EKasaServerMessageInterface) || this.db.getLastErrorTransaction(this.chdu.getSN()) == null) break;
                        throw new EKasaException(37L);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        logger.debug("PPEKK.process", e);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int row = 0;
                if (message instanceof ReceiptNumberInterface) {
                    logger.debug("eKasa document [gener new receipt number]'");
                    this.generReceiptNumber((ReceiptNumberInterface)((Object)message));
                }
                logger.debug("eKasa document [gener receipt body for printing]'");
                row = ((PrintInterface)((Object)message)).generReceiptBlock(this.chdu.getSN(), this.printer, this.activeConfiguration, this.getId(), baos, row);
                byte[] receiptBlock = baos.toByteArray();
                baos.reset();
                logger.debug("eKasa document [gener receipt footer for printing]'");
                ((PrintInterface)((Object)message)).generFooterBlock(this.chdu.getSN(), this.printer, this.activeConfiguration, baos);
                byte[] footerBlock = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                PrintDataHolder printData = new PrintDataHolder(receiptBlock, footerBlock, row);
                EKasaReturn eKasaReturn = null;
                byte[] bData = new byte[]{};
                PPEKKListener.ReceiptInfo receiptInfo = null;
                if (message instanceof EKasaServerMessageInterface) {
                    int l1 = printData.getReceiptBlock().length;
                    int l2 = printData.getFooterBlock().length;
                    bData = new byte[l1 + l2];
                    System.arraycopy(printData.getReceiptBlock(), 0, bData, 0, l1);
                    System.arraycopy(printData.getFooterBlock(), 0, bData, l1, l2);
                    this.invokeEventDocumentSend(this.uuid, transactionId3, transactionId3, message.getUUID(), 0, false, bData, receiptInfo, EVENT_TYPE.START);
                    eKasaReturn = this.sfs.sendToServer(this.uuid, null, transactionId3, (EKasaServerMessageInterface)((Object)message), bData);
                    logger.debug("eKasa document [gener receipt body]'");
                    if (eKasaReturn.getStatus() != 0) {
                        logger.warn("eKasa document [SFS response error " + eKasaReturn.getStatus() + "]'");
                        electronicReceipt = false;
                    }
                    receiptInfo = new PPEKKListener.ReceiptInfo(eKasaReturn.getOkp(), eKasaReturn.getPkp(), eKasaReturn.getUid(), eKasaReturn.getQRCode(), eKasaReturn.getReceiptNumber(), eKasaReturn.getReceiptMonth());
                    SfsDataResponse data = new SfsDataResponse(eKasaReturn.getResponse(), eKasaReturn.getStatus(), eKasaReturn.getErrorMessage(), eKasaReturn.getQRCode(), eKasaReturn.getOriginTransactionId());
                    ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId3, data.serialize());
                    this.chdu.setChduTransaction(chduTransaction);
                    String pcd = String.valueOf(eKasaReturn.getReceiptMonth()) + "/" + eKasaReturn.getReceiptNumber();
                    SfsDataInfo dataInfo = new SfsDataInfo(eKasaReturn.getStatus(), null, message instanceof ReceiptNumberInterface ? (char)'R' : 'L', pcd);
                    chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_STATUS, transactionId3, dataInfo.serialize());
                    this.chdu.setChduTransaction(chduTransaction);
                    if (eKasaReturn.getStatus() != 0 && eKasaReturn.getStatus() != -999999) {
                        this.invokeEventDocumentSend(this.uuid, transactionId3, transactionId3, message.getUUID(), eKasaReturn.getStatus(), false, bData, receiptInfo, EVENT_TYPE.ERROR);
                        logger.error("eKasa document error [not OK, not TIMEOUT]'");
                        throw new EKasaResponseException((long)eKasaReturn.getStatus(), eKasaReturn.getErrorMessage());
                    }
                    this.invokeEventDocumentSend(this.uuid, transactionId3, transactionId3, message.getUUID(), eKasaReturn.getStatus(), false, bData, receiptInfo, EVENT_TYPE.END);
                }
                if (electronicReceipt) {
                    logger.debug("eKasa document [preparing electronical document]'");
                    String receipt = ((ElectronicReceiptInterface)((Object)message)).getElectronicReceipt();
                    String email = ((ElectronicReceiptInterface)((Object)message)).getEmail();
                    BmpPrinter emailPrinter = this.printer.getEmailPrinter();
                    baos = new ByteArrayOutputStream();
                    row = 0;
                    row = ((PrintInterface)((Object)message)).generReceiptBlock(this.chdu.getSN(), emailPrinter, this.activeConfiguration, this.getId(), baos, row);
                    byte[] emailReceiptBlock = baos.toByteArray();
                    baos.reset();
                    ((PrintInterface)((Object)message)).generFooterBlock(this.chdu.getSN(), emailPrinter, this.activeConfiguration, baos);
                    byte[] emailFooterBlock = baos.toByteArray();
                    PrintDataHolder emailData = new PrintDataHolder(emailReceiptBlock, emailFooterBlock, row);
                    baos = new ByteArrayOutputStream();
                    baos.write(emailPrinter.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                    if (eKasaReturn != null) {
                        String uid = eKasaReturn.getUid();
                        if (eKasaReturn.getStatus() != 0) {
                            baos.write(Printer.alignText(emailPrinter, Localization.getString("paragon.offline_receipt"), PRINT_ALIGNMENT.CENTER));
                            baos.write(emailPrinter.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        }
                    }
                    baos.write(emailData.getReceiptBlock());
                    if (eKasaReturn != null) {
                        ((PrintInterface)((Object)message)).generQrCodeBlock(emailPrinter, this.activeConfiguration, baos, emailData.getRows(), eKasaReturn.getUid(), eKasaReturn.getPkp(), eKasaReturn.getOkp(), eKasaReturn.getQRCode());
                    }
                    baos.write(emailData.getFooterBlock());
                    baos.write(emailPrinter.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                    byte[] data = baos.toByteArray();
                    Image receiptImg = emailPrinter.render(data);
                    this.invokeEventEmail(this.uuid, transactionId3, message.getUUID(), email, receiptImg, receiptInfo);
                } else {
                    logger.debug("eKasa document [preparing printing]'");
                    baos = new ByteArrayOutputStream();
                    baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                    if (eKasaReturn != null) {
                        String uid = eKasaReturn.getUid();
                        if (eKasaReturn.getStatus() != 0) {
                            baos.write(Printer.alignText(this.printer, Localization.getString("paragon.offline_receipt"), PRINT_ALIGNMENT.CENTER));
                            baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        }
                    }
                    baos.write(printData.getReceiptBlock());
                    if (eKasaReturn != null) {
                        ((PrintInterface)((Object)message)).generQrCodeBlock(this.printer, this.activeConfiguration, baos, printData.getRows(), eKasaReturn.getUid(), eKasaReturn.getPkp(), eKasaReturn.getOkp(), eKasaReturn.getQRCode());
                    }
                    baos.write(printData.getFooterBlock());
                    byte[] data = baos.toByteArray();
                    if (((PrintInterface)((Object)message)).isAutoCutter()) {
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                    }
                    byte[] data1 = baos.toByteArray();
                    this.invokeEventDocumentPrint(this.uuid, transactionId3, transactionId3, message, data, bData, receiptInfo, EVENT_TYPE.START);
                    ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, transactionId3, data1);
                    while (true) {
                        if (this.chdu.isPrinterReady()) {
                            this.chdu.setChduTransaction(chduTransaction);
                            this.invokeEventDocumentPrint(this.uuid, transactionId3, transactionId3, message, data, bData, receiptInfo, EVENT_TYPE.END);
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            logger.debug("PPEKK.process", e);
                        }
                    }
                }
                if (eKasaReturn == null) return;
                if (eKasaReturn.getStatus() != 0) return;
                this.resendTask.setResendStatus(RESEND_STATUS.RUNNING);
                return;
            }
        }
        catch (IOException iOException) {
            throw new EKasaException(24L, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCorrection(Correction correction) throws IOException, EKasaException {
        logger.debug("Command processing 'Correction'");
        PPEKK pPEKK = this;
        synchronized (pPEKK) {
            String transactionId;
            if (this.printer == null) {
                throw new EKasaException(15L);
            }
            PrinterEsc escRequest = this.printer.getPrinterConnectionStatus();
            if (escRequest != null && this.chdu.setEsc(escRequest.getEsc(), escRequest.getResposneCount()).length == 0) {
                logger.debug("Printer not responding");
                throw new EKasaException(23L);
            }
            while (true) {
                if (this.chdu.isPrinterReady()) {
                    transactionId = this.chdu.generTransactionId();
                    if (this.db.getLastErrorTransaction(this.chdu.getSN()) != null) break;
                    throw new EKasaException(46L);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.debug("PPEKK.process", e);
                }
            }
            TransactionStatus correctionTransactionStatus = null;
            Database.TransactionHolder tCorrectionHolder = null;
            tCorrectionHolder = this.db.getLastErrorTransaction(this.chdu.getSN());
            correctionTransactionStatus = tCorrectionHolder.getTransactionStatus();
            if (correctionTransactionStatus == null) {
                correctionTransactionStatus = this.chdu.getTransactionStatus(tCorrectionHolder.getTransactionId());
                if (correctionTransactionStatus == null) {
                    throw new EKasaException(46L);
                }
                tCorrectionHolder.setTransactionStatus(correctionTransactionStatus);
            }
            CorrectHelper correctionHelper = new CorrectHelper(correction, correctionTransactionStatus);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int row = 0;
            logger.debug("eKasa document [gener receipt body for printing]'");
            row = correctionHelper.generReceiptBlock(this.chdu.getSN(), this.printer, this.activeConfiguration, this.getId(), baos, row);
            byte[] receiptBlock = baos.toByteArray();
            baos.reset();
            logger.debug("eKasa document [gener receipt footer for printing]'");
            correctionHelper.generFooterBlock(this.chdu.getSN(), this.printer, this.activeConfiguration, baos);
            byte[] footerBlock = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            PrintDataHolder printData = new PrintDataHolder(receiptBlock, footerBlock, row);
            EKasaReturn eKasaReturn = null;
            byte[] bData = new byte[]{};
            PPEKKListener.ReceiptInfo receiptInfo = null;
            int l1 = printData.getReceiptBlock().length;
            int l2 = printData.getFooterBlock().length;
            bData = new byte[l1 + l2];
            System.arraycopy(printData.getReceiptBlock(), 0, bData, 0, l1);
            System.arraycopy(printData.getFooterBlock(), 0, bData, l1, l2);
            this.invokeEventDocumentSend(this.uuid, transactionId, correctionTransactionStatus.getOriginTransactionId(), correctionHelper.getUUID(), 0, false, bData, receiptInfo, EVENT_TYPE.START);
            eKasaReturn = this.sfs.sendToServer(this.uuid, correctionHelper.getCorrectionTransactionStatus(), transactionId, correctionHelper, bData);
            logger.debug("eKasa document [gener receipt body]'");
            if (eKasaReturn.getStatus() != 0) {
                logger.warn("eKasa document [SFS response error " + eKasaReturn.getStatus() + "]'");
            }
            receiptInfo = new PPEKKListener.ReceiptInfo(eKasaReturn.getOkp(), eKasaReturn.getPkp(), eKasaReturn.getUid(), eKasaReturn.getQRCode(), eKasaReturn.getReceiptNumber(), eKasaReturn.getReceiptMonth());
            SfsDataResponse dataResponse = new SfsDataResponse(eKasaReturn.getResponse(), eKasaReturn.getStatus(), eKasaReturn.getErrorMessage(), eKasaReturn.getQRCode(), eKasaReturn.getOriginTransactionId());
            ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId, dataResponse.serialize());
            this.chdu.setChduTransaction(chduTransaction);
            String pcd = String.valueOf(eKasaReturn.getReceiptMonth()) + "/" + eKasaReturn.getReceiptNumber();
            SfsDataInfo dataInfo = new SfsDataInfo(eKasaReturn.getStatus(), correctionTransactionStatus == null ? null : correctionTransactionStatus.getTransactionId(), correctionHelper.getCorrectionTransactionStatus().getRequestType() == SfsDataRequest.RequestType.RECEIPT ? (char)'R' : 'L', pcd);
            chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_STATUS, transactionId, dataInfo.serialize());
            this.chdu.setChduTransaction(chduTransaction);
            if (eKasaReturn.getStatus() != 0 && eKasaReturn.getStatus() != -999999) {
                this.invokeEventDocumentSend(this.uuid, transactionId, correctionTransactionStatus.getOriginTransactionId(), correctionHelper.getUUID(), eKasaReturn.getStatus(), false, bData, receiptInfo, EVENT_TYPE.ERROR);
                logger.error("eKasa document error [not OK, not TIMEOUT]'");
                throw new EKasaResponseException((long)eKasaReturn.getStatus(), eKasaReturn.getErrorMessage());
            }
            this.invokeEventDocumentSend(this.uuid, transactionId, correctionTransactionStatus.getOriginTransactionId(), correctionHelper.getUUID(), eKasaReturn.getStatus(), false, bData, receiptInfo, EVENT_TYPE.END);
            boolean print = true;
            if (correctionTransactionStatus != null && tCorrectionHolder != null) {
                String tId = tCorrectionHolder.getTransactionStatus().getRetryTransactionId();
                while (tId != null) {
                    TransactionStatus tStatus = this.chdu.getTransactionStatus(tId);
                    ChduTransaction t = this.chdu.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, tId);
                    if (t != null) {
                        print = false;
                        break;
                    }
                    tId = tStatus.getRetryTransactionId();
                }
                logger.debug("eKasa document [correction resend - print:" + print + "]'");
            }
            if (print) {
                logger.debug("eKasa document [preparing printing]'");
                baos = new ByteArrayOutputStream();
                baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                if (eKasaReturn != null) {
                    String uid = eKasaReturn.getUid();
                    if (eKasaReturn.getStatus() != 0) {
                        baos.write(Printer.alignText(this.printer, Localization.getString("paragon.offline_receipt"), PRINT_ALIGNMENT.CENTER));
                        baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    }
                }
                baos.write(printData.getReceiptBlock());
                if (eKasaReturn != null) {
                    correctionHelper.generQrCodeBlock(this.printer, this.activeConfiguration, baos, printData.getRows(), eKasaReturn.getUid(), eKasaReturn.getPkp(), eKasaReturn.getOkp(), eKasaReturn.getQRCode());
                }
                baos.write(printData.getFooterBlock());
                byte[] data = baos.toByteArray();
                if (correctionHelper.isAutoCutter()) {
                    baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                }
                byte[] data1 = baos.toByteArray();
                this.invokeEventDocumentPrint(this.uuid, transactionId, correctionTransactionStatus.getOriginTransactionId(), correctionHelper, data, bData, receiptInfo, EVENT_TYPE.START);
                chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, transactionId, data1);
                while (true) {
                    if (this.chdu.isPrinterReady()) {
                        this.chdu.setChduTransaction(chduTransaction);
                        this.invokeEventDocumentPrint(this.uuid, transactionId, correctionTransactionStatus.getOriginTransactionId(), correctionHelper, data, bData, receiptInfo, EVENT_TYPE.END);
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        logger.debug("PPEKK.process", e);
                    }
                }
            }
            if (eKasaReturn == null) return;
            if (eKasaReturn.getStatus() != 0) return;
            this.resendTask.setResendStatus(RESEND_STATUS.RUNNING);
            return;
        }
    }

    private synchronized void synchronizeTransactionChdu2Ppekk() throws EKasaException {
        this.invokeEventSynchronizationProcess(this.uuid, EVENT_TYPE.START);
        try {
            logger.debug("Synchronization CHDU to PPEKK [BEGIN]");
            this.db.resetData(this.chdu.getSN(), true);
            String indexData = this.chdu.getIndex();
            Transaction.ID actualTransactionId = new Transaction.ID(0, 0);
            Transaction.ID lastTransactionId = new Transaction.ID(this.chdu.getLastTransactionId());
            String lastTId = lastTransactionId.format();
            if (indexData != null) {
                logger.debug("Synchronization CHDU to PPEKK [INDEX PARSING]");
                String[] lines = indexData.split("\n");
                int type = 0;
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (!line.trim().equals("")) {
                        if (line.startsWith("[INDEX:")) {
                            type = 1;
                            actualTransactionId.parse(line.substring(9, 23));
                        } else if (line.equals("[RECEIPT_NUMBER]")) {
                            type = 2;
                        } else {
                            switch (type) {
                                case 1: {
                                    try {
                                        String tId = line.contains("|") ? line.split("\\|")[0] : line;
                                        this.invokeEventSynchronization(this.uuid, tId, lastTId, EVENT_TYPE.START);
                                        TransactionInfo tInfo = null;
                                        if (line.contains("|")) {
                                            try {
                                                String[] t = line.split("\\|");
                                                tInfo = new TransactionInfo(true, t[0], Integer.parseInt(t[1]), t[2].equals("") ? null : t[2], t[3].charAt(0), t[4], null);
                                                logger.debug("Index readed direct from index file");
                                            }
                                            catch (Exception e) {
                                                logger.debug("Error reading indexes", e);
                                            }
                                        }
                                        if (tInfo == null) {
                                            tInfo = this.chdu.getTransactionInfo(tId);
                                            logger.debug("Index readed from status");
                                        }
                                        if (tInfo != null) {
                                            this.db.setTransactionInfo(tInfo);
                                        }
                                        this.invokeEventSynchronization(this.uuid, tId, lastTId, EVENT_TYPE.END);
                                    }
                                    catch (EKasaException e) {
                                        logger.fatal("Import data from CHDU to PPEKK", e);
                                    }
                                    break;
                                }
                                case 2: {
                                    String[] d = line.split("=");
                                    this.db.setMaxReceiptNumber(d[0], Long.parseLong(d[1]));
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            logger.debug("Synchronization CHDU to PPEKK [NON INDEXED READING]");
            int quickCounter = 0;
            int counter = 0;
            actualTransactionId.increment();
            while (actualTransactionId.compareTo(lastTransactionId) <= 0) {
                try {
                    String tId = actualTransactionId.format();
                    this.invokeEventSynchronization(this.uuid, tId, lastTId, EVENT_TYPE.START);
                    TransactionInfo tInfo = this.chdu.getTransactionInfo(tId);
                    if (tInfo != null) {
                        ++counter;
                        if (tInfo.isQuick()) {
                            ++quickCounter;
                        }
                        this.db.setTransactionInfo(tInfo);
                    }
                    this.invokeEventSynchronization(this.uuid, tId, lastTId, EVENT_TYPE.END);
                }
                catch (EKasaException e) {
                    logger.fatal("Import data from CHDU to PPEKK", e);
                }
                actualTransactionId.increment();
            }
            this.db.setChduState(this.chdu.getSN(), this.chdu.getLastTransactionId());
            if (!this.db.isSyncChdu(this.chdu.getSN(), this.chdu.getLastTransactionId())) {
                this.db.setChduState("", this.chdu.getLastTransactionId());
                this.chdu.disconnect();
                throw new EKasaException(42L);
            }
            if (counter > quickCounter) {
                logger.debug("Synchronization CHDU to PPEKK [not all transactions are statused -> create index file]");
                this.synchronizeUnsendedTransaction();
            }
            logger.debug("Synchronization CHDU to PPEKK [FINISH]");
        }
        finally {
            this.invokeEventSynchronizationProcess(this.uuid, EVENT_TYPE.END);
        }
    }

    public boolean interrupt() throws EKasaException {
        return this.chdu.interrupt();
    }

    private void generReceiptNumber(ReceiptNumberInterface message) throws EKasaException {
        Date createDate = message.getCreateDate();
        long receiptNumber = this.db.getLastReceiptNumber(createDate);
        message.setReceiptNumber(receiptNumber + 1L);
    }

    public String getSwId() {
        return this.swId;
    }

    private void generSwId() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(PPEKKInfo.getCompany());
            sb.append("|");
            sb.append(PPEKKInfo.getProductName());
            sb.append("|");
            sb.append(this.chdu.getProductName());
            sb.append("|");
            sb.append(PPEKKInfo.getVersion());
            sb.append("|");
            sb.append(this.chdu.getProductVersion());
            MessageDigest cript = MessageDigest.getInstance("SHA-1");
            cript.reset();
            cript.update(sb.toString().getBytes("utf-8"));
            this.swId = String.format("%40s", new BigInteger(1, cript.digest()).toString(16)).replace(" ", "0").toUpperCase();
            logger.info("swid successfully generated: " + this.swId.length());
        }
        catch (Exception e) {
            this.swId = null;
        }
    }

    private void invokeEventDocumentSend(UUID uuid, String transactionId, String originTransactionId, UUID messageUuid, int status, boolean resend, byte[] copyData, PPEKKListener.ReceiptInfo receiptInfo, EVENT_TYPE eventType) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.documentSend(this, eventType, messageUuid, transactionId, originTransactionId, status, copyData, receiptInfo, resend, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR DocumentSend listener", e);
            }
        }
    }

    private void invokeEventChduLoadConfig(PPEKKConfiguration chduCfg, PPEKKAuthentication chduAuth, PPEKKIdentity chduIdent) throws EKasaException {
        if (!this.uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.chduLoadConfig(this, chduCfg.getConfigFile().getContent(), chduIdent.getIdentity(), when);
            }
            catch (Exception e) {
                logger.fatal("ERROR DocumentSend listener", e);
            }
        }
    }

    private void invokeEventDocumentPrint(UUID uuid, String transactionId, String originTransactionId, AbstractCommand message, byte[] printData, byte[] copyData, PPEKKListener.ReceiptInfo receiptInfo, EVENT_TYPE eventType) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.documentPrint(this, eventType, message.getUUID(), transactionId, originTransactionId, printData, copyData, receiptInfo, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR DocumentPrint listener", e);
            }
        }
    }

    private void invokeEventSynchronizationProcess(UUID uuid, EVENT_TYPE eventType) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.synchronizeChdu2PpekkProcess(this, eventType, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR Synchronization listener", e);
            }
        }
    }

    private void invokeEventSynchronization(UUID uuid, String transactionId, String lastTransactionId, EVENT_TYPE eventType) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.synchronizeChdu2Ppekk(this, transactionId, lastTransactionId, eventType, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR Synchronization listener", e);
            }
        }
    }

    private void invokeEventResendError(UUID uuid, EKasaException e) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.resendError(this, e, when);
            }
            catch (Exception ex) {
                logger.fatal("ERROR Resend listener", ex);
            }
        }
    }

    private void invokeChduAuthenticationAlert(UUID uuid, AUTHENTICATION_ALERT_TYPE alertType) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.chduAuthenticationAlert(this, alertType, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR ChduAutneticationAlert listener", e);
            }
        }
    }

    private void invokeEventEmail(UUID uuid, String transactionId, UUID messageUuid, String email, Image receipt, PPEKKListener.ReceiptInfo receiptInfo) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        Date when = new Date();
        for (PPEKKListener listener : this.listeners) {
            try {
                listener.mail(this, messageUuid, transactionId, email, receipt, receiptInfo, when);
            }
            catch (Exception e) {
                logger.fatal("ERROR Email listener", e);
            }
        }
    }

    public CHDU getCHDU(UUID uuid) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        return this.chdu;
    }

    public Database getDb(UUID uuid) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        return this.db;
    }

    private synchronized void initPrinter(AbstractPrinter printer, CHDU chdu) {
        try {
            logger.debug("Trying initialize printer");
            if (printer == null) {
                logger.debug("\t\tNo printer driver defined");
            } else if (chdu != null && chdu.isConnected()) {
                byte[] initData = printer.getEscSequence(PRINT_SEQUENCE_TYPE.INIT_PRN);
                if (initData.length > 0) {
                    String transactionId = chdu.generTransactionId();
                    ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, transactionId, initData);
                    chdu.setChduTransaction(transaction);
                } else {
                    logger.debug("\t\tNo defined init sequence");
                }
            } else {
                logger.debug("\t\tNo chdu conencted");
            }
        }
        catch (Exception e) {
            logger.error("PPEKK.initPrinter()", e);
        }
    }

    private synchronized void synchronizeUnsendedTransaction() throws EKasaException {
        String transactionId = this.chdu.getLastTransactionId();
        UnsendedTransactionIndex uti = new UnsendedTransactionIndex(this.activeConfiguration, transactionId);
        Map<String, Long> rn = this.db.getAllMaxReceiptNumber();
        this.db.getTimeoutedTransactionsStatus(this.chdu, this.chdu.getSN(), false, (Date)null, (Date)null, (Long)null, (Long)null, (DbTransactionStatusFetchListenerInterface)uti);
        this.db.getErroredTransactionsStatus(this.chdu, this.chdu.getSN(), false, (Date)null, (Date)null, (Long)null, (Long)null, (DbTransactionStatusFetchListenerInterface)uti);
        uti.addData("[RECEIPT_NUMBER]");
        uti.addData("\n");
        for (String m : rn.keySet()) {
            long n = rn.get(m);
            uti.addData(m);
            uti.addData("=");
            uti.addData("" + n);
            uti.addData("\n");
        }
        this.chdu.setIndex(uti.getData());
    }

    public PPEKK_STATE getPPEKKState() {
        return this.ppekkState;
    }

    public CHDUState getChduState() {
        return this.chduState;
    }

    private class ResendTransactionTask
    implements Runnable {
        private RESEND_STATUS resendStatus = RESEND_STATUS.WAITING;
        private boolean running = false;

        private ResendTransactionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                block38: {
                    if (PPEKK.this.chduCertificateValidator != null) {
                        PPEKK.this.chduCertificateValidator.validate();
                        if (PPEKK.this.chduCertificateValidator.getLastAlertType() != null) {
                            try {
                                PPEKK.this.invokeChduAuthenticationAlert(PPEKK.this.uuid, PPEKK.this.chduCertificateValidator.getLastAlertType());
                            }
                            catch (EKasaException eKasaException) {
                                // empty catch block
                            }
                        }
                    }
                    if (PPEKK.this.synchronizeUnsendedTransaction) {
                        try {
                            PPEKK.this.synchronizeUnsendedTransaction();
                        }
                        catch (Exception e) {
                            logger.fatal("Create unsended index to CHDU", e);
                        }
                        PPEKK.this.synchronizeUnsendedTransaction = false;
                    }
                    if (this.resendStatus == RESEND_STATUS.RUNNING) {
                        if (PPEKK.this.ppekkState == PPEKK_STATE.CHDU_PPEKK_MISMATCH) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (PPEKK.this.swId == null) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (PPEKK.this.ppekkState == PPEKK_STATE.NOT_INITIALIZED_IDENTITY) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (PPEKK.this.ppekkState == PPEKK_STATE.NOT_INITIALIZED_AUTHENTICATION) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (PPEKK.this.ppekkState == PPEKK_STATE.EMPTY_CHDU) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (PPEKK.this.ppekkState == PPEKK_STATE.CHDU_NOT_READY) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else if (!PPEKK.this.license) {
                            logger.warn("Command processing finished [ERROR:" + PPEKK.this.ppekkState.name());
                            this.resendStatus = RESEND_STATUS.WAITING;
                        } else {
                            try {
                                Database.TransactionHolder tErrorHolder = PPEKK.this.db.getLastErrorTransaction(PPEKK.this.chdu.getSN());
                                if (tErrorHolder == null) {
                                    TransactionStatus transactionStatus = PPEKK.this.db.getFirstTimeoutedTransactionStatus(PPEKK.this.chdu.getSN(), PPEKK.this.chdu);
                                    if (transactionStatus == null) {
                                        this.resendStatus = RESEND_STATUS.WAITING;
                                        break block38;
                                    }
                                    PPEKK pPEKK = PPEKK.this;
                                    synchronized (pPEKK) {
                                        SfsDataRequest request = new SfsDataRequest(transactionStatus);
                                        String transactionId = PPEKK.this.chdu.generTransactionId();
                                        PPEKKListener.ReceiptInfo receiptInfo = null;
                                        PPEKK.this.invokeEventDocumentSend(PPEKK.this.uuid, transactionId, transactionStatus.getOriginTransactionId(), request.getMessageUuid(), 0, true, request.getParagonCopyPrint(), receiptInfo, EVENT_TYPE.START);
                                        EKasaReturn eKasaReturn = PPEKK.this.sfs.resendToServer(PPEKK.this.uuid, transactionId, request, transactionStatus);
                                        SfsDataResponse data = new SfsDataResponse(eKasaReturn.getResponse(), eKasaReturn.getStatus(), eKasaReturn.getErrorMessage(), eKasaReturn.getQRCode(), eKasaReturn.getOriginTransactionId());
                                        ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId, data.serialize());
                                        PPEKK.this.chdu.setChduTransaction(chduTransaction);
                                        String pcd = String.valueOf(eKasaReturn.getReceiptMonth()) + "/" + eKasaReturn.getReceiptNumber();
                                        SfsDataInfo dataInfo = new SfsDataInfo(eKasaReturn.getStatus(), transactionStatus.getTransactionId(), request.getRequestType().getShortage(), pcd);
                                        chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_STATUS, transactionId, dataInfo.serialize());
                                        PPEKK.this.chdu.setChduTransaction(chduTransaction);
                                        receiptInfo = new PPEKKListener.ReceiptInfo(eKasaReturn.getOkp(), eKasaReturn.getPkp(), eKasaReturn.getUid(), eKasaReturn.getQRCode(), eKasaReturn.getReceiptNumber(), eKasaReturn.getReceiptMonth());
                                        if (eKasaReturn.getStatus() != 0) {
                                            this.resendStatus = RESEND_STATUS.WAITING;
                                            PPEKK.this.invokeEventDocumentSend(PPEKK.this.uuid, transactionId, transactionStatus.getOriginTransactionId(), request.getMessageUuid(), eKasaReturn.getStatus(), true, request.getParagonCopyPrint(), receiptInfo, EVENT_TYPE.ERROR);
                                            continue;
                                        }
                                        PPEKK.this.invokeEventDocumentSend(PPEKK.this.uuid, transactionId, transactionStatus.getOriginTransactionId(), request.getMessageUuid(), eKasaReturn.getStatus(), true, request.getParagonCopyPrint(), receiptInfo, EVENT_TYPE.END);
                                        break block38;
                                    }
                                }
                                this.resendStatus = RESEND_STATUS.WAITING;
                            }
                            catch (EKasaException e) {
                                logger.debug("PPEKK.ResendTransactionTask", e);
                                try {
                                    PPEKK.this.invokeEventResendError(PPEKK.this.uuid, e);
                                }
                                catch (EKasaException ignore) {
                                    logger.debug("PPEKK.ResendTransactionTask", ignore);
                                }
                                this.resendStatus = RESEND_STATUS.WAITING;
                            }
                            catch (Exception e) {
                                logger.debug("PPEKK.ResendTransactionTask", e);
                                try {
                                    PPEKK.this.invokeEventResendError(PPEKK.this.uuid, new EKasaException(24L, (Throwable)e));
                                }
                                catch (EKasaException ignore) {
                                    logger.debug("PPEKK.ResendTransactionTask", ignore);
                                }
                                this.resendStatus = RESEND_STATUS.WAITING;
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.resendStatus = RESEND_STATUS.WAITING;
        }

        private synchronized void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            Thread t = new Thread(this);
            t.start();
        }

        private synchronized void stop() {
            this.running = false;
            while (this.resendStatus != RESEND_STATUS.WAITING) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public synchronized void setResendStatus(RESEND_STATUS status) {
            if (this.running) {
                this.resendStatus = status;
            }
        }
    }
}

