/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationData;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationPassword;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.utils.Base64;
import sk.singularisdev.ekasask.utils.ChduSerialize;
import sk.singularisdev.ekasask.utils.IniFile;
import sk.singularisdev.ekasask.utils.Utility;
import sk.singularisdev.ekasask.xmlparser.AuthenticationData;

public class PPEKKAuthentication {
    private static final Logger logger = LoggerManager.getLogger(PPEKKAuthentication.class.getName());
    private Cipher cipherEncrypt;
    private Cipher cipherDecrypt;
    private Base64 base64Encoder = new Base64();
    private String authenticationData;
    private String authenticationPassword;
    private AuthenticationData authentication;

    private PPEKKAuthentication() {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("P@ssw0rdP@ssw0rd".getBytes(), "AES");
            this.cipherEncrypt = Cipher.getInstance("AES");
            this.cipherEncrypt.init(1, secretKey);
            this.cipherDecrypt = Cipher.getInstance("AES");
            this.cipherDecrypt.init(2, secretKey);
        }
        catch (Exception e) {
            this.cipherEncrypt = null;
            this.cipherDecrypt = null;
            logger.debug("PPEKKAuthentication.PPEKKAuthentication", e);
        }
    }

    public String getAuthenticationData() {
        return this.authenticationData;
    }

    public AuthenticationData getAuthentication() {
        return this.authentication;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PPEKKAuthentication setup = (PPEKKAuthentication)o;
        return Utility.equals(this.authenticationData, setup.authenticationData) && Utility.equals(this.authenticationPassword, setup.authenticationPassword);
    }

    public ChduSerialize getChduFile() throws Exception {
        String authenticationData = this.getAuthenticationData();
        String password = this.getAuthenticationPassword();
        ChduSerialize iniFile = new ChduSerialize("UTF-8");
        iniFile.setValue(SetupItemAuthenticationData.NAME, authenticationData);
        if (password != null) {
            byte[] data = password.getBytes("UTF-8");
            password = this.base64Encoder.encode(this.cipherEncrypt.doFinal(data));
        }
        iniFile.setValue(SetupItemAuthenticationPassword.NAME, password);
        logger.debug("INI file content [PPEKKAuthentication.getAuthFile()]");
        logger.debug(new String(iniFile.getContent(), "UTF-8"));
        return iniFile;
    }

    public static PPEKKAuthentication getInstance(ChduSerialize authFile) throws EKasaException {
        try {
            PPEKKAuthentication setup = new PPEKKAuthentication();
            String authenticationData = authFile.getString(SetupItemAuthenticationData.NAME);
            if (authenticationData == null) {
                setup.authenticationData = null;
                setup.authentication = null;
            } else {
                setup.authenticationData = authenticationData;
                setup.authentication = new AuthenticationData(setup.authenticationData);
                if (!setup.authentication.parse()) {
                    setup.authentication = null;
                }
            }
            String authenticationPassword = authFile.getString(SetupItemAuthenticationPassword.NAME);
            if (authenticationPassword == null) {
                setup.authenticationPassword = null;
            } else {
                byte[] data = Base64.toBytes(authenticationPassword);
                data = setup.cipherDecrypt.doFinal(data);
                setup.authenticationPassword = new String(data, "UTF8");
            }
            return setup;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public IniFile getAuthFile() throws Exception {
        byte[] data;
        String authenticationData = this.getAuthenticationData();
        String password = this.getAuthenticationPassword();
        IniFile iniFile = new IniFile();
        IniFile.Section section = iniFile.getSection("AuthenticationData");
        if (authenticationData != null) {
            data = authenticationData.getBytes("UTF-8");
            authenticationData = this.base64Encoder.encode(this.cipherEncrypt.doFinal(data));
        }
        section.setValue(SetupItemAuthenticationData.NAME, authenticationData);
        if (password != null) {
            data = password.getBytes("UTF-8");
            password = this.base64Encoder.encode(this.cipherEncrypt.doFinal(data));
        }
        section.setValue(SetupItemAuthenticationPassword.NAME, password);
        logger.debug("INI file content [PPEKKAuthentication.getAuthFile()]");
        logger.debug(iniFile.getContent());
        return iniFile;
    }

    public static PPEKKAuthentication getInstance(IniFile authFile) throws EKasaException {
        try {
            PPEKKAuthentication setup = new PPEKKAuthentication();
            IniFile.Section section = authFile.getSection("AuthenticationData");
            String authenticationData = section.getString(SetupItemAuthenticationData.NAME);
            if (authenticationData == null) {
                setup.authenticationData = null;
                setup.authentication = null;
            } else {
                byte[] data = Base64.toBytes(authenticationData);
                data = setup.cipherDecrypt.doFinal(data);
                setup.authenticationData = new String(data, "UTF8");
                setup.authentication = new AuthenticationData(setup.authenticationData);
                if (!setup.authentication.parse()) {
                    setup.authentication = null;
                }
            }
            String authenticationPassword = section.getString(SetupItemAuthenticationPassword.NAME);
            if (authenticationPassword == null) {
                setup.authenticationPassword = null;
            } else {
                byte[] data = Base64.toBytes(authenticationPassword);
                data = setup.cipherDecrypt.doFinal(data);
                setup.authenticationPassword = new String(data, "UTF8");
            }
            return setup;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public static PPEKKAuthentication getInstance(String authenticationData, String authenticationPassword) {
        PPEKKAuthentication setup = new PPEKKAuthentication();
        setup.authenticationData = authenticationData;
        setup.authenticationPassword = authenticationPassword;
        setup.authentication = new AuthenticationData(authenticationData);
        if (!setup.authentication.parse()) {
            setup.authentication = null;
        }
        return setup;
    }

    public static PPEKKAuthentication getInstance(PPEKKAuthentication auth, SetupItemInterface setupItem) {
        PPEKKAuthentication setup = new PPEKKAuthentication();
        setup.authenticationData = auth.authenticationData;
        setup.authenticationPassword = auth.authenticationPassword;
        setup.authentication = auth.authentication;
        boolean needUpdate = false;
        if (setupItem instanceof SetupItemAuthenticationData) {
            SetupItemAuthenticationData item = (SetupItemAuthenticationData)setupItem;
            setup.authenticationData = item.getAuthenticationData();
            needUpdate = true;
        } else if (setupItem instanceof SetupItemAuthenticationPassword) {
            SetupItemAuthenticationPassword item = (SetupItemAuthenticationPassword)setupItem;
            setup.authenticationPassword = item.getPassword();
            needUpdate = true;
        }
        if (needUpdate) {
            setup.authentication = new AuthenticationData(setup.authenticationData);
            if (!setup.authentication.parse()) {
                setup.authentication = null;
            }
        }
        return setup;
    }

    public boolean isEmpty() {
        if (this.authenticationData == null || this.authenticationData.equals("")) {
            return true;
        }
        return this.authenticationPassword == null || this.authenticationPassword.equals("");
    }
}

