/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask;

import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.setup.SetupItemChduConnectionString;
import sk.singularisdev.ekasask.command.setup.SetupItemChduConnectionStringAlt;
import sk.singularisdev.ekasask.command.setup.SetupItemDisplay;
import sk.singularisdev.ekasask.command.setup.SetupItemException48;
import sk.singularisdev.ekasask.command.setup.SetupItemHeader;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterBaudrate;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterOther;
import sk.singularisdev.ekasask.command.setup.SetupItemPrinterType;
import sk.singularisdev.ekasask.command.setup.SetupItemVat;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.printer.Display;
import sk.singularisdev.ekasask.utils.Base64;
import sk.singularisdev.ekasask.utils.IniFile;
import sk.singularisdev.ekasask.utils.Utility;

public class PPEKKConfiguration {
    private static final Logger logger = LoggerManager.getLogger(PPEKKConfiguration.class.getName());
    private Cipher cipherEncrypt;
    private Cipher cipherDecrypt;
    private Base64 base64Encoder = new Base64();
    private String[] header = new String[SetupItemHeader.HEADER_COUNT];
    private String chduConnectionString;
    private String[] chduConnectionStringAlt = new String[SetupItemChduConnectionStringAlt.CONNECTION_COUNT];
    private Display display1;
    private Display display2;
    private String printerType;
    private String printerOther;
    private Integer printerBaudrate;
    private Integer vatA;
    private VAT_TYPE vatTypeA;
    private Integer vatB;
    private VAT_TYPE vatTypeB;
    private Integer vatC;
    private VAT_TYPE vatTypeC;
    private Integer vatD;
    private VAT_TYPE vatTypeD;
    private Integer vatE;
    private VAT_TYPE vatTypeE;
    private Integer vatF;
    private VAT_TYPE vatTypeF;
    private Integer vatG;
    private VAT_TYPE vatTypeG;
    private Integer vatH;
    private VAT_TYPE vatTypeH;
    private boolean exception48;

    private PPEKKConfiguration() {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("P@ssw0rdP@ssw0rd".getBytes(), "AES");
            this.cipherEncrypt = Cipher.getInstance("AES");
            this.cipherEncrypt.init(1, secretKey);
            this.cipherDecrypt = Cipher.getInstance("AES");
            this.cipherDecrypt.init(2, secretKey);
        }
        catch (Exception e) {
            this.cipherEncrypt = null;
            this.cipherDecrypt = null;
            logger.debug("PPEKKConfiguration.PPEKKConfiguration", e);
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    public String getChduConnectionString() {
        return this.chduConnectionString;
    }

    public String[] getChduConnectionStringAlt() {
        return this.chduConnectionStringAlt;
    }

    public Display getDisplay1() {
        return this.display1;
    }

    public Display getDisplay2() {
        return this.display2;
    }

    public String getPrinterType() {
        return this.printerType;
    }

    public Integer getPrinterBaudrate() {
        return this.printerBaudrate;
    }

    public String getPrinterOther() {
        return this.printerOther;
    }

    public Integer getVatA() {
        return this.vatA;
    }

    public VAT_TYPE getVatTypeA() {
        return this.vatTypeA;
    }

    public Integer getVatB() {
        return this.vatB;
    }

    public VAT_TYPE getVatTypeB() {
        return this.vatTypeB;
    }

    public Integer getVatC() {
        return this.vatC;
    }

    public VAT_TYPE getVatTypeC() {
        return this.vatTypeC;
    }

    public Integer getVatD() {
        return this.vatD;
    }

    public VAT_TYPE getVatTypeD() {
        return this.vatTypeD;
    }

    public Integer getVatE() {
        return this.vatE;
    }

    public VAT_TYPE getVatTypeE() {
        return this.vatTypeE;
    }

    public Integer getVatF() {
        return this.vatF;
    }

    public VAT_TYPE getVatTypeF() {
        return this.vatTypeF;
    }

    public Integer getVatG() {
        return this.vatG;
    }

    public VAT_TYPE getVatTypeG() {
        return this.vatTypeG;
    }

    public Integer getVatH() {
        return this.vatH;
    }

    public VAT_TYPE getVatTypeH() {
        return this.vatTypeH;
    }

    public boolean getException48() {
        return this.exception48;
    }

    public void setChduConnectionString(String chduConnectionString) {
        this.chduConnectionString = chduConnectionString;
    }

    public int getVat(VAT_LEVEL vat) {
        switch (vat) {
            case A: {
                return this.vatA == null ? -1 : this.vatA;
            }
            case B: {
                return this.vatB == null ? -1 : this.vatB;
            }
            case C: {
                return this.vatC == null ? -1 : this.vatC;
            }
            case D: {
                return this.vatD == null ? -1 : this.vatD;
            }
            case E: {
                return this.vatE == null ? -1 : this.vatE;
            }
            case F: {
                return this.vatF == null ? -1 : this.vatF;
            }
            case G: {
                return this.vatG == null ? -1 : this.vatG;
            }
            case H: {
                return this.vatH == null ? -1 : this.vatH;
            }
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PPEKKConfiguration setup = (PPEKKConfiguration)o;
        return Utility.equals(this.chduConnectionString, setup.chduConnectionString) && Arrays.deepEquals(this.chduConnectionStringAlt, setup.chduConnectionStringAlt) && Utility.equals(this.exception48, setup.exception48) && Arrays.deepEquals(this.header, setup.header) && Utility.equals(this.display1, setup.display1) && Utility.equals(this.display2, setup.display2) && Utility.equals(this.printerBaudrate, setup.printerBaudrate) && Utility.equals(this.printerType, setup.printerType) && Utility.equals(this.printerOther, setup.printerOther) && Utility.equals(this.vatA, setup.vatA) && Utility.equals((Object)this.vatTypeA, (Object)setup.vatTypeA) && Utility.equals(this.vatB, setup.vatB) && Utility.equals((Object)this.vatTypeB, (Object)setup.vatTypeB) && Utility.equals(this.vatC, setup.vatC) && Utility.equals((Object)this.vatTypeC, (Object)setup.vatTypeC) && Utility.equals(this.vatD, setup.vatD) && Utility.equals((Object)this.vatTypeD, (Object)setup.vatTypeD) && Utility.equals(this.vatE, setup.vatE) && Utility.equals((Object)this.vatTypeE, (Object)setup.vatTypeE) && Utility.equals(this.vatF, setup.vatF) && Utility.equals((Object)this.vatTypeF, (Object)setup.vatTypeF) && Utility.equals(this.vatG, setup.vatG) && Utility.equals((Object)this.vatTypeG, (Object)setup.vatTypeG) && Utility.equals(this.vatH, setup.vatH) && Utility.equals((Object)this.vatTypeH, (Object)setup.vatTypeH);
    }

    public IniFile getConfigFile() throws Exception {
        IniFile iniFile = new IniFile();
        IniFile.Section section = iniFile.getSection("General");
        section.setValue(SetupItemException48.NAME, this.getException48());
        String[] header = this.getHeader();
        int index = 0;
        while (index < header.length) {
            section.setValue(String.valueOf(SetupItemHeader.NAME) + index, header[index]);
            ++index;
        }
        section = iniFile.getSection("Chdu");
        section.setValue(SetupItemChduConnectionString.NAME, this.getChduConnectionString());
        String[] chduConnectionStringAlt = this.getChduConnectionStringAlt();
        int index2 = 0;
        while (index2 < chduConnectionStringAlt.length) {
            section.setValue(String.valueOf(SetupItemChduConnectionStringAlt.NAME) + index2, chduConnectionStringAlt[index2]);
            ++index2;
        }
        section.setValue(SetupItemPrinterOther.NAME, this.getPrinterOther());
        section.setValue(SetupItemPrinterBaudrate.NAME, this.getPrinterBaudrate());
        section.setValue(SetupItemPrinterType.NAME, this.getPrinterType());
        section.setValue(String.valueOf(SetupItemDisplay.NAME) + "1", this.getDisplay1().getConnectionString());
        section.setValue(String.valueOf(SetupItemDisplay.NAME) + "2", this.getDisplay2().getConnectionString());
        section = iniFile.getSection("Vat");
        section.setValue(String.valueOf(SetupItemVat.NAME) + "A", String.valueOf(VAT_TYPE.getValue(this.getVatTypeA())) + ":" + (this.getVatA() == null ? "-" : this.getVatA()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "B", String.valueOf(VAT_TYPE.getValue(this.getVatTypeB())) + ":" + (this.getVatB() == null ? "-" : this.getVatB()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "C", String.valueOf(VAT_TYPE.getValue(this.getVatTypeC())) + ":" + (this.getVatC() == null ? "-" : this.getVatC()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "D", String.valueOf(VAT_TYPE.getValue(this.getVatTypeD())) + ":" + (this.getVatD() == null ? "-" : this.getVatD()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "E", String.valueOf(VAT_TYPE.getValue(this.getVatTypeE())) + ":" + (this.getVatE() == null ? "-" : this.getVatE()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "F", String.valueOf(VAT_TYPE.getValue(this.getVatTypeF())) + ":" + (this.getVatF() == null ? "-" : this.getVatF()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "G", String.valueOf(VAT_TYPE.getValue(this.getVatTypeG())) + ":" + (this.getVatG() == null ? "-" : this.getVatG()));
        section.setValue(String.valueOf(SetupItemVat.NAME) + "H", String.valueOf(VAT_TYPE.getValue(this.getVatTypeH())) + ":" + (this.getVatH() == null ? "-" : this.getVatH()));
        return iniFile;
    }

    public static PPEKKConfiguration getInstance(IniFile cfgFile) throws EKasaException {
        try {
            PPEKKConfiguration setup = new PPEKKConfiguration();
            IniFile.Section section = cfgFile.getSection("General");
            setup.exception48 = section.getBoolean(SetupItemException48.NAME);
            int index = 0;
            while (index < setup.header.length) {
                setup.header[index] = section.getString(String.valueOf(SetupItemHeader.NAME) + index);
                ++index;
            }
            section = cfgFile.getSection("Chdu");
            setup.chduConnectionString = section.getString(SetupItemChduConnectionString.NAME);
            index = 0;
            while (index < setup.chduConnectionStringAlt.length) {
                setup.chduConnectionStringAlt[index] = section.getString(String.valueOf(SetupItemChduConnectionStringAlt.NAME) + index);
                ++index;
            }
            setup.printerOther = section.getString(SetupItemPrinterOther.NAME);
            setup.printerBaudrate = section.getInteger(SetupItemPrinterBaudrate.NAME);
            setup.printerType = section.getString(SetupItemPrinterType.NAME);
            Display display = new Display();
            display.setConnectionString(section.getString(String.valueOf(SetupItemDisplay.NAME) + "1"));
            setup.display1 = display;
            display = new Display();
            display.setConnectionString(section.getString(String.valueOf(SetupItemDisplay.NAME) + "2"));
            setup.display2 = display;
            section = cfgFile.getSection("Vat");
            String[] vat = section.getString(String.valueOf(SetupItemVat.NAME) + "A").split(":");
            setup.vatA = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeA = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "B").split(":");
            setup.vatB = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeB = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "C").split(":");
            setup.vatC = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeC = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "D").split(":");
            setup.vatD = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeD = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "E").split(":");
            setup.vatE = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeE = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "F").split(":");
            setup.vatF = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeF = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "G").split(":");
            setup.vatG = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeG = VAT_TYPE.getVatType(vat[0]);
            vat = section.getString(String.valueOf(SetupItemVat.NAME) + "H").split(":");
            setup.vatH = vat[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(vat[1]));
            setup.vatTypeH = VAT_TYPE.getVatType(vat[0]);
            return setup;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public static PPEKKConfiguration getInstance(String chduConnectionString, String[] chduConnectionStringAlt, String printerType, String printerOther, Integer printerBaudrate, String[] header, Display display1, Display display2, Integer vatA, VAT_TYPE vatTypeA, Integer vatB, VAT_TYPE vatTypeB, Integer vatC, VAT_TYPE vatTypeC, Integer vatD, VAT_TYPE vatTypeE, Integer vatE, VAT_TYPE vatTypeD, Integer vatF, VAT_TYPE vatTypeF, Integer vatG, VAT_TYPE vatTypeG, Integer vatH, VAT_TYPE vatTypeH, boolean exception48) {
        PPEKKConfiguration setup = new PPEKKConfiguration();
        setup.chduConnectionString = chduConnectionString;
        int i = 0;
        while (i < chduConnectionStringAlt.length) {
            setup.chduConnectionStringAlt[i] = i < chduConnectionStringAlt.length ? chduConnectionStringAlt[i] : null;
            ++i;
        }
        setup.display1 = display1;
        setup.display2 = display2;
        setup.printerType = printerType;
        setup.printerOther = printerOther;
        setup.printerBaudrate = printerBaudrate;
        i = 0;
        while (i < header.length) {
            setup.header[i] = i < header.length ? header[i] : null;
            ++i;
        }
        setup.vatA = vatA;
        setup.vatTypeA = vatTypeA;
        setup.vatB = vatB;
        setup.vatTypeB = vatTypeB;
        setup.vatC = vatC;
        setup.vatTypeC = vatTypeC;
        setup.vatD = vatD;
        setup.vatTypeD = vatTypeD;
        setup.vatE = vatE;
        setup.vatTypeE = vatTypeE;
        setup.vatF = vatF;
        setup.vatTypeF = vatTypeF;
        setup.vatG = vatG;
        setup.vatTypeG = vatTypeG;
        setup.vatH = vatH;
        setup.vatTypeH = vatTypeH;
        setup.exception48 = exception48;
        return setup;
    }

    public static PPEKKConfiguration getInstance(PPEKKConfiguration cfg, String chduConnectionString) {
        PPEKKConfiguration setup = new PPEKKConfiguration();
        setup.chduConnectionString = chduConnectionString;
        int i = 0;
        while (i < setup.chduConnectionStringAlt.length) {
            setup.chduConnectionStringAlt[i] = i < setup.chduConnectionStringAlt.length ? cfg.chduConnectionStringAlt[i] : null;
            ++i;
        }
        setup.display1 = cfg.display1;
        setup.display2 = cfg.display2;
        setup.printerType = cfg.printerType;
        setup.printerOther = cfg.printerOther;
        setup.printerBaudrate = cfg.printerBaudrate;
        i = 0;
        while (i < setup.header.length) {
            setup.header[i] = i < setup.header.length ? cfg.header[i] : null;
            ++i;
        }
        setup.vatA = cfg.vatA;
        setup.vatTypeA = cfg.vatTypeA;
        setup.vatB = cfg.vatB;
        setup.vatTypeB = cfg.vatTypeB;
        setup.vatC = cfg.vatC;
        setup.vatTypeC = cfg.vatTypeC;
        setup.vatD = cfg.vatD;
        setup.vatTypeD = cfg.vatTypeD;
        setup.vatE = cfg.vatE;
        setup.vatTypeE = cfg.vatTypeE;
        setup.vatF = cfg.vatF;
        setup.vatTypeF = cfg.vatTypeF;
        setup.vatG = cfg.vatG;
        setup.vatTypeG = cfg.vatTypeG;
        setup.vatH = cfg.vatH;
        setup.vatTypeH = cfg.vatTypeH;
        setup.exception48 = cfg.exception48;
        return setup;
    }

    public static PPEKKConfiguration getInstance(PPEKKConfiguration cfg, SetupItemInterface setupItem) {
        PPEKKConfiguration setup = new PPEKKConfiguration();
        setup.chduConnectionString = cfg.chduConnectionString;
        int i = 0;
        while (i < setup.chduConnectionStringAlt.length) {
            setup.chduConnectionStringAlt[i] = i < setup.chduConnectionStringAlt.length ? cfg.chduConnectionStringAlt[i] : null;
            ++i;
        }
        setup.display1 = cfg.display1;
        setup.display2 = cfg.display2;
        setup.printerType = cfg.printerType;
        setup.printerOther = cfg.printerOther;
        setup.printerBaudrate = cfg.printerBaudrate;
        i = 0;
        while (i < setup.header.length) {
            setup.header[i] = i < setup.header.length ? cfg.header[i] : null;
            ++i;
        }
        setup.vatA = cfg.vatA;
        setup.vatTypeA = cfg.vatTypeA;
        setup.vatB = cfg.vatB;
        setup.vatTypeB = cfg.vatTypeB;
        setup.vatC = cfg.vatC;
        setup.vatTypeC = cfg.vatTypeC;
        setup.vatD = cfg.vatD;
        setup.vatTypeD = cfg.vatTypeD;
        setup.vatE = cfg.vatE;
        setup.vatTypeE = cfg.vatTypeE;
        setup.vatF = cfg.vatF;
        setup.vatTypeF = cfg.vatTypeF;
        setup.vatG = cfg.vatG;
        setup.vatTypeG = cfg.vatTypeG;
        setup.vatH = cfg.vatH;
        setup.vatTypeH = cfg.vatTypeH;
        setup.exception48 = cfg.exception48;
        if (setupItem instanceof SetupItemChduConnectionString) {
            setup.chduConnectionString = ((SetupItemChduConnectionString)setupItem).getConnectionString();
        } else if (setupItem instanceof SetupItemChduConnectionStringAlt) {
            SetupItemChduConnectionStringAlt item = (SetupItemChduConnectionStringAlt)setupItem;
            int i2 = 0;
            while (i2 < setup.chduConnectionStringAlt.length) {
                if (item.getDbName().equals(String.valueOf(SetupItemChduConnectionStringAlt.NAME) + "1")) {
                    setup.chduConnectionStringAlt[i2] = item.getConnectionString();
                }
                ++i2;
            }
        } else if (setupItem instanceof SetupItemDisplay) {
            SetupItemDisplay item = (SetupItemDisplay)setupItem;
            if (item.getDbName().equals(String.valueOf(SetupItemDisplay.NAME) + "1")) {
                setup.display1 = item.getDisplay();
            } else if (item.getDbName().equals(String.valueOf(SetupItemDisplay.NAME) + "2")) {
                setup.display2 = item.getDisplay();
            }
        } else if (setupItem instanceof SetupItemException48) {
            SetupItemException48 item = (SetupItemException48)setupItem;
            setup.exception48 = item.getException48();
        } else if (setupItem instanceof SetupItemHeader) {
            SetupItemHeader item = (SetupItemHeader)setupItem;
            int i3 = 0;
            while (i3 < setup.header.length) {
                if (item.getDbName().equals(String.valueOf(SetupItemHeader.NAME) + i3)) {
                    setup.header[i3] = item.getHeader();
                }
                ++i3;
            }
        } else if (setupItem instanceof SetupItemPrinterBaudrate) {
            SetupItemPrinterBaudrate item = (SetupItemPrinterBaudrate)setupItem;
            setup.printerBaudrate = item.getBaudrate();
        } else if (setupItem instanceof SetupItemPrinterOther) {
            SetupItemPrinterOther item = (SetupItemPrinterOther)setupItem;
            setup.printerOther = item.getPrinterOther();
        } else if (setupItem instanceof SetupItemPrinterType) {
            SetupItemPrinterType item = (SetupItemPrinterType)setupItem;
            setup.printerType = item.getPrinterType();
        } else if (setupItem instanceof SetupItemVat) {
            SetupItemVat item = (SetupItemVat)setupItem;
            if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "A")) {
                setup.vatA = item.getVat();
                setup.vatTypeA = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "B")) {
                setup.vatB = item.getVat();
                setup.vatTypeB = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "C")) {
                setup.vatC = item.getVat();
                setup.vatTypeC = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "D")) {
                setup.vatD = item.getVat();
                setup.vatTypeD = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "E")) {
                setup.vatE = item.getVat();
                setup.vatTypeE = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "F")) {
                setup.vatF = item.getVat();
                setup.vatTypeF = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "G")) {
                setup.vatG = item.getVat();
                setup.vatTypeG = item.getVatType();
            } else if (item.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "H")) {
                setup.vatH = item.getVat();
                setup.vatTypeH = item.getVatType();
            }
        }
        return setup;
    }
}

