/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.setup.SetupItemIdentityData;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.utils.Base64;
import sk.singularisdev.ekasask.utils.ChduSerialize;
import sk.singularisdev.ekasask.utils.IniFile;
import sk.singularisdev.ekasask.utils.Utility;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public class PPEKKIdentity {
    private static final Logger logger = LoggerManager.getLogger(PPEKKIdentity.class.getName());
    private Cipher cipherEncrypt;
    private Cipher cipherDecrypt;
    private Base64 base64Encoder = new Base64();
    private String identityData;
    private IdentityData identity;

    private PPEKKIdentity() {
        try {
            SecretKeySpec secretKey = new SecretKeySpec("P@ssw0rdP@ssw0rd".getBytes(), "AES");
            this.cipherEncrypt = Cipher.getInstance("AES");
            this.cipherEncrypt.init(1, secretKey);
            this.cipherDecrypt = Cipher.getInstance("AES");
            this.cipherDecrypt.init(2, secretKey);
        }
        catch (Exception e) {
            this.cipherEncrypt = null;
            this.cipherDecrypt = null;
            logger.debug("PPEKKIdentity.PPEKKIdentity", e);
        }
    }

    public String getIdentityData() {
        return this.identityData;
    }

    public IdentityData getIdentity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PPEKKIdentity setup = (PPEKKIdentity)o;
        return Utility.equals(this.identityData, setup.identityData);
    }

    public ChduSerialize getChduFile() throws Exception {
        String identityData = this.getIdentityData();
        ChduSerialize iniFile = new ChduSerialize("UTF-8");
        iniFile.setValue(SetupItemIdentityData.NAME, identityData);
        logger.debug("INI file content [PPEKKIdentity.getIdentFile()]");
        logger.debug(new String(iniFile.getContent(), "UTF-8"));
        return iniFile;
    }

    public static PPEKKIdentity getInstance(ChduSerialize identFile) throws EKasaException {
        try {
            PPEKKIdentity setup = new PPEKKIdentity();
            String identityData = identFile.getString(SetupItemIdentityData.NAME);
            if (identityData == null) {
                setup.identityData = null;
                setup.identity = null;
            } else {
                setup.identityData = identityData;
                setup.identity = new IdentityData(setup.identityData);
                if (!setup.identity.parse()) {
                    setup.identity = null;
                }
            }
            return setup;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public IniFile getIdentFile() throws Exception {
        String identityData = this.getIdentityData();
        IniFile iniFile = new IniFile();
        IniFile.Section section = iniFile.getSection("IdentityData");
        if (identityData != null) {
            byte[] data = identityData.getBytes("UTF-8");
            identityData = this.base64Encoder.encode(this.cipherEncrypt.doFinal(data));
        }
        section.setValue(SetupItemIdentityData.NAME, identityData);
        logger.debug("INI file content [PPEKKIdentity.getIdentFile()]");
        logger.debug(iniFile.getContent());
        return iniFile;
    }

    public static PPEKKIdentity getInstance(IniFile identFile) throws EKasaException {
        try {
            PPEKKIdentity setup = new PPEKKIdentity();
            IniFile.Section section = identFile.getSection("IdentityData");
            String identityData = section.getString(SetupItemIdentityData.NAME);
            if (identityData == null) {
                setup.identityData = null;
                setup.identity = null;
            } else {
                byte[] data = Base64.toBytes(identityData);
                data = setup.cipherDecrypt.doFinal(data);
                setup.identityData = new String(data, "UTF8");
                setup.identity = new IdentityData(setup.identityData);
                if (!setup.identity.parse()) {
                    setup.identity = null;
                }
            }
            return setup;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public static PPEKKIdentity getInstance(PPEKKIdentity ident, SetupItemInterface setupItem) {
        PPEKKIdentity setup = new PPEKKIdentity();
        setup.identityData = ident.identityData;
        setup.identity = ident.identity;
        if (setupItem instanceof SetupItemIdentityData) {
            SetupItemIdentityData item = (SetupItemIdentityData)setupItem;
            setup.identityData = item.getIdentityData();
            setup.identity = new IdentityData(setup.identityData);
            if (!setup.identity.parse()) {
                setup.identity = null;
            }
        }
        return setup;
    }

    public static PPEKKIdentity getInstance(String identityData) {
        PPEKKIdentity setup = new PPEKKIdentity();
        setup.identityData = identityData;
        setup.identity = new IdentityData(identityData);
        if (!setup.identity.parse()) {
            setup.identity = null;
        }
        return setup;
    }

    public boolean isEmpty() {
        return this.identityData == null || this.identityData.equals("");
    }
}

