/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sk.singularisdev.chdu.Chdu;
import sk.singularisdev.chdu.ChduFactory;
import sk.singularisdev.chdu.error.ErrorCode;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.chdu.parameter.EscSequence;
import sk.singularisdev.chdu.parameter.Others;
import sk.singularisdev.chdu.parameter.Polling;
import sk.singularisdev.chdu.parameter.SyncAndInfo;
import sk.singularisdev.chdu.parameter.Transaction;
import sk.singularisdev.chdu.result.ReadResult;
import sk.singularisdev.chdu.result.WriteResult;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.command.CommandException;
import sk.singularisdev.cryptoprotocol.layers.SessionLayer;
import sk.singularisdev.cryptoprotocol.layers.TransportLayer;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.PPEKKAuthentication;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKIdentity;
import sk.singularisdev.ekasask.chdu.CHDUListener;
import sk.singularisdev.ekasask.chdu.ChduTransaction;
import sk.singularisdev.ekasask.chdu.ConnectionInfo;
import sk.singularisdev.ekasask.chdu.DisplayData;
import sk.singularisdev.ekasask.chdu.DriveInfo;
import sk.singularisdev.ekasask.chdu.SfsDataInfo;
import sk.singularisdev.ekasask.chdu.SfsDataRequest;
import sk.singularisdev.ekasask.chdu.SfsDataResponse;
import sk.singularisdev.ekasask.chdu.StorageInfo;
import sk.singularisdev.ekasask.chdu.Upgrade;
import sk.singularisdev.ekasask.db.TransactionInfo;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.db.TransactionStatusChain;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.utils.ChduSerialize;
import sk.singularisdev.ekasask.utils.IniFile;
import sk.singularisdev.platform.keyloader.KeyLoader;

public final class CHDU {
    private static final Logger logger = LoggerManager.getLogger(CHDU.class.getName());
    private UUID uuid;
    private PPEKK ppekk;
    private CHDUListener chduListener;
    private String chduType = null;
    private String chduVersion = null;
    private String chduRelease = null;
    private String chduSN = null;
    private boolean cleanChdu;
    private ConnectionState connectionState;
    private ConnectionInfo connectionInfo;
    private TransportLayerListener transportLayerListener;
    private RttStatusChangedListener rttStatusChangedListener;
    private AutoConnectionScheduler autoConnectionScheduler;
    private Transaction.ID transactionID;
    private Chdu chdu;
    private AtomicLong communicationTimestamp;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private CHDU(PPEKK ppekk, UUID uuid, CHDUListener chduListener) throws ChduException {
        this.ppekk = ppekk;
        this.uuid = uuid;
        this.chduListener = chduListener;
        this.transactionID = new Transaction.ID(0, 0, new TransactionIDListener());
        ChduFactory.enableKeepAlive(Configuration.isChduKeepaliveEnabled());
        ChduFactory.setIdentification("eKasaSK1 2", "CHDUA1 2");
        ChduFactory.setPacketSize(Configuration.getChduPacketSize());
        ChduFactory.setTimeout(Configuration.getChduCommunicationTimeout());
        ChduFactory.setKeyloader(new KeyLoader());
        ChduFactory.setSessionLayerListener(new ConnectionStatusChangedListener());
        this.connectionInfo = new ConnectionInfo();
        this.transportLayerListener = new TransportLayerListener(this.connectionInfo);
        ChduFactory.setTransportLayerListener(this.transportLayerListener);
        this.rttStatusChangedListener = new RttStatusChangedListener(this.connectionInfo);
        ChduFactory.setRttListener(this.rttStatusChangedListener);
        this.connectionState = ConnectionState.Created;
        this.communicationTimestamp = new AtomicLong();
        this.autoConnectionScheduler = new AutoConnectionScheduler();
    }

    public static CHDU getInstance(PPEKK ppekk, UUID uuid, CHDUListener chduListener) throws EKasaException {
        try {
            return new CHDU(ppekk, uuid, chduListener);
        }
        catch (Exception e) {
            throw new EKasaException(3L, (Throwable)e);
        }
    }

    public void connect() throws EKasaException {
        try {
            while (this.autoConnectionScheduler.isAutoConnectionRunning.get()) {
                this.sleep(10);
            }
            if (this.connectionState == ConnectionState.Connected || this.chdu != null && this.chdu.isConnected()) {
                return;
            }
            if (this.connectionState != ConnectionState.Connected) {
                boolean success;
                this.autoConnectionScheduler.stopScheduler();
                String connectionString = this.ppekk.getConfiguration(this.uuid).getConfiguration().getChduConnectionString();
                String secondaryConnectionString = "";
                if (this.ppekk.getConfiguration(this.uuid).getConfiguration().getChduConnectionStringAlt() != null && this.ppekk.getConfiguration(this.uuid).getConfiguration().getChduConnectionStringAlt().length > 0) {
                    secondaryConnectionString = this.ppekk.getConfiguration(this.uuid).getConfiguration().getChduConnectionStringAlt()[0];
                }
                if (connectionString == null || connectionString.isEmpty()) {
                    this.connectionState = ConnectionState.Disconnected;
                    throw new EKasaException(7L);
                }
                this.transportLayerListener.reset();
                ChduException chduEx = null;
                try {
                    Chdu _chdu = ChduFactory.createInstance(connectionString, secondaryConnectionString);
                    this.connectToChdu(_chdu);
                    success = true;
                }
                catch (ChduException e) {
                    success = false;
                    chduEx = e;
                }
                if (!success && connectionString.toLowerCase().contains("rs232")) {
                    String[] split = connectionString.split(":");
                    String originalSpeed = split[2];
                    StringBuilder newConnectionString = new StringBuilder();
                    for (int speed : Configuration.comPortSpeeds) {
                        split[2] = Integer.toString(speed);
                        if (originalSpeed.equalsIgnoreCase(split[2])) continue;
                        newConnectionString = new StringBuilder();
                        String[] stringArray = split;
                        int n = split.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            newConnectionString.append(s).append(":");
                            ++n2;
                        }
                        newConnectionString = new StringBuilder(newConnectionString.substring(0, newConnectionString.length() - 1));
                        try {
                            Chdu _chdu = ChduFactory.createInstance(newConnectionString.toString(), secondaryConnectionString);
                            if (!this.connectToChdu(_chdu)) break;
                            success = true;
                            break;
                        }
                        catch (ChduException ex) {
                            chduEx = ex;
                        }
                    }
                    if (success && newConnectionString.length() > 0) {
                        this.chduListener.onChduDiscovered(newConnectionString.toString());
                    }
                }
                if (!success) {
                    throw chduEx;
                }
            }
            this.initChdu();
        }
        catch (EKasaException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(7L, (Throwable)e);
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(7L, (Throwable)e);
        }
    }

    public void disconnect() {
        this.connectionState = ConnectionState.Disconnected;
        if (this.autoConnectionScheduler != null) {
            this.autoConnectionScheduler.stopScheduler();
        }
        if (this.chdu != null) {
            this.chdu.disconnect();
            this.chdu = null;
        }
    }

    public boolean isConnected() {
        return this.connectionState == ConnectionState.Connected;
    }

    public synchronized String generTransactionId() throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        this.transactionID.increment();
        return this.transactionID.format();
    }

    public synchronized String getLastTransactionId() throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        return this.transactionID.format();
    }

    public boolean isPrinterReady() throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
        try {
            WriteResult writeResult = this.chdu.poll(Polling.Type.State, new Date());
            return writeResult.isOK();
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
        catch (Exception e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
    }

    public boolean interrupt() throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        if (!this.isPrinterReady()) {
            try {
                WriteResult writeResult = this.chdu.poll(Polling.Type.CancelProcess, new Date());
                return writeResult.isOK();
            }
            catch (Exception e) {
                this.connectionState = ConnectionState.Disconnected;
                return false;
            }
        }
        return false;
    }

    public void setDisplay(DISPLAY_NUMBER displayNumber, List<DisplayData> data) throws EKasaException {
        Others.Write type;
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (DisplayData item : data) {
            byte[] byteArrau = item.toByteArray();
            baos.write(byteArrau, 0, byteArrau.length);
        }
        switch (displayNumber) {
            case EXTERNAL: {
                type = Others.Write.Display2;
                break;
            }
            case INTERNAL: {
                type = Others.Write.Display1;
                break;
            }
            default: {
                throw new EKasaException(24L);
            }
        }
        try {
            this.chdu.writeOthers(type, new Date(), new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
    }

    public byte[] setEsc(byte[] esc, int byteAnswer) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.chdu.writeEscapeSequence(new EscSequence.Type("U"), this.transactionID, byteAnswer, new ByteArrayInputStream(esc), output);
            return output.toByteArray();
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
    }

    public synchronized void setChduTransaction(ChduTransaction transaction) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        switch (transaction.getType()) {
            case LPT: {
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(transaction.getData());
                    this.chdu.writeTransaction(new Transaction.Type("LPT"), new Date(), this.transactionID, inputStream);
                    while (!this.isPrinterReady()) {
                        this.sleep(100);
                    }
                    break;
                }
                catch (ChduException e) {
                    this.connectionState = ConnectionState.Disconnected;
                    throw new EKasaException(43L);
                }
            }
            case SFS_REQUEST: {
                try {
                    this.chdu.writeTransaction(new Transaction.Type("SFS_REQUEST"), new Date(), this.transactionID, new ByteArrayInputStream(transaction.getData()));
                    while (!this.isPrinterReady()) {
                        this.sleep(100);
                    }
                    break;
                }
                catch (ChduException e) {
                    this.connectionState = ConnectionState.Disconnected;
                    throw new EKasaException(43L);
                }
            }
            case SFS_RESPONSE: {
                try {
                    this.chdu.writeTransaction(new Transaction.Type("SFS_RESPONSE"), new Date(), this.transactionID, new ByteArrayInputStream(transaction.getData()));
                    while (!this.isPrinterReady()) {
                        this.sleep(100);
                    }
                    break;
                }
                catch (ChduException e) {
                    this.connectionState = ConnectionState.Disconnected;
                    throw new EKasaException(43L);
                }
            }
            case SFS_STATUS: {
                try {
                    this.chdu.writeTransaction(new Transaction.Type("SFS_STATUS"), new Date(), this.transactionID, new ByteArrayInputStream(transaction.getData()));
                    while (!this.isPrinterReady()) {
                        this.sleep(100);
                    }
                    break;
                }
                catch (ChduException e) {
                    this.connectionState = ConnectionState.Disconnected;
                    throw new EKasaException(43L);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChduTransaction getChduTransaction(ChduTransaction.TRANSACTION_TYPE type, String transactionId) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            ReadResult readResult;
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            switch (type) {
                case SFS_REQUEST: {
                    readResult = this.chdu.readTransaction(new Transaction.Type("SFS_REQUEST"), new Transaction.ID(transactionId), ous);
                    break;
                }
                case SFS_RESPONSE: {
                    readResult = this.chdu.readTransaction(new Transaction.Type("SFS_RESPONSE"), new Transaction.ID(transactionId), ous);
                    break;
                }
                case SFS_STATUS: {
                    readResult = this.chdu.readTransaction(new Transaction.Type("SFS_STATUS"), new Transaction.ID(transactionId), ous);
                    break;
                }
                case LPT: {
                    readResult = this.chdu.readTransaction(new Transaction.Type("LPT"), new Transaction.ID(transactionId), ous);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (readResult.isOK()) {
                return new ChduTransaction(type, transactionId, ous.toByteArray());
            }
            if (readResult.getErrorCode() == 21 && readResult.getErrorSubCode() == ErrorCode.Code.RequestedTransactionDoesNotExists) {
                return null;
            }
            throw new EKasaException(9L);
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public SfsDataRequest getSfsRequest(String transactionId) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            ChduTransaction transaction = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId);
            return new SfsDataRequest(transaction.getData());
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(24L, (Throwable)e);
        }
    }

    public SfsDataResponse getSfsResponse(String transactionId) throws EKasaException {
        try {
            ChduTransaction transaction = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId);
            return new SfsDataResponse(transaction.getData());
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(24L, (Throwable)e);
        }
    }

    public synchronized void setIndex(String content) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF8"));
            this.chdu.writeOthers(Others.Write.Indices, new Date(), is);
            ((InputStream)is).close();
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public String getIndex() throws EKasaException {
        block6: {
            if (!this.chdu.isConnected()) {
                this.connectionState = ConnectionState.Disconnected;
                throw new EKasaException(41L);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ReadResult readResult = this.chdu.readOthers(Others.Read.Indices, new Date(), baos);
            if (readResult.isOK()) {
                return new String(baos.toByteArray(), "UTF8");
            }
            if (readResult.getErrorCode() != 21 || readResult.getErrorSubCode() != ErrorCode.Code.RequestedTransactionDoesNotExists) break block6;
            return null;
        }
        try {
            throw new EKasaException(9L);
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void saveConfiguration(PPEKKConfiguration configuration, PPEKKAuthentication auth, PPEKKIdentity ident) throws EKasaException {
        this.saveCfg(configuration);
        this.saveAuth(auth);
        this.saveIdent(ident);
    }

    public void upgrade(InputStream upgradeInputStream) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        Upgrade upgrade = new Upgrade(upgradeInputStream);
        try {
            upgrade.decode();
        }
        catch (IOException e) {
            throw new EKasaException(45L);
        }
        InputStream signInputStream = upgrade.createSignInputStream();
        InputStream firmwareInputStream = upgrade.createFirmwareInputStream();
        try {
            WriteResult upgradeReult = this.chdu.writeOthers(Others.Write.Upgrade, new Date(), signInputStream, firmwareInputStream);
            if (!upgradeReult.isOK()) {
                throw new EKasaException(45L);
            }
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(43L);
        }
    }

    public void saveCfg(PPEKKConfiguration configuration) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            IniFile iniFile = configuration.getConfigFile();
            String content = iniFile.getContent();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF8"));
            this.chdu.writeOthers(Others.Write.Configuration, new Date(), is);
            ((InputStream)is).close();
            long tsStart = System.currentTimeMillis();
            while (!this.isPrinterReady()) {
                this.sleep(100);
                if (tsStart + 30000L >= System.currentTimeMillis()) continue;
                this.chdu.poll(Polling.Type.CancelProcess, new Date());
                throw new EKasaException(44L);
            }
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (Exception e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public PPEKKConfiguration loadCfg() throws EKasaException {
        try {
            this.cleanChdu = false;
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            ReadResult readResult = this.chdu.readOthers(Others.Read.Configuration, ous);
            IniFile cfgIniFile = new IniFile();
            if (readResult.isOK()) {
                cfgIniFile.setContent(new String(ous.toByteArray(), "UTF8"));
            } else if (readResult.getErrorCode() == 21 && readResult.getErrorSubCode() == ErrorCode.Code.RequestedTransactionDoesNotExists) {
                this.cleanChdu = true;
            } else {
                throw new EKasaException(9L);
            }
            PPEKKConfiguration configuration = PPEKKConfiguration.getInstance(cfgIniFile);
            return configuration;
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public PPEKKIdentity loadIdent() throws EKasaException {
        ChduSerialize identIniFile;
        block10: {
            this.cleanChdu = false;
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            identIniFile = new ChduSerialize("UTF-8");
            ous.reset();
            ReadResult readResult = this.chdu.readOthers(Others.Read.UserIdentificationData, ous);
            if (readResult.isOK()) {
                identIniFile.setContent(ous.toByteArray());
            } else if (readResult.getErrorCode() == 21 && readResult.getErrorSubCode() == ErrorCode.Code.RequestedTransactionDoesNotExists) {
                this.cleanChdu = true;
            } else {
                throw new EKasaException(9L);
            }
            if (!this.cleanChdu || this.isConnected()) break block10;
            return null;
        }
        try {
            if (this.cleanChdu && this.isConnected()) {
                throw new EKasaException(9L);
            }
            PPEKKIdentity identity = PPEKKIdentity.getInstance(identIniFile);
            return identity;
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L, (Throwable)e);
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public PPEKKAuthentication loadAuth() throws EKasaException {
        ChduSerialize authIniFile;
        block10: {
            this.cleanChdu = false;
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            authIniFile = new ChduSerialize("UTF-8");
            ous.reset();
            ReadResult readResult = this.chdu.readOthers(Others.Read.SFS_Keys, ous);
            if (readResult.isOK()) {
                authIniFile.setContent(ous.toByteArray());
            } else if (readResult.getErrorCode() == 21 && readResult.getErrorSubCode() == ErrorCode.Code.RequestedTransactionDoesNotExists) {
                this.cleanChdu = true;
            } else {
                throw new EKasaException(9L);
            }
            if (!this.cleanChdu || this.isConnected()) break block10;
            return null;
        }
        try {
            if (this.cleanChdu && this.isConnected()) {
                throw new EKasaException(9L);
            }
            PPEKKAuthentication auth = PPEKKAuthentication.getInstance(authIniFile);
            return auth;
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(21L, (Throwable)e);
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public void saveAuth(PPEKKAuthentication configuration) throws EKasaException {
        if (!this.chdu.isConnected()) {
            throw new EKasaException(41L);
        }
        try {
            ChduSerialize iniFile = configuration.getChduFile();
            ByteArrayInputStream is = new ByteArrayInputStream(iniFile.getContent());
            this.chdu.writeOthers(Others.Write.SFS_Keys, new Date(), is);
            ((InputStream)is).close();
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(21L, (Throwable)e);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void saveIdent(PPEKKIdentity configuration) throws EKasaException {
        if (!this.chdu.isConnected()) {
            throw new EKasaException(41L);
        }
        try {
            ChduSerialize iniFile = configuration.getChduFile();
            ByteArrayInputStream is = new ByteArrayInputStream(iniFile.getContent());
            this.chdu.writeOthers(Others.Write.UserIdentificationData, new Date(), is);
            ((InputStream)is).close();
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(21L, (Throwable)e);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public String getProductName() {
        return this.chduType;
    }

    public String getProductVersion() {
        return this.chduVersion;
    }

    public String getProductRelease() {
        return this.chduRelease;
    }

    public String getSN() {
        return this.chduSN;
    }

    public DriveInfo getDriveInfo(DriveInfo.DRIVE_TYPE storageType) throws EKasaException {
        if (!this.chdu.isConnected()) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(41L);
        }
        try {
            SyncAndInfo syncAndInfo = this.getInfo();
            SyncAndInfo.Drive drive = null;
            switch (storageType) {
                case DATA_STORAGE: {
                    drive = syncAndInfo.getDriveC();
                    break;
                }
                case INTERNAL_STORAGE: {
                    drive = syncAndInfo.getDriveD();
                    break;
                }
                case KEY_STORAGE: {
                    drive = syncAndInfo.getDriveE();
                }
            }
            return new DriveInfo(storageType, drive.getSize(), drive.getFree());
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L);
        }
        catch (EKasaException e) {
            throw e;
        }
    }

    public StorageInfo getStorageInfo() throws EKasaException {
        if (!this.chdu.isConnected()) {
            throw new EKasaException(41L);
        }
        try {
            SyncAndInfo syncAndInfo = this.getInfo();
            DriveInfo dataStorage = new DriveInfo(DriveInfo.DRIVE_TYPE.DATA_STORAGE, syncAndInfo.getDriveC().getSize(), syncAndInfo.getDriveC().getFree());
            DriveInfo keyStorage = new DriveInfo(DriveInfo.DRIVE_TYPE.KEY_STORAGE, syncAndInfo.getDriveD().getSize(), syncAndInfo.getDriveD().getFree());
            DriveInfo internalStorage = new DriveInfo(DriveInfo.DRIVE_TYPE.INTERNAL_STORAGE, syncAndInfo.getDriveE().getSize(), syncAndInfo.getDriveE().getFree());
            return new StorageInfo(syncAndInfo.getStorageSize(), syncAndInfo.getSectorCount(), syncAndInfo.getSectorSize(), dataStorage, keyStorage, internalStorage);
        }
        catch (ChduException e) {
            this.connectionState = ConnectionState.Disconnected;
            throw new EKasaException(9L);
        }
        catch (EKasaException e) {
            throw e;
        }
    }

    private SyncAndInfo getInfo() throws ChduException, EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ReadResult readResult = this.chdu.readOthers(Others.Read.SyncAndInfoData, new Date(), baos);
        if (readResult.isOK()) {
            try {
                return SyncAndInfo.CreateInstance(baos.toByteArray());
            }
            catch (CommandException e) {
                throw new EKasaException(9L);
            }
        }
        throw new EKasaException(9L);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public static boolean isLicensed(String sn) {
        return sn.length() != 8;
    }

    public TransactionInfo getTransactionInfo(String transactionId) throws EKasaException {
        try {
            String chduSn = this.chduSN;
            if (chduSn == null) {
                logger.info("CHDU.getTransactionInfo - NO CHDU SN");
            } else {
                ChduTransaction info = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_STATUS, transactionId);
                if (info == null) {
                    ChduTransaction request = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId);
                    if (request != null) {
                        ChduTransaction response = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId);
                        SfsDataRequest sfsRequest = new SfsDataRequest(request.getData());
                        if (response != null) {
                            SfsDataResponse sfsResponse = new SfsDataResponse(response.getData());
                            TransactionStatus tStatus = new TransactionStatus(this.chduSN, sfsRequest.getRequestType(), sfsRequest.getRequest(), sfsRequest.getMessageUuid(), transactionId, sfsResponse.getStatus(), sfsRequest.getOriginTransactionId() == null ? transactionId : sfsRequest.getOriginTransactionId(), sfsRequest.getRetryTransactionId(), null, sfsResponse.getQrCode(), sfsRequest.getParagonCopyPrint(), sfsRequest.getUnsendReport(), sfsRequest.getCreateDate(), sfsRequest.getReceiptNumber(), sfsRequest.getRetryCounter());
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
                            String pcd = String.valueOf(sdf.format(sfsRequest.getCreateDate())) + "/" + sfsRequest.getReceiptNumber();
                            TransactionInfo tInfo = new TransactionInfo(false, transactionId, sfsResponse.getStatus(), sfsRequest.getRetryTransactionId(), sfsRequest.getRequestType().getShortage(), pcd, tStatus);
                            return tInfo;
                        }
                    }
                } else {
                    SfsDataInfo dataInfo = new SfsDataInfo(info.getData());
                    return new TransactionInfo(true, transactionId, dataInfo.getStatus(), dataInfo.getRetryTransactionId(), dataInfo.getType(), dataInfo.getPcd(), null);
                }
            }
            return null;
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public TransactionStatus getTransactionStatus(String transactionId) throws EKasaException {
        try {
            String chduSn = this.chduSN;
            if (chduSn == null) {
                logger.info("CHDU.getTransactionStatus - NO CHDU SN");
            } else {
                ChduTransaction request = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId);
                if (request != null) {
                    ChduTransaction response = this.getChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_RESPONSE, transactionId);
                    SfsDataRequest sfsRequest = new SfsDataRequest(request.getData());
                    if (response != null) {
                        SfsDataResponse sfsResponse = new SfsDataResponse(response.getData());
                        TransactionStatus tStatus = new TransactionStatus(this.chduSN, sfsRequest.getRequestType(), sfsRequest.getRequest(), sfsRequest.getMessageUuid(), transactionId, sfsResponse.getStatus(), sfsRequest.getOriginTransactionId() == null ? transactionId : sfsRequest.getOriginTransactionId(), sfsRequest.getRetryTransactionId(), null, sfsResponse.getQrCode(), sfsRequest.getParagonCopyPrint(), sfsRequest.getUnsendReport(), sfsRequest.getCreateDate(), sfsRequest.getReceiptNumber(), sfsRequest.getRetryCounter());
                        return tStatus;
                    }
                }
            }
            return null;
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(9L, (Throwable)e);
        }
    }

    public TransactionStatusChain getTransactionStatusChain(String transactionId) throws EKasaException {
        TransactionStatus tStatus = this.getTransactionStatus(transactionId);
        if (tStatus == null) {
            return null;
        }
        TransactionStatusChain chain = new TransactionStatusChain(tStatus);
        while (tStatus.getRetryTransactionId() != null) {
            TransactionStatus rStatus = this.getTransactionStatus(tStatus.getRetryTransactionId());
            if (rStatus == null) {
                throw new EKasaException(9L);
            }
            TransactionStatusChain rChain = new TransactionStatusChain(rStatus);
            rStatus.setNextTransactionId(tStatus.getTransactionId());
            chain.setPrevTransactionStatus(rChain);
            rChain.setNextTransactionStatus(chain);
            chain = rChain;
            tStatus = rStatus;
        }
        return chain;
    }

    private synchronized boolean connectToChdu(Chdu _chdu) throws ChduException {
        if (this.connectionState != ConnectionState.Connected) {
            _chdu.connect();
            this.chdu = _chdu;
            this.connectionState = ConnectionState.Connected;
            return true;
        }
        return false;
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void updateInfo() throws ChduException, EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ReadResult readResult = this.chdu.readOthers(Others.Read.SyncAndInfoData, new Date(), baos);
        SyncAndInfo syncAndInfo = null;
        if (readResult.isOK()) {
            try {
                syncAndInfo = SyncAndInfo.CreateInstance(baos.toByteArray());
            }
            catch (CommandException e) {
                throw new EKasaException(9L);
            }
        } else {
            throw new EKasaException(9L);
        }
        Transaction.ID lastTransactionId = new Transaction.ID(syncAndInfo.getLastTransactionId());
        Transaction.ID lastPrintTransactionId = new Transaction.ID(syncAndInfo.getLastPrintedTransactionId());
        if (lastTransactionId.compareTo(lastPrintTransactionId) < 0) {
            this.transactionID.setId(lastPrintTransactionId);
        } else {
            this.transactionID.setId(lastTransactionId);
        }
        this.chduType = syncAndInfo.getName();
        this.chduVersion = String.valueOf(syncAndInfo.getVersion()) + "." + syncAndInfo.getSubVersion();
        this.chduRelease = syncAndInfo.getRelease();
        this.chduSN = syncAndInfo.getSerialNumber();
    }

    public void initChdu() throws EKasaException {
        logger.info("Initializing CHDU: " + Thread.currentThread().getId());
        try {
            WriteResult writeResult = this.chdu.poll(Polling.Type.State, new Date());
            if (!writeResult.isOK()) {
                this.chdu.poll(Polling.Type.CancelProcess, new Date());
            }
        }
        catch (Exception e) {
            logger.error(String.valueOf(e.getMessage()) + ": " + Thread.currentThread().getId());
            throw new EKasaException(9L);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ReadResult readResult = null;
        try {
            readResult = this.chdu.readOthers(Others.Read.SyncAndInfoData, new Date(), baos);
        }
        catch (ChduException e1) {
            logger.error("Error cloading sync and info");
            throw new EKasaException(9L);
        }
        SyncAndInfo syncAndInfo = null;
        if (readResult.isOK()) {
            try {
                syncAndInfo = SyncAndInfo.CreateInstance(baos.toByteArray());
            }
            catch (CommandException e) {
                logger.error("Error creating syncAndInfo class instance");
                throw new EKasaException(9L);
            }
        } else {
            logger.error("Error loading CHDU syncAndInfo data");
            throw new EKasaException(9L);
        }
        Transaction.ID lastTransactionId = new Transaction.ID(syncAndInfo.getLastTransactionId());
        Transaction.ID lastPrintTransactionId = new Transaction.ID(syncAndInfo.getLastPrintedTransactionId());
        if (lastTransactionId.compareTo(lastPrintTransactionId) < 0) {
            this.transactionID.setId(lastPrintTransactionId);
        } else {
            this.transactionID.setId(lastTransactionId);
        }
        this.chduType = syncAndInfo.getName();
        this.chduVersion = String.valueOf(syncAndInfo.getVersion()) + "." + syncAndInfo.getSubVersion();
        this.chduRelease = syncAndInfo.getRelease();
        this.chduSN = syncAndInfo.getSerialNumber();
        if (this.chduType == null || this.chduType.isEmpty()) {
            logger.error("Error loading chduType info");
            throw new EKasaException(9L);
        }
        if (this.chduVersion == null || this.chduVersion.isEmpty()) {
            logger.error("Error loading chduVersion info");
            throw new EKasaException(9L);
        }
        if (this.chduRelease == null || this.chduRelease.isEmpty()) {
            logger.error("Error loading chduRelease info");
            throw new EKasaException(9L);
        }
        if (this.chduSN == null || this.chduSN.isEmpty()) {
            logger.error("Error loading chduSN info");
            throw new EKasaException(9L);
        }
        this.autoConnectionScheduler.startScheduler();
        if (this.chduListener != null) {
            this.chduListener.onChduConnect(this);
        }
    }

    private class AutoConnectionScheduler {
        private AtomicBoolean isAutoConnectionRunning = new AtomicBoolean();
        private ScheduledExecutorService ses;
        private int sesCount;

        private AutoConnectionScheduler() {
        }

        private void startScheduler() {
            try {
                String conStr = CHDU.this.ppekk.getConfiguration(CHDU.this.uuid).getConfiguration().getChduConnectionString();
                if (!Configuration.isChduCommunicationAutoConnectionEnabled() || conStr == null || conStr.isEmpty()) {
                    return;
                }
            }
            catch (EKasaException e1) {
                return;
            }
            if (this.ses != null) {
                this.ses.shutdown();
                this.ses = null;
            }
            this.sesCount = Configuration.getChduAutoReconnectionCount();
            this.ses = Executors.newScheduledThreadPool(1);
            logger.info("Autoconnection sheduler starting");
            this.isAutoConnectionRunning.set(false);
            CHDU.this.communicationTimestamp.set(System.currentTimeMillis());
            this.ses.scheduleAtFixedRate(new ConnectRunable(), 0L, Configuration.getCchduAutoConnectionRepeatTime(), TimeUnit.MILLISECONDS);
        }

        private void stopScheduler() {
            logger.debug("Keepalive sheduler shutdown");
            if (this.ses != null) {
                this.ses.shutdown();
                this.ses = null;
            }
        }

        private class ConnectRunable
        implements Runnable {
            private ConnectRunable() {
            }

            @Override
            public void run() {
                try {
                    if (CHDU.this.connectionState != ConnectionState.Disconnected) {
                        return;
                    }
                    if (AutoConnectionScheduler.this.sesCount == 0) {
                        return;
                    }
                    try {
                        AutoConnectionScheduler autoConnectionScheduler = AutoConnectionScheduler.this;
                        autoConnectionScheduler.sesCount = autoConnectionScheduler.sesCount - 1;
                        String connectionString = CHDU.this.ppekk.getConfiguration(CHDU.this.uuid).getConfiguration().getChduConnectionString();
                        String secondaryConnectionString = "";
                        if (CHDU.this.ppekk.getConfiguration(CHDU.this.uuid).getConfiguration().getChduConnectionStringAlt() != null && CHDU.this.ppekk.getConfiguration(CHDU.this.uuid).getConfiguration().getChduConnectionStringAlt().length > 0) {
                            secondaryConnectionString = CHDU.this.ppekk.getConfiguration(CHDU.this.uuid).getConfiguration().getChduConnectionStringAlt()[0];
                        }
                        AutoConnectionScheduler.this.isAutoConnectionRunning.set(true);
                        logger.info("Autoconnection started, remaining: " + AutoConnectionScheduler.this.sesCount);
                        Chdu _chdu = ChduFactory.createInstance(connectionString, secondaryConnectionString);
                        if (CHDU.this.connectToChdu(_chdu)) {
                            CHDU.this.initChdu();
                        }
                        logger.info("Autoconnection success");
                    }
                    catch (Exception e) {
                        CHDU.this.connectionState = ConnectionState.Disconnected;
                        logger.error("Autoconnection sheduler exception: " + e);
                    }
                }
                finally {
                    AutoConnectionScheduler.this.isAutoConnectionRunning.set(false);
                }
            }
        }
    }

    static enum AutoConnectionSchedulerState {
        Initialized,
        Started,
        Running,
        FinishedOK,
        FinishedErr;

    }

    private static enum ConnectionState {
        Created,
        Connected,
        Disconnected;

    }

    private class ConnectionStatusChangedListener
    implements SessionLayer.SessionLayerListener {
        private ConnectionStatusChangedListener() {
        }

        @Override
        public void OnConnected() {
        }

        @Override
        public void OnDisconnected() {
            CHDU.this.connectionState = ConnectionState.Disconnected;
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduDisconnect(CHDU.this);
            }
        }

        @Override
        public void OnCommandTransmitionStarted() {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketTransmitStart();
            }
        }

        @Override
        public void OnCommandFrameTransmitted(int sent) {
        }

        @Override
        public void OnCommandTransmitted(long totalSent) {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketTransmitEnd(false);
            }
        }

        @Override
        public void OnCommandTransmitionError() {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketTransmitEnd(true);
            }
        }

        @Override
        public void OnCommandReceiveStarted() {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketReceiveStart();
            }
        }

        @Override
        public void OnCommandFrameReceived(int received) {
        }

        @Override
        public void OnCommandReceived(long totalReceived) {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketReceiveEnd(false);
            }
        }

        @Override
        public void onCommandReceivingError() {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduPacketReceiveEnd(true);
            }
        }
    }

    private class RttStatusChangedListener
    implements SessionLayer.OnRttStatusChangedListener {
        private ConnectionInfo info;

        RttStatusChangedListener(ConnectionInfo info) {
            this.info = info;
        }

        @Override
        public void OnChange(long rtt) {
            this.info.setRtt(rtt);
        }
    }

    private class TransactionIDListener
    implements Transaction.IDListener {
        private TransactionIDListener() {
        }

        @Override
        public void onChduTransactionIdChanged(Object source, int oldDirSeq, int newDirSeq, int oldTransSeq, int newTransSeq, String transactionId) {
            if (CHDU.this.chduListener != null) {
                CHDU.this.chduListener.onChduTransactionIdChanged(CHDU.this, new Transaction.ID(oldDirSeq, oldTransSeq), new Transaction.ID(newDirSeq, newTransSeq));
            }
        }
    }

    private class TransportLayerListener
    implements TransportLayer.Listener {
        private ConnectionInfo info;

        TransportLayerListener(ConnectionInfo info) {
            this.info = info;
        }

        public void reset() {
            this.info.reset();
        }

        @Override
        public void onPacketCrcError() {
            this.info.incrementCrcErrors();
        }

        @Override
        public void onPacketHeaderError() {
            this.info.incrementHeaderErrors();
        }

        @Override
        public void onPacketTransmitted(int length, boolean error) {
            this.info.incrementPacketsTransmitted();
        }

        @Override
        public void onPacketReceived(int length, boolean error) {
            this.info.incrementPacketsReceived();
        }
    }
}

