/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.PPEKKAuthentication;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.chdu.ChduTransaction;
import sk.singularisdev.ekasask.enumeration.AUTHENTICATION_ALERT_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.utils.CertificateValidator;

public class ChduCertificateValidator {
    private UUID uuid;
    private PPEKK ppekk;
    private String lastValidationDate = "01.01.1900";
    private AUTHENTICATION_ALERT_TYPE lastAlertType = null;

    private ChduCertificateValidator(UUID uuid, PPEKK ppekk) {
        this.uuid = uuid;
        this.ppekk = ppekk;
    }

    public static ChduCertificateValidator getInstance(UUID uuid, PPEKK ppekk) {
        return new ChduCertificateValidator(uuid, ppekk);
    }

    public void validate() {
        this.lastAlertType = null;
        try {
            AbstractPrinter printer;
            PPEKKAuthentication auth;
            PPEKKSetup cfg;
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            Date nowDate = new Date();
            String now = sdf.format(nowDate);
            if (!now.equals(this.lastValidationDate) && (cfg = this.ppekk.getChduConfiguration(this.uuid)) != null && (auth = cfg.getAuthentication()) != null && (printer = this.ppekk.getPrinter()) != null) {
                CertificateValidator validator = new CertificateValidator(auth.getAuthentication(), auth.getAuthenticationPassword());
                if (validator.isValid()) {
                    if (nowDate.after(validator.getValidTo())) {
                        this.lastAlertType = AUTHENTICATION_ALERT_TYPE.END_ALERT;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                        ArrayList<String> texts = new ArrayList<String>();
                        Printer.splitText(texts, Localization.getString("error.authentication.valid_date_end"), printer.getCharPerRow());
                        for (String text : texts) {
                            baos.write(text.getBytes(printer.getCharset()));
                            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        }
                        String d = sdf.format(validator.getValidTo());
                        baos.write(Printer.alignText(printer, d, PRINT_ALIGNMENT.CENTER));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                        ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.ppekk.getCHDU(this.uuid).generTransactionId(), baos.toByteArray());
                        this.ppekk.getCHDU(this.uuid).setChduTransaction(transaction);
                    } else {
                        Calendar c1 = Calendar.getInstance();
                        c1.setTime(nowDate);
                        Calendar c2 = Calendar.getInstance();
                        c2.setTime(validator.getValidTo());
                        c1.add(5, 30);
                        if (c1.after(c2)) {
                            this.lastAlertType = AUTHENTICATION_ALERT_TYPE.NEAR_TO_END_ALERT;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                            ArrayList<String> texts = new ArrayList<String>();
                            Printer.splitText(texts, Localization.getString("error.authentication.valid_date_near_end"), printer.getCharPerRow());
                            for (String text : texts) {
                                baos.write(text.getBytes(printer.getCharset()));
                                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                            }
                            String d = sdf.format(validator.getValidTo());
                            baos.write(Printer.alignText(printer, d, PRINT_ALIGNMENT.CENTER));
                            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                            ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.ppekk.getCHDU(this.uuid).generTransactionId(), baos.toByteArray());
                            this.ppekk.getCHDU(this.uuid).setChduTransaction(transaction);
                        }
                    }
                } else {
                    this.lastAlertType = AUTHENTICATION_ALERT_TYPE.INVALID_ALERT;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT));
                    ArrayList<String> texts = new ArrayList<String>();
                    Printer.splitText(texts, Localization.getString("error.authentication.invalid"), printer.getCharPerRow());
                    for (String text : texts) {
                        baos.write(text.getBytes(printer.getCharset()));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    }
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.OREZ));
                    ChduTransaction transaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.LPT, this.ppekk.getCHDU(this.uuid).generTransactionId(), baos.toByteArray());
                    this.ppekk.getCHDU(this.uuid).setChduTransaction(transaction);
                }
                this.lastValidationDate = now;
            }
        }
        catch (EKasaException eKasaException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AUTHENTICATION_ALERT_TYPE getLastAlertType() {
        return this.lastAlertType;
    }
}

