/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import sk.singularisdev.ekasask.utils.Utility;

public class ChduTransaction {
    private TRANSACTION_TYPE type;
    private String transactionId;
    private byte[] data;

    public ChduTransaction(TRANSACTION_TYPE type, String transactionId) {
        this(type, transactionId, new byte[0]);
    }

    public ChduTransaction(TRANSACTION_TYPE type, String transactionId, byte[] data) {
        this.type = type;
        this.transactionId = transactionId;
        this.data = data;
    }

    public TRANSACTION_TYPE getType() {
        return this.type;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ChduTransaction obj = (ChduTransaction)o;
        return Utility.equals(this.data, obj.data) && Utility.equals((Object)this.type, (Object)obj.type) && Utility.equals(this.transactionId, obj.transactionId);
    }

    public static enum TRANSACTION_TYPE {
        SFS_REQUEST("request"),
        SFS_RESPONSE("response"),
        SFS_STATUS("status"),
        LPT("lpt");

        private String type;

        private TRANSACTION_TYPE(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public static TRANSACTION_TYPE getValue(String type) {
            TRANSACTION_TYPE[] tRANSACTION_TYPEArray = TRANSACTION_TYPE.values();
            int n = tRANSACTION_TYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                TRANSACTION_TYPE e = tRANSACTION_TYPEArray[n2];
                if (e.type.equals(type)) {
                    return e;
                }
                ++n2;
            }
            return null;
        }
    }
}

