/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.util.concurrent.atomic.AtomicLong;

public class ConnectionInfo {
    private AtomicLong rtt = new AtomicLong();
    private AtomicLong crcErrrors = new AtomicLong();
    private AtomicLong headerErrors = new AtomicLong();
    private AtomicLong packetReceivedCount = new AtomicLong();
    private AtomicLong packetTransmittedCount = new AtomicLong();

    public ConnectionInfo() {
        this.rtt.set(0L);
        this.crcErrrors.set(0L);
        this.headerErrors.set(0L);
        this.packetReceivedCount.set(0L);
    }

    public void reset() {
        this.rtt.set(0L);
        this.crcErrrors.set(0L);
        this.headerErrors.set(0L);
        this.packetReceivedCount.set(0L);
    }

    public void incrementPacketsReceived() {
        this.packetReceivedCount.getAndIncrement();
    }

    public void incrementPacketsTransmitted() {
        this.packetReceivedCount.getAndIncrement();
    }

    public void incrementHeaderErrors() {
        this.headerErrors.getAndIncrement();
    }

    public void incrementCrcErrors() {
        this.crcErrrors.getAndIncrement();
    }

    public void setRtt(long rtt) {
        this.rtt.set(rtt);
    }

    public long getRtt() {
        return this.rtt.get();
    }

    public long getCrcErrrors() {
        return this.crcErrrors.get();
    }

    public long getHeaderErrors() {
        return this.headerErrors.get();
    }

    public long getPacketReceivedCount() {
        return this.packetReceivedCount.get();
    }

    public long getPacketTransmittedCount() {
        return this.packetTransmittedCount.get();
    }

    public String toString() {
        return new String("{rtt=" + this.rtt.get() + "; crcErrrors: " + this.crcErrrors.get() + "; headerErrors: " + this.headerErrors.get() + "; packetReceivedCount: " + this.packetReceivedCount.get() + "; packetTransmittedCount: " + this.packetTransmittedCount.get() + "}");
    }
}

