/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import sk.singularisdev.chdu.parameter.Transaction;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.utils.Utility;

public class SfsDataInfo {
    private int status;
    private String retryTransactionId;
    private char type;
    private String pcd;

    public SfsDataInfo(int status, String retryTransactionId, char type, String pcd) {
        this.retryTransactionId = retryTransactionId;
        this.status = status;
        this.type = type;
        this.pcd = pcd;
    }

    public SfsDataInfo(byte[] data) throws UnsupportedEncodingException, ParseException, EKasaException {
        this.deserialize(data);
    }

    public int getStatus() {
        return this.status;
    }

    public String getRetryTransactionId() {
        return this.retryTransactionId;
    }

    public char getType() {
        return this.type;
    }

    public String getPcd() {
        return this.pcd;
    }

    public byte[] serialize() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder sb = new StringBuilder();
        sb.append(this.status);
        sb.append("|");
        sb.append(this.retryTransactionId == null ? "" : this.retryTransactionId);
        sb.append("|");
        sb.append(this.type);
        sb.append("|");
        sb.append(this.pcd);
        baos.write(sb.toString().getBytes("US-ASCII"));
        return baos.toByteArray();
    }

    public void deserialize(byte[] data) throws UnsupportedEncodingException, ParseException, EKasaException {
        String[] x = new String(data, "US-ASCII").split("\\|");
        this.retryTransactionId = null;
        this.type = (char)32;
        this.pcd = "000000/0";
        this.status = Integer.parseInt(x[0]);
        if (x.length > 1) {
            this.retryTransactionId = x[1];
            try {
                if (this.retryTransactionId == null || this.retryTransactionId.equals("")) {
                    this.retryTransactionId = null;
                } else {
                    Transaction.ID tId = new Transaction.ID(this.retryTransactionId);
                    this.retryTransactionId = tId.format();
                }
            }
            catch (Exception e) {
                this.retryTransactionId = null;
            }
            if (x.length > 2) {
                this.type = x[2].charAt(0);
            }
            if (x.length > 3) {
                this.pcd = x[3];
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SfsDataInfo obj = (SfsDataInfo)o;
        return Utility.equals(this.status, obj.status) && Utility.equals(this.retryTransactionId, obj.retryTransactionId) && Utility.equals(Character.valueOf(this.type), Character.valueOf(obj.type));
    }
}

