/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.utils.ChduSerialize;
import sk.singularisdev.ekasask.utils.Utility;

public class SfsDataRequest {
    private static final String PARAM_REQUEST_TYPE = "RequestType";
    private static final String PARAM_CREATE_DATE = "CreateDate";
    private static final String PARAM_RECEIPT_NUMBER = "ReceiptNumber";
    private static final String PARAM_REQUEST = "Request";
    private static final String PARAM_QR_CODE = "QrCode";
    private static final String PARAM_PARAGON_COPY = "ParagonCopy";
    private static final String PARAM_UNSEND_REPORT = "UnsendReport";
    private static final String PARAM_RETRY_COUNTER = "RetryCounter";
    private static final String PARAM_RETRY_TRANSACTION_ID = "RetryTransactionId";
    private static final String PARAM_ORIGIN_TRANSACTION_ID = "OriginTransactionId";
    private static final String PARAM_UUID = "UUID";
    private RequestType requestType;
    private Date createDate;
    private String receiptNumber;
    private String request;
    private String qrCode;
    private byte[] paragonCopyPrint;
    private String unsendReport;
    private String retryTransactionId;
    private String originTransactionId;
    private int retryCounter;
    private UUID messageUuid;

    public SfsDataRequest(RequestType requestType, Date createDate, String receiptNumber, String request, String qrCode, byte[] paragonCopyPrint, String unsendReport, String retryTransactionId, String originTransactionId, UUID uuid, int retryCounter) {
        this.requestType = requestType;
        this.createDate = createDate;
        this.receiptNumber = receiptNumber;
        this.request = request;
        this.qrCode = qrCode;
        this.paragonCopyPrint = paragonCopyPrint;
        this.unsendReport = unsendReport;
        this.retryTransactionId = retryTransactionId;
        this.originTransactionId = originTransactionId;
        this.messageUuid = uuid;
        this.retryCounter = retryCounter;
    }

    public SfsDataRequest(byte[] data) throws UnsupportedEncodingException, ParseException, EKasaException {
        this.deserialize(data);
    }

    public SfsDataRequest(TransactionStatus transactionStatus) {
        this.requestType = transactionStatus.getRequestType();
        this.createDate = transactionStatus.getCreationDate();
        this.receiptNumber = transactionStatus.getReceiptNumber();
        this.request = transactionStatus.getRequest();
        this.qrCode = transactionStatus.getQrCode();
        this.paragonCopyPrint = transactionStatus.getParagonCopy();
        this.unsendReport = transactionStatus.getUnsendReport();
        this.retryTransactionId = transactionStatus.getRetryTransactionId();
        this.originTransactionId = transactionStatus.getOriginTransactionId();
        this.messageUuid = transactionStatus.getMessageUuid();
        this.retryCounter = transactionStatus.getCounter();
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public byte[] getParagonCopyPrint() {
        return this.paragonCopyPrint;
    }

    public void setParagonCopyPrint(byte[] paragonCopyPrint) {
        this.paragonCopyPrint = paragonCopyPrint;
    }

    public String getUnsendReport() {
        return this.unsendReport;
    }

    public void setUnsendReport(String unsendReport) {
        this.unsendReport = unsendReport;
    }

    public String getRetryTransactionId() {
        return this.retryTransactionId;
    }

    public void setRetryTransactionId(String retryTransactionId) {
        this.retryTransactionId = retryTransactionId;
    }

    public String getOriginTransactionId() {
        return this.originTransactionId;
    }

    public void setOriginTransactionId(String originTransactionId) {
        this.originTransactionId = originTransactionId;
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public void setMessageUuid(UUID uuid) {
        this.messageUuid = uuid;
    }

    public int getRetryCounter() {
        return this.retryCounter;
    }

    public void setRetryCounter(int retryCounter) {
        this.retryCounter = retryCounter;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public byte[] serialize() throws UnsupportedEncodingException, IOException {
        ChduSerialize chduFile = new ChduSerialize("UTF8");
        chduFile.setValue(PARAM_REQUEST_TYPE, this.requestType.name());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        chduFile.setValue(PARAM_CREATE_DATE, sdf.format(this.createDate));
        if (this.receiptNumber != null) {
            chduFile.setValue(PARAM_RECEIPT_NUMBER, this.receiptNumber);
        }
        chduFile.setValue(PARAM_REQUEST, this.request);
        if (this.qrCode != null) {
            chduFile.setValue(PARAM_QR_CODE, this.qrCode);
        }
        if (this.paragonCopyPrint != null) {
            chduFile.setValue(PARAM_PARAGON_COPY, this.paragonCopyPrint);
        }
        if (this.unsendReport != null) {
            chduFile.setValue(PARAM_UNSEND_REPORT, this.unsendReport);
        }
        chduFile.setValue(PARAM_RETRY_COUNTER, "" + this.retryCounter);
        if (this.retryTransactionId != null) {
            chduFile.setValue(PARAM_RETRY_TRANSACTION_ID, this.retryTransactionId);
        }
        if (this.originTransactionId != null) {
            chduFile.setValue(PARAM_ORIGIN_TRANSACTION_ID, this.originTransactionId);
        }
        chduFile.setValue(PARAM_UUID, this.messageUuid.toString());
        return chduFile.getContent();
    }

    public void deserialize(byte[] data) throws UnsupportedEncodingException, ParseException, EKasaException {
        ChduSerialize chduFile = new ChduSerialize("UTF8");
        chduFile.setContent(data);
        String type = chduFile.getString(PARAM_REQUEST_TYPE);
        if (type.equals(RequestType.LOCATION.name())) {
            this.requestType = RequestType.LOCATION;
        } else if (type.equals(RequestType.RECEIPT.name())) {
            this.requestType = RequestType.RECEIPT;
        } else {
            throw new EKasaException(9L);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String value = chduFile.getString(PARAM_CREATE_DATE);
        this.createDate = value == null ? null : sdf.parse(value);
        this.receiptNumber = chduFile.getString(PARAM_RECEIPT_NUMBER);
        this.request = chduFile.getString(PARAM_REQUEST);
        this.qrCode = chduFile.getString(PARAM_QR_CODE);
        this.paragonCopyPrint = chduFile.getBytes(PARAM_PARAGON_COPY);
        this.unsendReport = chduFile.getString(PARAM_UNSEND_REPORT);
        this.retryCounter = Integer.parseInt(chduFile.getString(PARAM_RETRY_COUNTER));
        this.retryTransactionId = chduFile.getString(PARAM_RETRY_TRANSACTION_ID);
        this.originTransactionId = chduFile.getString(PARAM_ORIGIN_TRANSACTION_ID);
        this.messageUuid = UUID.fromString(chduFile.getString(PARAM_UUID));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SfsDataRequest obj = (SfsDataRequest)o;
        return Utility.equals(this.paragonCopyPrint, obj.paragonCopyPrint) && Utility.equals((Object)this.requestType, (Object)obj.requestType) && Utility.equals(this.createDate, obj.createDate) && Utility.equals(this.receiptNumber, obj.receiptNumber) && Utility.equals(this.request, obj.request) && Utility.equals(this.qrCode, obj.qrCode) && Utility.equals(this.retryTransactionId, obj.retryTransactionId) && Utility.equals(this.messageUuid, obj.messageUuid) && Utility.equals((Object)this.requestType, (Object)obj.requestType) && Utility.equals(this.originTransactionId, obj.originTransactionId);
    }

    public static enum RequestType {
        RECEIPT('R'),
        LOCATION('L');

        private char shortage;

        private RequestType(char shortage) {
            this.shortage = shortage;
        }

        public char getShortage() {
            return this.shortage;
        }
    }
}

