/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import sk.singularisdev.ekasask.utils.ChduSerialize;
import sk.singularisdev.ekasask.utils.Utility;

public class SfsDataResponse {
    private static final String PARAM_STATUS = "Status";
    private static final String PARAM_ERROR_MESSAGE = "ErrorMessage";
    private static final String PARAM_QRCODE = "QrCode";
    private static final String PARAM_ORIGIN_TRANSACTION_ID = "OriginTransactionId";
    private static final String PARAM_RESPONSE = "Response";
    private String response;
    private int status;
    private String errorMessage;
    private String qrCode;
    private String originTransactionId;

    public SfsDataResponse(String response, int status, String errorMessage, String qrCode, String originTransactionId) {
        this.response = response;
        this.status = status;
        this.errorMessage = errorMessage;
        this.qrCode = qrCode;
        this.originTransactionId = originTransactionId;
    }

    public SfsDataResponse(byte[] data) throws UnsupportedEncodingException {
        this.deserialize(data);
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getOriginTransactionId() {
        return this.originTransactionId;
    }

    public void setOriginTransactionId(String originTransactionId) {
        this.originTransactionId = originTransactionId;
    }

    public byte[] serialize() throws UnsupportedEncodingException, IOException {
        ChduSerialize chduFile = new ChduSerialize("UTF8");
        chduFile.setValue(PARAM_STATUS, "" + this.status);
        if (this.errorMessage != null) {
            chduFile.setValue(PARAM_ERROR_MESSAGE, this.errorMessage);
        }
        if (this.qrCode != null) {
            chduFile.setValue(PARAM_QRCODE, this.qrCode);
        }
        if (this.originTransactionId != null) {
            chduFile.setValue(PARAM_ORIGIN_TRANSACTION_ID, this.originTransactionId);
        }
        chduFile.setValue(PARAM_RESPONSE, this.response == null ? "" : this.response);
        return chduFile.getContent();
    }

    public void deserialize(byte[] data) throws UnsupportedEncodingException {
        ChduSerialize chduFile = new ChduSerialize("UTF8");
        chduFile.setContent(data);
        this.status = Integer.parseInt(chduFile.getString(PARAM_STATUS));
        this.errorMessage = chduFile.getString(PARAM_ERROR_MESSAGE);
        this.qrCode = chduFile.getString(PARAM_QRCODE);
        this.response = chduFile.getString(PARAM_RESPONSE);
        this.originTransactionId = chduFile.getString(PARAM_ORIGIN_TRANSACTION_ID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SfsDataResponse obj = (SfsDataResponse)o;
        return Utility.equals(this.status, obj.status) && Utility.equals(this.response, obj.response) && Utility.equals(this.errorMessage, obj.errorMessage) && Utility.equals(this.qrCode, obj.qrCode) && Utility.equals(this.originTransactionId, obj.originTransactionId);
    }
}

