/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.chdu;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Upgrade {
    private InputStream inputStream;
    private ByteArrayOutputStream signOutputStream;
    private ByteArrayOutputStream firmwareOutputStream;

    Upgrade(InputStream inputStream) {
        this.inputStream = inputStream;
        this.signOutputStream = new ByteArrayOutputStream(1024);
        this.firmwareOutputStream = new ByteArrayOutputStream(32768);
    }

    void createInputStreams(InputStream signInputStream, InputStream firmwareInputStream) {
    }

    public InputStream createSignInputStream() {
        return new ByteArrayInputStream(this.signOutputStream.toByteArray());
    }

    public InputStream createFirmwareInputStream() {
        return new ByteArrayInputStream(this.firmwareOutputStream.toByteArray());
    }

    void decode() throws IOException {
        ZipInputStream zis = new ZipInputStream(this.inputStream);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            int len;
            ByteArrayOutputStream baos;
            String name = zipEntry.getName();
            if (name.endsWith(".sig")) {
                baos = this.signOutputStream;
            } else if (name.endsWith(".bin")) {
                baos = this.firmwareOutputStream;
            } else {
                zipEntry = zis.getNextEntry();
                continue;
            }
            byte[] buffer = new byte[1024];
            while ((len = zis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            baos.close();
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }
}

