/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sk.singularisdev.ekasask.Constant;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.command.ItemBarcode;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.PrintInterface;
import sk.singularisdev.ekasask.command.ReceiptNumberInterface;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;
import sk.singularisdev.ekasask.utils.EKasaXML;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public class CashOut
extends AbstractCommand
implements ReceiptNumberInterface,
EKasaServerMessageInterface,
PrintInterface {
    public static final String RECEIPT_TYPE = "VY";
    private static final boolean PRINT_INVALID = false;
    private List<MessageItemInterfaceParagon> items = new ArrayList<MessageItemInterfaceParagon>();
    private int logoHeader = 0;
    private int logoFooter = 0;
    private boolean autoCutter = true;
    private Date issueDate;
    private Date createDate;
    private long receiptNumber;
    private String additionalHeader;
    private String additionalFooter;
    private long amount;

    private CashOut() {
    }

    public static CashOut getInstance() {
        return new CashOut();
    }

    @Override
    public String getType() {
        return RECEIPT_TYPE;
    }

    public void setLogoHeader(int index) {
        this.logoHeader = index;
    }

    public int getLogoHeader() {
        return this.logoHeader;
    }

    public void setLogoFooter(int index) {
        this.logoFooter = index;
    }

    public int getLogoFooter() {
        return this.logoFooter;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public long getReceiptNumber() {
        return this.receiptNumber;
    }

    @Override
    public void setReceiptNumber(long receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public void addItem(MessageItemInterfaceParagon item) throws EKasaException {
        if (!(item instanceof ItemPrint) && !(item instanceof ItemBarcode)) {
            throw new EKasaException(5L);
        }
        this.items.add(item);
    }

    public String getAdditionalHeader() {
        return this.additionalHeader;
    }

    public void setAdditionalHeader(String additionalHeader) {
        this.additionalHeader = additionalHeader;
    }

    public String getAdditionalFooter() {
        return this.additionalFooter;
    }

    public void setAdditionalFooter(String additionalFooter) {
        this.additionalFooter = additionalFooter;
    }

    @Override
    public int generReceiptBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row) throws EKasaException {
        try {
            if (this.createDate.before(Constant.EKASA_START_DATE)) {
                throw new EKasaException(47L);
            }
            if (this.issueDate.before(Constant.EKASA_START_DATE)) {
                throw new EKasaException(47L);
            }
            IdentityData identity = configuration.getIdentity().getIdentity();
            if (identity == null) {
                throw new EKasaException(28L);
            }
            if (this.logoHeader > 0) {
                baos.write(printer.printNvImage(this.logoHeader));
            }
            baos.write(Printer.alignText(printer, Localization.getString("paragon.cash_out"), PRINT_ALIGNMENT.CENTER));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, false);
            row = Printer1.generHeader(printer, configuration, deviceId, baos, row, false);
            row = Printer1.generAdditionalHeader(printer, configuration, baos, row, false, this.additionalHeader);
            long amount = this.getAmount();
            int l = this.items.size();
            int i = 0;
            while (i < l) {
                row = this.items.get(i).generPrintData(printer, configuration, baos, row, "", false, MessageItemInterface.SECTION_TYPE.MAIN);
                ++i;
            }
            row = Printer1.alignRight(printer, configuration, baos, row, false, Localization.getString("paragon.cash_out.total_amount"), Printer.formatNumber(amount, 2, 9));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, false);
            baos.write(Printer.replaceEsc(printer, printer.getDoubleSeparator()).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, false);
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(Localization.getString("paragon.dkp"));
            sb.append(Localization.getString(":"));
            sb.append(Printer.formatString(identity.getOrganizationUnit().getCashRegisterCode(), 18, true));
            StringBuilder sb1 = new StringBuilder();
            sb1.append(Localization.getString("paragon.sn"));
            sb1.append(Localization.getString(":"));
            sb1.append(Printer.formatString(tpg, 12, true));
            row = Printer1.printField(printer.getCharPerRow(), configuration, false, printer, baos, row, true, new String[]{sb.toString(), sb1.toString()});
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            sb.setLength(0);
            sb.append(Printer.formatString(sdf.format(this.createDate), 20, true));
            sb1.setLength(0);
            sb1.append(Printer.formatString(Localization.getString("paragon.number"), 3, false));
            sb1.append(":");
            sdf = new SimpleDateFormat("yyyyMM");
            sb1.append(sdf.format(this.createDate));
            sb1.append("/");
            sb1.append(String.format("%05d", this.receiptNumber));
            row = Printer1.printField(printer.getCharPerRow(), configuration, false, printer, baos, row, true, new String[]{sb.toString(), sb1.toString()});
            row = Printer1.generFooter(printer, configuration, baos, row, false, this.additionalFooter);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public int generQrCodeBlock(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        row = Printer1.generQRCode(printer, configuration, baos, row, false, uid, pkp, okp, qrCode);
        return row;
    }

    @Override
    public void generFooterBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos) throws EKasaException {
        try {
            if (this.logoFooter > 0) {
                baos.write(printer.printNvImage(this.logoFooter));
            }
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public Receipt getSFSObject(PPEKKSetup configuration) {
        Receipt receipt = new Receipt();
        receipt.setAmount(EKasaXML.formatNumber(this.getAmount(), 2));
        receipt.setCreateDate(EKasaXML.formatDate(this.getCreateDate()));
        receipt.setReceiptNumber("" + this.receiptNumber);
        receipt.setIssueDate(EKasaXML.formatDate(this.getIssueDate()));
        receipt.setParagon(EKasaXML.formatBoolean(false));
        receipt.setReceiptType(RECEIPT_TYPE);
        return receipt;
    }

    public void setAutoCutter(boolean autoCutter) {
        this.autoCutter = autoCutter;
    }

    @Override
    public boolean isAutoCutter() {
        return this.autoCutter;
    }

    public void parse(Receipt receipt, PPEKKSetup configuration) throws Exception {
        CashOut r = this;
        r.setIssueDate(EKasaXML.parseDate(receipt.getIssueDate()));
        r.setCreateDate(EKasaXML.parseDate(receipt.getCreateDate()));
        r.setReceiptNumber(EKasaXML.getLongValue(receipt.getReceiptNumber(), 1));
        r.setAmount(EKasaXML.getLongValue(receipt.getAmount(), 100));
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.createDate.before(Constant.EKASA_START_DATE)) {
            throw new EKasaException(47L);
        }
        if (this.issueDate.before(Constant.EKASA_START_DATE)) {
            throw new EKasaException(47L);
        }
        if (this.amount < -1000000000L || this.amount > 1000000000L) {
            throw new EKasaException(52L);
        }
    }
}

